/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dv;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dv.MinimumPennTemplateAcceptor;
import edu.ucla.sspace.dv.PennTags;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MediumPennTemplateAcceptor
implements DependencyPathAcceptor {
    static final Set<String> MEDIUM_TEMPLATES = new HashSet<String>();
    static final Map<String, String> POS_TAG_TO_CLASS = new HashMap<String, String>();
    static final Map<String, String> REL_TO_CLASS;

    @Override
    public boolean accepts(DependencyPath dependencyPath) {
        return MediumPennTemplateAcceptor.acceptsInternal(dependencyPath);
    }

    static boolean acceptsInternal(DependencyPath dependencyPath) {
        int n;
        if (MinimumPennTemplateAcceptor.acceptsInternal(dependencyPath)) {
            return true;
        }
        if (dependencyPath.length() > 3) {
            return false;
        }
        int n2 = dependencyPath.length();
        StringBuilder stringBuilder = new StringBuilder(n2 * 16);
        StringBuilder stringBuilder2 = new StringBuilder(n2 * 16);
        StringBuilder stringBuilder3 = new StringBuilder(n2 * 16);
        DependencyTreeNode dependencyTreeNode = dependencyPath.first();
        for (n = 1; n < n2; ++n) {
            String string;
            DependencyTreeNode dependencyTreeNode2 = dependencyPath.getNode(n);
            if (dependencyTreeNode.word().equals("")) {
                return false;
            }
            String string2 = dependencyPath.getRelation(n - 1);
            String string3 = dependencyTreeNode.pos();
            String string4 = dependencyTreeNode2.pos();
            String string5 = POS_TAG_TO_CLASS.get(string3);
            String string6 = POS_TAG_TO_CLASS.get(string4);
            if (string5 != null) {
                string3 = string5;
            }
            if (string6 != null) {
                string4 = string6;
            }
            if ((string = REL_TO_CLASS.get(string2)) != null) {
                string2 = string;
            }
            stringBuilder.append(n == 1 ? "(null)" : string3);
            stringBuilder.append(":").append(string2).append(":").append(string4);
            stringBuilder2.append(string3).append(":").append(string2).append(":");
            stringBuilder2.append(n + 1 == n2 ? "(null)" : string4);
            stringBuilder3.append(string3).append(":").append(string2).append(":").append(string4);
            if (n + 1 < n2) {
                stringBuilder.append(",");
                stringBuilder2.append(",");
                stringBuilder3.append(",");
            }
            dependencyTreeNode = dependencyTreeNode2;
        }
        if (dependencyTreeNode.word().equals("")) {
            return false;
        }
        n = MEDIUM_TEMPLATES.contains(stringBuilder3.toString()) || MEDIUM_TEMPLATES.contains(stringBuilder.toString()) || MEDIUM_TEMPLATES.contains(stringBuilder2.toString()) ? 1 : 0;
        return n != 0;
    }

    @Override
    public int maxPathLength() {
        return 4;
    }

    static {
        for (String string : PennTags.NOUN_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "N");
        }
        for (String string : PennTags.ADJ_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "J");
        }
        for (String string : PennTags.ADV_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "R");
        }
        for (String string : PennTags.VERB_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "V");
        }
        REL_TO_CLASS = new HashMap<String, String>();
        for (String string : PennTags.MODIFIERS) {
            REL_TO_CLASS.put(string, "mod");
        }
        MEDIUM_TEMPLATES.add("J:nmod:N,N:amod:(null)");
        MEDIUM_TEMPLATES.add("J:nmod:N,N:vmod:(null)");
        MEDIUM_TEMPLATES.add("J:nmod:N,N:nmod:(null)");
        MEDIUM_TEMPLATES.add("J:nmod:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("J:sbj:N,N:amod:(null)");
        MEDIUM_TEMPLATES.add("J:sbj:N,N:nmod:(null)");
        MEDIUM_TEMPLATES.add("J:sbj:N,N:vmod:(null)");
        MEDIUM_TEMPLATES.add("J:sbj:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("R:nmod:N,N:amod:(null)");
        MEDIUM_TEMPLATES.add("R:nmod:N,N:vmod:(null)");
        MEDIUM_TEMPLATES.add("R:nmod:N,N:nmod:(null)");
        MEDIUM_TEMPLATES.add("R:nmod:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("R:sbj:N,N:amod:(null)");
        MEDIUM_TEMPLATES.add("R:sbj:N,N:vmod:(null)");
        MEDIUM_TEMPLATES.add("R:sbj:N,N:nmod:(null)");
        MEDIUM_TEMPLATES.add("R:sbj:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("N:coord:N,N:mod:(null)");
        MEDIUM_TEMPLATES.add("N:coord:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("N:gen:N,N:nmod:(null)");
        MEDIUM_TEMPLATES.add("N:gen:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:coord:N");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:coord:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:gen:N");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:gen:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:mod:A");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:mod:TO");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:obj:V");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:prd:V");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:sbj:A");
        MEDIUM_TEMPLATES.add("N:nmod:N,N:sbj:V");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:coord:N");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:coord:N,N:mod:(null)");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:gen:N");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:gen:N,N:mod:(null)");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:amod:J");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:adv:R");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:pmod:TO");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:obj:V");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:prd:V");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:sbj:J");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:sbj:R");
        MEDIUM_TEMPLATES.add("(null):mod:N,N:sbj:V");
        MEDIUM_TEMPLATES.add("TO:mod:N,N:mod:(null)");
        MEDIUM_TEMPLATES.add("TO:mod:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("V:obj:N,N:mod:(null)");
        MEDIUM_TEMPLATES.add("V:obj:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("V:sbj:N,N:mod:(null)");
        MEDIUM_TEMPLATES.add("V:sbj:N,N:nmod:N");
        MEDIUM_TEMPLATES.add("V:prd:N,N:mod:(null)");
        MEDIUM_TEMPLATES.add("V:prd:N,N:nmod:N");
    }
}

