/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dv;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dv.MinimumMiniparTemplateAcceptor;
import java.util.HashSet;
import java.util.Set;

public class MediumMiniparTemplateAcceptor
implements DependencyPathAcceptor {
    static final Set<String> MEDIUM_TEMPLATES = new HashSet<String>();

    @Override
    public boolean accepts(DependencyPath dependencyPath) {
        return MediumMiniparTemplateAcceptor.acceptsInternal(dependencyPath);
    }

    static boolean acceptsInternal(DependencyPath dependencyPath) {
        if (MinimumMiniparTemplateAcceptor.acceptsInternal(dependencyPath)) {
            return true;
        }
        if (dependencyPath.length() > 3) {
            return false;
        }
        int n = dependencyPath.length();
        StringBuilder stringBuilder = new StringBuilder(n * 16);
        StringBuilder stringBuilder2 = new StringBuilder(n * 16);
        StringBuilder stringBuilder3 = new StringBuilder(n * 16);
        DependencyTreeNode dependencyTreeNode = dependencyPath.first();
        for (int i = 1; i < n; ++i) {
            DependencyTreeNode dependencyTreeNode2 = dependencyPath.getNode(i);
            if (dependencyTreeNode.word().equals("")) {
                return false;
            }
            String string = dependencyPath.getRelation(i - 1);
            String string2 = dependencyTreeNode.pos();
            String string3 = dependencyTreeNode2.pos();
            stringBuilder.append(i == 0 ? "(null)" : string2);
            stringBuilder.append(":").append(string).append(":").append(string3);
            stringBuilder2.append(string2).append(":").append(string).append(":");
            stringBuilder2.append(i + 1 == n ? "(null)" : string3);
            stringBuilder3.append(string2).append(":").append(string).append(":").append(string3);
            if (i + 1 < n) {
                stringBuilder.append(",");
                stringBuilder2.append(",");
                stringBuilder3.append(",");
            }
            dependencyTreeNode = dependencyTreeNode2;
        }
        if (dependencyTreeNode.word().equals("")) {
            return false;
        }
        return MEDIUM_TEMPLATES.contains(stringBuilder3.toString()) || MEDIUM_TEMPLATES.contains(stringBuilder.toString()) || MEDIUM_TEMPLATES.contains(stringBuilder2.toString());
    }

    @Override
    public int maxPathLength() {
        return 4;
    }

    static {
        MEDIUM_TEMPLATES.add("A:mod:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("A:mod:N,N:nn:N");
        MEDIUM_TEMPLATES.add("A:subj:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("A:subj:N,N:nn:N");
        MEDIUM_TEMPLATES.add("N:conj:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("N:conj:N,N:nn:N");
        MEDIUM_TEMPLATES.add("N:gen:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("N:gen:N,N:nn:N");
        MEDIUM_TEMPLATES.add("N:nn:N,N:conj:N");
        MEDIUM_TEMPLATES.add("N:nn:N,N:conj:N,N:nn:N");
        MEDIUM_TEMPLATES.add("N:nn:N,N:gen:N");
        MEDIUM_TEMPLATES.add("N:nn:N,N:gen:N,N:nn:N");
        MEDIUM_TEMPLATES.add("N:nn:N,N:mod:A");
        MEDIUM_TEMPLATES.add("N:nn:N,N:mod:Pred");
        MEDIUM_TEMPLATES.add("N:nn:N,N:obj:V");
        MEDIUM_TEMPLATES.add("N:nn:N,N:subj:A");
        MEDIUM_TEMPLATES.add("N:nn:N,N:subj:V");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:conj:N");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:conj:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:gen:N");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:gen:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:mod:A");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:mod:Pred");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:obj:V");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:subj:A");
        MEDIUM_TEMPLATES.add("(null):lex-mod:N,N:subj:V");
        MEDIUM_TEMPLATES.add("Prep:mod:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("Prep:mod:N,N:nn:N");
        MEDIUM_TEMPLATES.add("V:obj:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("V:obj:N,N:nn:N");
        MEDIUM_TEMPLATES.add("V:subj:N,N:lex-mod:(null)");
        MEDIUM_TEMPLATES.add("V:subj:N,N:nn:N");
    }
}

