/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dv;

import edu.ucla.sspace.common.DimensionallyInterpretableSemanticSpace;
import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyExtractorManager;
import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyPathWeight;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.FilteredDependencyIterator;
import edu.ucla.sspace.dependency.FlatPathWeight;
import edu.ucla.sspace.dv.DependencyPathBasisMapping;
import edu.ucla.sspace.dv.MinimumPennTemplateAcceptor;
import edu.ucla.sspace.dv.WordBasedBasisMapping;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class DependencyVectorSpace
implements DimensionallyInterpretableSemanticSpace<String> {
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.dri.DependencyVectorSpace";
    public static final String PATH_ACCEPTOR_PROPERTY = "edu.ucla.sspace.dri.DependencyVectorSpace.pathAcceptor";
    public static final String PATH_WEIGHTING_PROPERTY = "edu.ucla.sspace.dri.DependencyVectorSpace.pathWeighting";
    public static final String BASIS_MAPPING_PROPERTY = "edu.ucla.sspace.dri.DependencyVectorSpace.basisMapping";
    private static final Logger LOGGER = Logger.getLogger(DependencyVectorSpace.class.getName());
    private Map<String, SparseDoubleVector> termToVector;
    private final DependencyExtractor extractor;
    private final DependencyPathBasisMapping basisMapping;
    private final DependencyPathWeight weighter;
    private final DependencyPathAcceptor acceptor;
    private final int pathLength;

    public DependencyVectorSpace() {
        this(System.getProperties(), 0);
    }

    public DependencyVectorSpace(Properties properties) {
        this(properties, 0);
    }

    public DependencyVectorSpace(Properties properties, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("path length must be non-negative");
        }
        this.termToVector = new HashMap<String, SparseDoubleVector>();
        String string = properties.getProperty(BASIS_MAPPING_PROPERTY);
        this.basisMapping = string == null ? new WordBasedBasisMapping() : (DependencyPathBasisMapping)ReflectionUtil.getObjectInstance(string);
        String string2 = properties.getProperty(PATH_WEIGHTING_PROPERTY);
        this.weighter = string2 == null ? new FlatPathWeight() : (DependencyPathWeight)ReflectionUtil.getObjectInstance(string2);
        String string3 = properties.getProperty(PATH_ACCEPTOR_PROPERTY);
        this.acceptor = string3 == null ? new MinimumPennTemplateAcceptor() : (DependencyPathAcceptor)ReflectionUtil.getObjectInstance(string3);
        this.pathLength = n == 0 ? this.acceptor.maxPathLength() : n;
        this.extractor = DependencyExtractorManager.getDefaultExtractor();
    }

    @Override
    public String getDimensionDescription(int n) {
        if (n < 0 || n >= this.basisMapping.numDimensions()) {
            throw new IllegalArgumentException("Invalid dimension: " + n);
        }
        return (String)this.basisMapping.getDimensionDescription(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparseDoubleVector getSemanticVector(String string) {
        SparseDoubleVector sparseDoubleVector = this.termToVector.get(string);
        if (sparseDoubleVector == null) {
            DependencyVectorSpace dependencyVectorSpace = this;
            synchronized (dependencyVectorSpace) {
                sparseDoubleVector = this.termToVector.get(string);
                if (sparseDoubleVector == null) {
                    sparseDoubleVector = new CompactSparseVector();
                    this.termToVector.put(string, sparseDoubleVector);
                }
            }
        }
        return sparseDoubleVector;
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.termToVector.keySet());
    }

    @Override
    public Vector getVector(String string) {
        SparseDoubleVector sparseDoubleVector = this.termToVector.get(string);
        return sparseDoubleVector == null ? null : Vectors.immutable(Vectors.subview(sparseDoubleVector, 0, this.basisMapping.numDimensions()));
    }

    @Override
    public String getSpaceName() {
        return "DependencyVectorSpace_" + this.basisMapping + "_" + this.weighter + "_" + this.acceptor;
    }

    @Override
    public int getVectorLength() {
        return this.basisMapping.numDimensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        DependencyTreeNode[] dependencyTreeNodeArray = null;
        while ((dependencyTreeNodeArray = this.extractor.readNextTree(bufferedReader)) != null) {
            if (dependencyTreeNodeArray.length == 0) continue;
            for (int i = 0; i < dependencyTreeNodeArray.length; ++i) {
                String string = dependencyTreeNodeArray[i].word();
                SparseDoubleVector sparseDoubleVector = this.getSemanticVector(string);
                FilteredDependencyIterator filteredDependencyIterator = new FilteredDependencyIterator(dependencyTreeNodeArray[i], this.acceptor, this.pathLength);
                while (filteredDependencyIterator.hasNext()) {
                    DependencyPath dependencyPath = (DependencyPath)filteredDependencyIterator.next();
                    int n = this.basisMapping.getDimension(dependencyPath);
                    double d = this.weighter.scorePath(dependencyPath);
                    SparseDoubleVector sparseDoubleVector2 = sparseDoubleVector;
                    synchronized (sparseDoubleVector2) {
                        sparseDoubleVector.add(n, d);
                    }
                }
            }
        }
        bufferedReader.close();
    }

    @Override
    public void processSpace(Properties properties) {
    }
}

