/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleDependencyPath
implements DependencyPath {
    private final List<DependencyRelation> path;
    private final boolean isHeadFirst;

    public SimpleDependencyPath(List<DependencyRelation> list) {
        this(list, true);
    }

    public SimpleDependencyPath(List<DependencyRelation> list, boolean bl) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("Cannot provide empty path");
        }
        this.path = list;
        this.isHeadFirst = bl;
    }

    public SimpleDependencyPath(DependencyPath dependencyPath) {
        if (dependencyPath == null || dependencyPath.length() == 0) {
            throw new IllegalArgumentException("Cannot provide empty path");
        }
        if (dependencyPath instanceof SimpleDependencyPath) {
            SimpleDependencyPath simpleDependencyPath = (SimpleDependencyPath)dependencyPath;
            this.path = new ArrayList<DependencyRelation>(simpleDependencyPath.path);
            this.isHeadFirst = simpleDependencyPath.isHeadFirst;
        } else {
            Object object2;
            this.path = new ArrayList<DependencyRelation>(dependencyPath.length());
            for (Object object2 : dependencyPath) {
                this.path.add((DependencyRelation)object2);
            }
            DependencyRelation dependencyRelation = dependencyPath.firstRelation();
            object2 = dependencyPath.first();
            this.isHeadFirst = dependencyRelation.headNode().equals(object2);
        }
    }

    @Override
    public DependencyTreeNode first() {
        DependencyRelation dependencyRelation = this.path.get(0);
        return this.isHeadFirst ? dependencyRelation.headNode() : dependencyRelation.dependentNode();
    }

    @Override
    public DependencyRelation firstRelation() {
        return this.path.get(0);
    }

    @Override
    public DependencyTreeNode getNode(int n) {
        if (n < 0 || n > this.path.size() + 1) {
            throw new IndexOutOfBoundsException("Invalid node: " + n);
        }
        if (n == 0) {
            return this.isHeadFirst ? this.path.get(0).headNode() : this.path.get(0).dependentNode();
        }
        if (n == 1) {
            return this.isHeadFirst ? this.path.get(0).dependentNode() : this.path.get(0).headNode();
        }
        if (this.path.size() == 1) {
            return this.isHeadFirst && n == 1 || !this.isHeadFirst && n == 0 ? this.path.get(0).dependentNode() : this.path.get(0).headNode();
        }
        DependencyRelation dependencyRelation = this.path.get(n - 2);
        DependencyRelation dependencyRelation2 = this.path.get(n - 1);
        return this.getNextNode(dependencyRelation, dependencyRelation2);
    }

    private DependencyTreeNode getNextNode(DependencyRelation dependencyRelation, DependencyRelation dependencyRelation2) {
        return dependencyRelation.headNode().equals(dependencyRelation2.headNode()) || dependencyRelation.dependentNode().equals(dependencyRelation2.headNode()) ? dependencyRelation2.dependentNode() : dependencyRelation2.headNode();
    }

    @Override
    public String getRelation(int n) {
        if (n < 0 || n > this.path.size() - 1) {
            throw new IndexOutOfBoundsException("Invalid relation: " + n);
        }
        DependencyRelation dependencyRelation = this.path.get(n);
        return dependencyRelation.relation();
    }

    @Override
    public Iterator<DependencyRelation> iterator() {
        return this.path.iterator();
    }

    @Override
    public DependencyTreeNode last() {
        if (this.path.size() == 1) {
            return this.isHeadFirst ? this.path.get(0).dependentNode() : this.path.get(0).headNode();
        }
        DependencyRelation dependencyRelation = this.path.get(this.path.size() - 2);
        DependencyRelation dependencyRelation2 = this.path.get(this.path.size() - 1);
        return this.getNextNode(dependencyRelation, dependencyRelation2);
    }

    @Override
    public DependencyRelation lastRelation() {
        return this.path.get(this.path.size() - 1);
    }

    @Override
    public int length() {
        return this.path.size();
    }

    public String toString() {
        int n = this.length() + 1;
        StringBuilder stringBuilder = new StringBuilder(8 * n);
        stringBuilder.append('[');
        stringBuilder.append(this.getNode(0).word());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(' ').append(this.getRelation(i - 1)).append(' ').append(this.getNode(i).word());
        }
        return stringBuilder.append(']').toString();
    }
}

