/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPermutationFunction;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.vector.Vector;
import java.io.Serializable;

public class RelationPermutationFunction<T extends Vector>
implements DependencyPermutationFunction<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PermutationFunction<T> permFunc;

    public RelationPermutationFunction(PermutationFunction<T> permutationFunction) {
        this.permFunc = permutationFunction;
    }

    @Override
    public T permute(T t, DependencyPath dependencyPath) {
        int n = 0;
        for (DependencyRelation dependencyRelation : dependencyPath) {
            int n2 = RelationPermutationFunction.getRelationScore(dependencyRelation.relation());
            if (n2 <= n) continue;
            n = n2;
        }
        return this.permFunc.permute(t, n);
    }

    private static int getRelationScore(String string) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.equals("SBJ")) {
            return 6;
        }
        if (string.equals("OBJ")) {
            return 5;
        }
        if (string.equals("NMOD")) {
            return 4;
        }
        if (string.equals("VMOD")) {
            return 3;
        }
        if (string.equals("ADV")) {
            return 2;
        }
        return 1;
    }
}

