/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.BreadthFirstPathIterator;
import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteredDependencyIterator
implements Iterator<DependencyPath> {
    private final int maxPathLength;
    private final DependencyPathAcceptor acceptor;
    private final BreadthFirstPathIterator iterator;
    private DependencyPath next;

    public FilteredDependencyIterator(DependencyTreeNode dependencyTreeNode, DependencyPathAcceptor dependencyPathAcceptor) {
        this(dependencyTreeNode, dependencyPathAcceptor, Integer.MAX_VALUE);
    }

    public FilteredDependencyIterator(DependencyTreeNode dependencyTreeNode, DependencyPathAcceptor dependencyPathAcceptor, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Must specify a path length greater than 1");
        }
        this.iterator = new BreadthFirstPathIterator(dependencyTreeNode);
        this.acceptor = dependencyPathAcceptor;
        this.maxPathLength = n;
        this.advance();
    }

    private void advance() {
        DependencyPath dependencyPath = null;
        while (this.iterator.hasNext()) {
            dependencyPath = this.iterator.next();
            if (dependencyPath.length() > this.maxPathLength) {
                dependencyPath = null;
                break;
            }
            if (!this.acceptor.accepts(dependencyPath)) continue;
        }
        this.next = dependencyPath;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public DependencyPath next() {
        if (this.next == null) {
            throw new NoSuchElementException("No further paths to return");
        }
        DependencyPath dependencyPath = this.next;
        this.advance();
        return dependencyPath;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal is not supported");
    }
}

