/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.BreadthFirstPathIterator;
import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.dependency.DependencyRelationAcceptor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.ExtendedPathView;

public class DependencyIterator
extends BreadthFirstPathIterator {
    private final int maxPathLength;
    private DependencyRelationAcceptor acceptor;

    public DependencyIterator(DependencyTreeNode dependencyTreeNode, DependencyRelationAcceptor dependencyRelationAcceptor, int n) {
        super(dependencyTreeNode);
        if (n < 1) {
            throw new IllegalArgumentException("Must specify a path length greater than 1");
        }
        this.acceptor = dependencyRelationAcceptor;
        this.maxPathLength = n;
    }

    @Override
    void advance(DependencyPath dependencyPath) {
        if (dependencyPath.length() == this.maxPathLength) {
            return;
        }
        DependencyTreeNode dependencyTreeNode = dependencyPath.last();
        DependencyRelation dependencyRelation = dependencyPath.lastRelation();
        for (DependencyRelation dependencyRelation2 : dependencyTreeNode.neighbors()) {
            if (dependencyRelation.equals(dependencyRelation2) || !this.acceptor.accept(dependencyRelation2)) continue;
            ExtendedPathView extendedPathView = new ExtendedPathView(dependencyPath, dependencyRelation2);
            this.frontier.offer(extendedPathView);
        }
    }
}

