/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.SimpleDependencyRelation;
import edu.ucla.sspace.dependency.SimpleDependencyTreeNode;
import edu.ucla.sspace.text.Stemmer;
import edu.ucla.sspace.text.TokenFilter;
import edu.ucla.sspace.util.Duple;
import edu.ucla.sspace.util.HashMultiMap;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CoNLLDependencyExtractor
implements DependencyExtractor {
    private final TokenFilter filter;
    private final Stemmer stemmer;
    private final int idIndex;
    private final int formIndex;
    private final int lemmaIndex;
    private final int posIndex;
    private final int parentIndex;
    private final int relationIndex;

    public CoNLLDependencyExtractor() {
        this(null, null);
    }

    public CoNLLDependencyExtractor(TokenFilter tokenFilter, Stemmer stemmer) {
        this.filter = tokenFilter;
        this.stemmer = stemmer;
        this.idIndex = 0;
        this.formIndex = 1;
        this.lemmaIndex = 2;
        this.posIndex = 3;
        this.parentIndex = 6;
        this.relationIndex = 7;
    }

    public CoNLLDependencyExtractor(TokenFilter tokenFilter, Stemmer stemmer, int n, int n2, int n3, int n4, int n5, int n6) {
        this.filter = tokenFilter;
        this.stemmer = stemmer;
        this.idIndex = n;
        this.formIndex = n2;
        this.lemmaIndex = n3;
        this.posIndex = n4;
        this.parentIndex = n5;
        this.relationIndex = n6;
    }

    public CoNLLDependencyExtractor(String string) {
        this(string, null, null);
    }

    public CoNLLDependencyExtractor(String string, TokenFilter tokenFilter, Stemmer stemmer) {
        this.filter = tokenFilter;
        this.stemmer = stemmer;
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            NodeList nodeList = document.getElementsByTagName("column");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string2 = element.getAttribute("name");
                if (string2.equals("ID")) {
                    n = i;
                }
                if (string2.equals("FORM")) {
                    n2 = i;
                }
                if (string2.equals("LEMMA")) {
                    n3 = i;
                }
                if (string2.equals("POSTAG")) {
                    n4 = i;
                }
                if (string2.equals("HEAD")) {
                    n5 = i;
                }
                if (!string2.equals("DEPREL")) continue;
                n6 = i;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        this.idIndex = n;
        this.formIndex = n2;
        this.lemmaIndex = n3;
        this.posIndex = n4;
        this.parentIndex = n5;
        this.relationIndex = n6;
    }

    @Override
    public DependencyTreeNode[] readNextTree(BufferedReader bufferedReader) throws IOException {
        Object object;
        Object object2;
        ArrayList<SimpleDependencyTreeNode> arrayList = new ArrayList<SimpleDependencyTreeNode>();
        HashMultiMap<Integer, Duple<Integer, String>> hashMultiMap = new HashMultiMap<Integer, Duple<Integer, String>>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        Object object3 = null;
        while ((object3 = bufferedReader.readLine()) != null) {
            if (((String)(object3 = ((String)object3).trim())).length() == 0 && arrayList.size() == 0) continue;
            if (((String)object3).length() == 0) break;
            stringBuilder.append((String)object3).append("\n");
            String[] stringArray = ((String)object3).split("\\s+");
            int n3 = Integer.parseInt(stringArray[this.idIndex]);
            if (n3 == 0 && arrayList.size() != n2 || n3 == 1 && arrayList.size() != n2 && arrayList.size() != n2 + 1) {
                n2 = arrayList.size();
            }
            int n4 = Integer.parseInt(stringArray[this.parentIndex]) - 1 + n2;
            object2 = this.getWord(stringArray);
            object = this.getLemma(stringArray, (String)object2);
            String string = stringArray[this.posIndex];
            String string2 = stringArray[this.relationIndex];
            SimpleDependencyTreeNode simpleDependencyTreeNode = new SimpleDependencyTreeNode((String)object2, string, (String)object);
            if (n4 - n2 > 0) {
                if (n4 < arrayList.size()) {
                    SimpleDependencyTreeNode simpleDependencyTreeNode2 = (SimpleDependencyTreeNode)arrayList.get(n4);
                    SimpleDependencyRelation simpleDependencyRelation = new SimpleDependencyRelation(simpleDependencyTreeNode2, string2, simpleDependencyTreeNode);
                    simpleDependencyTreeNode2.addNeighbor(simpleDependencyRelation);
                    simpleDependencyTreeNode.addNeighbor(simpleDependencyRelation);
                } else {
                    hashMultiMap.put(n, new Duple<Integer, String>(n4, string2));
                }
            }
            arrayList.add(simpleDependencyTreeNode);
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (hashMultiMap.size() > 0) {
            for (Map.Entry entry : hashMultiMap.entrySet()) {
                SimpleDependencyTreeNode simpleDependencyTreeNode = (SimpleDependencyTreeNode)arrayList.get((Integer)entry.getKey());
                Duple duple = (Duple)entry.getValue();
                object2 = (SimpleDependencyTreeNode)arrayList.get((Integer)duple.x);
                object = new SimpleDependencyRelation((DependencyTreeNode)object2, (String)duple.y, simpleDependencyTreeNode);
                ((SimpleDependencyTreeNode)object2).addNeighbor((DependencyRelation)object);
                simpleDependencyTreeNode.addNeighbor((DependencyRelation)object);
            }
        }
        return arrayList.toArray(new SimpleDependencyTreeNode[arrayList.size()]);
    }

    private String getWord(String[] stringArray) {
        String string = stringArray[this.formIndex].toLowerCase();
        if (this.filter != null && !this.filter.accept(string)) {
            return "";
        }
        return string;
    }

    private String getLemma(String[] stringArray, String string) {
        String string2 = stringArray[this.lemmaIndex];
        if (string2.equals("_")) {
            return this.stemmer == null ? string : this.stemmer.stem(string);
        }
        return string2;
    }
}

