/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class VectorMapSemanticSpace<T extends Vector>
implements SemanticSpace {
    private static final Logger LOGGER = Logger.getLogger(VectorMapSemanticSpace.class.getName());
    private final Map<String, T> wordSpace;
    private final int dimensions;
    private String spaceName;

    public VectorMapSemanticSpace(Map<String, T> map, String string, int n) {
        if (map == null) {
            throw new IllegalArgumentException("the wordSpace must be non-null");
        }
        if (string == null) {
            throw new IllegalArgumentException("the spaceName must be non-null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("the VectorMapSemanticSpace must have more than 0 dimensions");
        }
        this.wordSpace = map;
        this.dimensions = n;
        this.spaceName = string;
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.wordSpace.keySet());
    }

    public T getVector(String string) {
        return (T)((Vector)this.wordSpace.get(string));
    }

    @Override
    public String getSpaceName() {
        return this.spaceName;
    }

    @Override
    public int getVectorLength() {
        return this.dimensions;
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) {
    }

    @Override
    public void processSpace(Properties properties) {
    }
}

