/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.util.DoubleEntry;
import edu.ucla.sspace.util.IntegerEntry;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class Similarity {
    private Similarity() {
    }

    @Deprecated
    public static Method getMethod(SimType simType) {
        String string = null;
        switch (simType) {
            case COSINE: {
                string = "cosineSimilarity";
                break;
            }
            case PEARSON_CORRELATION: {
                string = "correlation";
                break;
            }
            case EUCLIDEAN: {
                string = "euclideanSimilarity";
                break;
            }
            case SPEARMAN_RANK_CORRELATION: {
                string = "spearmanRankCorrelationCoefficient";
                break;
            }
            case JACCARD_INDEX: {
                string = "jaccardIndex";
                break;
            }
            case AVERAGE_COMMON_FEATURE_RANK: {
                string = "averageCommonFeatureRank";
                break;
            }
            case LIN: {
                string = "linSimilarity";
                break;
            }
            case KL_DIVERGENCE: {
                string = "klDivergence";
                break;
            }
            default: {
                assert (false) : simType;
                break;
            }
        }
        Method method = null;
        try {
            method = Similarity.class.getMethod(string, double[].class, double[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Error(noSuchMethodException);
        }
        return method;
    }

    public static double getSimilarity(SimType simType, double[] dArray, double[] dArray2) {
        switch (simType) {
            case COSINE: {
                return Similarity.cosineSimilarity(dArray, dArray2);
            }
            case PEARSON_CORRELATION: {
                return Similarity.correlation(dArray, dArray2);
            }
            case EUCLIDEAN: {
                return Similarity.euclideanSimilarity(dArray, dArray2);
            }
            case SPEARMAN_RANK_CORRELATION: {
                return Similarity.spearmanRankCorrelationCoefficient(dArray, dArray2);
            }
            case JACCARD_INDEX: {
                return Similarity.jaccardIndex(dArray, dArray2);
            }
            case AVERAGE_COMMON_FEATURE_RANK: {
                return Similarity.averageCommonFeatureRank(dArray, dArray2);
            }
            case LIN: {
                return Similarity.linSimilarity(dArray, dArray2);
            }
            case KL_DIVERGENCE: {
                return Similarity.klDivergence(dArray, dArray2);
            }
        }
        return 0.0;
    }

    public static <T extends Vector> double getSimilarity(SimType simType, T t, T t2) {
        switch (simType) {
            case COSINE: {
                return Similarity.cosineSimilarity(t, t2);
            }
            case PEARSON_CORRELATION: {
                return Similarity.correlation(t, t2);
            }
            case EUCLIDEAN: {
                return Similarity.euclideanSimilarity(t, t2);
            }
            case SPEARMAN_RANK_CORRELATION: {
                return Similarity.spearmanRankCorrelationCoefficient(t, t2);
            }
            case JACCARD_INDEX: {
                return Similarity.jaccardIndex(t, t2);
            }
            case AVERAGE_COMMON_FEATURE_RANK: {
                return Similarity.averageCommonFeatureRank(t, t2);
            }
            case LIN: {
                return Similarity.linSimilarity(t, t2);
            }
            case KL_DIVERGENCE: {
                return Similarity.klDivergence(t, t2);
            }
        }
        return 0.0;
    }

    private static void check(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("input array lengths do not match");
        }
    }

    private static void check(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("input array lengths do not match");
        }
    }

    private static void check(Vector vector, Vector vector2) {
        if (vector.length() != vector2.length()) {
            throw new IllegalArgumentException("input vector lengths do not match");
        }
    }

    public static double cosineSimilarity(double[] dArray, double[] dArray2) {
        Similarity.check(dArray, dArray2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            double d4 = dArray[i];
            double d5 = dArray2[i];
            d2 += d4 * d4;
            d3 += d5 * d5;
            d += d4 * d5;
        }
        d2 = Math.sqrt(d2);
        d3 = Math.sqrt(d3);
        return d2 == 0.0 || d3 == 0.0 ? 0.0 : d / (d2 * d3);
    }

    public static double cosineSimilarity(int[] nArray, int[] nArray2) {
        Similarity.check(nArray, nArray2);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray[i];
            int n2 = nArray2[i];
            l2 += (long)(n * n);
            l3 += (long)(n2 * n2);
            l += (long)(n * n2);
        }
        double d = Math.sqrt(l2);
        double d2 = Math.sqrt(l3);
        return d == 0.0 || d2 == 0.0 ? 0.0 : (double)l / (d * d2);
    }

    public static double cosineSimilarity(DoubleVector object, DoubleVector object2) {
        double d = 0.0;
        double d2 = object.magnitude();
        double d3 = object2.magnitude();
        if (object instanceof Iterable && object2 instanceof Iterable) {
            boolean bl;
            boolean bl2 = bl = object.length() < object2.length() || object instanceof SparseVector && object2 instanceof SparseVector && ((SparseVector)object).getNonZeroIndices().length < ((SparseVector)object2).getNonZeroIndices().length;
            if (bl) {
                Object object3 = object;
                object = object2;
                object2 = object3;
            }
            for (DoubleEntry doubleEntry : (Iterable)object2) {
                int n = doubleEntry.index();
                double d4 = object.get(n);
                double d5 = doubleEntry.value();
                d += d4 * d5;
            }
        } else if (object instanceof SparseVector && object2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)object;
            SparseVector sparseVector2 = (SparseVector)object2;
            int[] nArray = sparseVector.getNonZeroIndices();
            int[] nArray2 = sparseVector2.getNonZeroIndices();
            if (object.length() < object2.length() || nArray.length < nArray2.length) {
                Object object4 = object;
                object = object2;
                object2 = object4;
            }
            for (Object object5 : (Object)nArray2) {
                double d6 = object.get((int)object5);
                double d7 = object2.get((int)object5);
                d += d6 * d7;
            }
        } else if (object2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)object2;
            for (int n : sparseVector.getNonZeroIndices()) {
                d += object2.get(n) * object.get(n);
            }
        } else if (object instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)object;
            for (int n : sparseVector.getNonZeroIndices()) {
                d += object2.get(n) * object.get(n);
            }
        } else {
            if (object.length() < object2.length()) {
                DoubleVector doubleVector = object;
                object = object2;
                object2 = doubleVector;
            }
            for (int i = 0; i < object2.length(); ++i) {
                double d8 = object.get(i);
                double d9 = object2.get(i);
                d += d8 * d9;
            }
        }
        return d2 == 0.0 || d3 == 0.0 ? 0.0 : d / (d2 * d3);
    }

    public static double cosineSimilarity(IntegerVector integerVector, IntegerVector object) {
        Similarity.check(integerVector, (Vector)object);
        int n = 0;
        double d = integerVector.magnitude();
        double d2 = object.magnitude();
        if (integerVector instanceof Iterable && object instanceof Iterable) {
            boolean bl;
            boolean bl2 = bl = integerVector instanceof SparseVector && object instanceof SparseVector && ((SparseVector)((Object)integerVector)).getNonZeroIndices().length < ((SparseVector)object).getNonZeroIndices().length;
            if (bl) {
                IntegerVector integerVector2 = integerVector;
                integerVector = object;
                object = integerVector2;
            }
            for (IntegerEntry integerEntry : (Iterable)object) {
                int n2 = integerEntry.index();
                int n3 = integerVector.get(n2);
                int n4 = integerEntry.value();
                n += n3 * n4;
            }
        } else if (integerVector instanceof SparseVector && object instanceof SparseVector) {
            int[] nArray;
            SparseVector sparseVector = (SparseVector)((Object)integerVector);
            SparseVector sparseVector2 = (SparseVector)object;
            int[] nArray2 = sparseVector.getNonZeroIndices();
            if (nArray2.length < (nArray = sparseVector2.getNonZeroIndices()).length) {
                for (int n5 : nArray2) {
                    int n6 = integerVector.get(n5);
                    int n7 = object.get(n5);
                    n += n6 * n7;
                }
            } else {
                for (int n8 : nArray) {
                    int n9 = integerVector.get(n8);
                    int n10 = object.get(n8);
                    n += n9 * n10;
                }
            }
        } else {
            for (int i = 0; i < object.length(); ++i) {
                int n11 = integerVector.get(i);
                int n12 = object.get(i);
                n += n11 * n12;
            }
        }
        return d == 0.0 || d2 == 0.0 ? 0.0 : (double)n / (d * d2);
    }

    public static double cosineSimilarity(Vector vector, Vector vector2) {
        return vector instanceof IntegerVector && vector2 instanceof IntegerVector ? Similarity.cosineSimilarity((IntegerVector)vector, (IntegerVector)vector2) : Similarity.cosineSimilarity(Vectors.asDouble(vector), Vectors.asDouble(vector2));
    }

    public static double correlation(double[] dArray, double[] dArray2) {
        Similarity.check(dArray, dArray2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            d2 += dArray2[i];
        }
        double d3 = d / (double)dArray.length;
        double d4 = d2 / (double)dArray.length;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d8 = dArray[i] - d3;
            double d9 = dArray2[i] - d4;
            d5 += d8 * d9;
            d6 += d8 * d8;
            d7 += d9 * d9;
        }
        if (d6 == 0.0 || d7 == 0.0) {
            return 0.0;
        }
        return d5 / Math.sqrt(d6 * d7);
    }

    public static double correlation(int[] nArray, int[] nArray2) {
        Similarity.check(nArray, nArray2);
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l += (long)nArray[i];
            l2 += (long)nArray2[i];
        }
        double d = (double)l / (double)nArray.length;
        double d2 = (double)l2 / (double)nArray.length;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d6 = (double)nArray[i] - d;
            double d7 = (double)nArray2[i] - d2;
            d3 += d6 * d7;
            d4 += d6 * d6;
            d5 += d7 * d7;
        }
        return d3 / Math.sqrt(d4 * d5);
    }

    public static double correlation(DoubleVector doubleVector, DoubleVector doubleVector2) {
        Similarity.check(doubleVector, doubleVector2);
        Similarity.check(doubleVector, doubleVector2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < doubleVector.length(); ++i) {
            d += doubleVector.get(i);
            d2 += doubleVector2.get(i);
        }
        double d3 = d / (double)doubleVector.length();
        double d4 = d2 / (double)doubleVector.length();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < doubleVector.length(); ++i) {
            double d8 = doubleVector.get(i) - d3;
            double d9 = doubleVector2.get(i) - d4;
            d5 += d8 * d9;
            d6 += d8 * d8;
            d7 += d9 * d9;
        }
        return d5 / Math.sqrt(d6 * d7);
    }

    public static double correlation(IntegerVector integerVector, DoubleVector doubleVector) {
        Similarity.check(integerVector, doubleVector);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < integerVector.length(); ++i) {
            d += (double)integerVector.get(i);
            d2 += doubleVector.get(i);
        }
        double d3 = d / (double)integerVector.length();
        double d4 = d2 / (double)integerVector.length();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < integerVector.length(); ++i) {
            double d8 = (double)integerVector.get(i) - d3;
            double d9 = doubleVector.get(i) - d4;
            d5 += d8 * d9;
            d6 += d8 * d8;
            d7 += d9 * d9;
        }
        return d5 / Math.sqrt(d6 * d7);
    }

    public static double correlation(Vector vector, Vector vector2) {
        return Similarity.correlation(Vectors.asDouble(vector), Vectors.asDouble(vector2));
    }

    public static double euclideanDistance(double[] dArray, double[] dArray2) {
        Similarity.check(dArray, dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.pow(dArray[i] - dArray2[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static double euclideanDistance(int[] nArray, int[] nArray2) {
        Similarity.check(nArray, nArray2);
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l = (long)((double)l + Math.pow(nArray[i] - nArray2[i], 2.0));
        }
        return Math.sqrt(l);
    }

    public static double euclideanDistance(DoubleVector doubleVector, DoubleVector doubleVector2) {
        Similarity.check(doubleVector, doubleVector2);
        if (doubleVector instanceof SparseVector && doubleVector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)doubleVector);
            SparseVector sparseVector2 = (SparseVector)((Object)doubleVector2);
            int[] nArray = sparseVector.getNonZeroIndices();
            int[] nArray2 = sparseVector2.getNonZeroIndices();
            HashSet<Integer> hashSet = new HashSet<Integer>(nArray.length);
            double d = 0.0;
            for (int n : nArray) {
                d += Math.pow(doubleVector.get(n) - doubleVector2.get(n), 2.0);
                hashSet.add(n);
            }
            for (int n : nArray2) {
                if (hashSet.contains(n)) continue;
                d += Math.pow(doubleVector2.get(n), 2.0);
            }
            return d;
        }
        if (doubleVector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)doubleVector2);
            int[] nArray = sparseVector.getNonZeroIndices();
            double d = 0.0;
            double d2 = Math.pow(doubleVector.magnitude(), 2.0);
            for (int n : nArray) {
                double d3 = doubleVector.get(n);
                d2 -= Math.pow(d3, 2.0);
                d += Math.pow(d3 - doubleVector2.get(n), 2.0);
            }
            return (d += d2) < 0.0 ? 0.0 : Math.sqrt(d);
        }
        double d = 0.0;
        for (int i = 0; i < doubleVector.length(); ++i) {
            d += Math.pow(doubleVector.get(i) - doubleVector2.get(i), 2.0);
        }
        return Math.sqrt(d);
    }

    public static double euclideanDistance(IntegerVector integerVector, IntegerVector integerVector2) {
        Similarity.check(integerVector, integerVector2);
        if (integerVector instanceof SparseVector && integerVector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)integerVector);
            SparseVector sparseVector2 = (SparseVector)((Object)integerVector2);
            int[] nArray = sparseVector.getNonZeroIndices();
            int[] nArray2 = sparseVector2.getNonZeroIndices();
            HashSet<Integer> hashSet = new HashSet<Integer>(nArray.length);
            double d = 0.0;
            for (int n : nArray) {
                d += Math.pow(integerVector.get(n) - integerVector2.get(n), 2.0);
                hashSet.add(n);
            }
            for (int n : nArray2) {
                if (hashSet.contains(nArray2)) continue;
                d += Math.pow(integerVector2.get(n), 2.0);
            }
            return d;
        }
        double d = 0.0;
        for (int i = 0; i < integerVector.length(); ++i) {
            d += Math.pow(integerVector.get(i) - integerVector2.get(i), 2.0);
        }
        return Math.sqrt(d);
    }

    public static double euclideanDistance(Vector vector, Vector vector2) {
        return Similarity.euclideanDistance(Vectors.asDouble(vector), Vectors.asDouble(vector2));
    }

    public static double euclideanSimilarity(int[] nArray, int[] nArray2) {
        return 1.0 / (1.0 + Similarity.euclideanDistance(nArray, nArray2));
    }

    public static double euclideanSimilarity(double[] dArray, double[] dArray2) {
        return 1.0 / (1.0 + Similarity.euclideanDistance(dArray, dArray2));
    }

    public static double euclideanSimilarity(Vector vector, Vector vector2) {
        return 1.0 / (1.0 + Similarity.euclideanDistance(vector, vector2));
    }

    public static double jaccardIndex(double[] dArray, double[] dArray2) {
        HashSet<Double> hashSet = new HashSet<Double>();
        HashSet<Double> hashSet2 = new HashSet<Double>();
        for (double d : dArray) {
            hashSet.add(d);
            hashSet2.add(d);
        }
        Object object = new HashSet();
        for (double d : dArray2) {
            object.add(d);
            hashSet2.add(d);
        }
        hashSet.retainAll((Collection<?>)object);
        return (double)hashSet.size() / (double)hashSet2.size();
    }

    public static double jaccardIndex(int[] nArray, int[] nArray2) {
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        for (int n : nArray) {
            bitSet.set(n);
            bitSet3.set(n);
        }
        for (int n : nArray2) {
            bitSet2.set(n);
            bitSet3.set(n);
        }
        bitSet.and(bitSet2);
        return (double)bitSet.cardinality() / (double)bitSet3.cardinality();
    }

    public static double jaccardIndex(DoubleVector doubleVector, DoubleVector doubleVector2) {
        HashSet<Double> hashSet = new HashSet<Double>();
        HashSet<Double> hashSet2 = new HashSet<Double>();
        for (int i = 0; i < doubleVector.length(); ++i) {
            double d = doubleVector.get(i);
            hashSet.add(d);
            hashSet2.add(d);
        }
        HashSet<Double> hashSet3 = new HashSet<Double>();
        for (int i = 0; i < doubleVector2.length(); ++i) {
            double d = doubleVector2.get(i);
            hashSet3.add(d);
            hashSet2.add(d);
        }
        hashSet.retainAll(hashSet3);
        return (double)hashSet.size() / (double)hashSet2.size();
    }

    public static double jaccardIndex(IntegerVector integerVector, IntegerVector integerVector2) {
        int n;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (int i = 0; i < integerVector.length(); ++i) {
            n = integerVector.get(i);
            hashSet.add(n);
            hashSet2.add(n);
        }
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        for (n = 0; n < integerVector2.length(); ++n) {
            int n2 = integerVector2.get(n);
            hashSet3.add(n2);
            hashSet2.add(n2);
        }
        hashSet.retainAll(hashSet3);
        return (double)hashSet.size() / (double)hashSet2.size();
    }

    public static double jaccardIndex(Vector vector, Vector vector2) {
        return Similarity.jaccardIndex(Vectors.asDouble(vector), Vectors.asDouble(vector2));
    }

    public static double spearmanRankCorrelationCoefficient(double[] dArray, double[] dArray2) {
        Similarity.check(dArray, dArray2);
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
        for (int i = 0; i < dArray.length; ++i) {
            treeMap.put(dArray[i], dArray2[i]);
        }
        double[] dArray3 = Arrays.copyOf(dArray2, dArray2.length);
        Arrays.sort(dArray3);
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        for (int i = 0; i < dArray2.length; ++i) {
            hashMap.put(dArray3[i], i);
        }
        Double d = null;
        double d2 = 0.0;
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Double d3 = (Double)entry.getKey();
            Double d4 = (Double)entry.getValue();
            if (d == null) {
                d = d3;
            } else {
                if (d.equals(d3)) {
                    return Similarity.correlation(dArray, dArray2);
                }
                d = d3;
            }
            int n2 = n - (Integer)hashMap.get(d4);
            d2 += (double)(n2 * n2);
            ++n;
        }
        return 1.0 - 6.0 * d2 / (double)(dArray.length * (dArray.length * dArray.length - 1));
    }

    public static double spearmanRankCorrelationCoefficient(int[] nArray, int[] nArray2) {
        Similarity.check(nArray, nArray2);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            treeMap.put(nArray[i], nArray2[i]);
        }
        int[] nArray3 = Arrays.copyOf(nArray2, nArray2.length);
        Arrays.sort(nArray3);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < nArray2.length; ++i) {
            hashMap.put(nArray3[i], i);
        }
        Integer n = null;
        double d = 0.0;
        int n2 = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Integer n3 = (Integer)entry.getKey();
            Integer n4 = (Integer)entry.getValue();
            if (n == null) {
                n = n3;
            } else {
                if (n.equals(n3)) {
                    return Similarity.correlation(nArray, nArray2);
                }
                n = n3;
            }
            int n5 = n2 - (Integer)hashMap.get(n4);
            d += (double)(n5 * n5);
            ++n2;
        }
        return 1.0 - 6.0 * d / (double)(nArray.length * (nArray.length * nArray.length - 1));
    }

    public static double spearmanRankCorrelationCoefficient(DoubleVector doubleVector, DoubleVector doubleVector2) {
        Similarity.check(doubleVector, doubleVector2);
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
        for (int i = 0; i < doubleVector.length(); ++i) {
            treeMap.put(doubleVector.get(i), doubleVector2.get(i));
        }
        double[] dArray = doubleVector2.toArray();
        Arrays.sort(dArray);
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        for (int i = 0; i < doubleVector2.length(); ++i) {
            hashMap.put(dArray[i], i);
        }
        Double d = null;
        double d2 = 0.0;
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Double d3 = (Double)entry.getKey();
            Double d4 = (Double)entry.getValue();
            if (d == null) {
                d = d3;
            } else {
                if (d.equals(d3)) {
                    return Similarity.correlation(doubleVector, doubleVector2);
                }
                d = d3;
            }
            int n2 = n - (Integer)hashMap.get(d4);
            d2 += (double)(n2 * n2);
            ++n;
        }
        return 1.0 - 6.0 * d2 / (double)(doubleVector.length() * (doubleVector.length() * doubleVector.length() - 1));
    }

    public static double spearmanRankCorrelationCoefficient(IntegerVector integerVector, IntegerVector integerVector2) {
        Similarity.check(integerVector, integerVector2);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i < integerVector.length(); ++i) {
            treeMap.put(integerVector.get(i), integerVector2.get(i));
        }
        int[] nArray = integerVector2.toArray();
        Arrays.sort(nArray);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < integerVector2.length(); ++i) {
            hashMap.put(nArray[i], i);
        }
        Integer n = null;
        double d = 0.0;
        int n2 = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Integer n3 = (Integer)entry.getKey();
            Integer n4 = (Integer)entry.getValue();
            if (n == null) {
                n = n3;
            } else {
                if (n.equals(n3)) {
                    return Similarity.correlation((Vector)integerVector, integerVector2);
                }
                n = n3;
            }
            int n5 = n2 - (Integer)hashMap.get(n4);
            d += (double)(n5 * n5);
            ++n2;
        }
        return 1.0 - 6.0 * d / (double)(integerVector.length() * (integerVector.length() * integerVector.length() - 1));
    }

    public static double spearmanRankCorrelationCoefficient(Vector vector, Vector vector2) {
        return Similarity.spearmanRankCorrelationCoefficient(Vectors.asDouble(vector), Vectors.asDouble(vector2));
    }

    public static double averageCommonFeatureRank(double[] dArray, double[] dArray2) {
        Object object;
        Similarity.check(dArray, dArray2);
        int n = dArray.length;
        int n2 = 20;
        class Pair {
            public int i;
            public double v;

            public Pair(int n, double d) {
                this.i = n;
                this.v = d;
            }

            public void set(int n, double d) {
                this.i = n;
                this.v = d;
            }
        }
        Pair[] pairArray = new Pair[n];
        for (int i = 0; i < n; ++i) {
            pairArray[i] = new Pair(i, dArray[i]);
        }
        Pair[] pairArray2 = new Pair[n];
        for (int i = 0; i < n; ++i) {
            pairArray2[i] = new Pair(i, dArray2[i]);
        }
        class PairCompare
        implements Comparator<Pair> {
            PairCompare() {
            }

            @Override
            public int compare(Pair pair, Pair pair2) {
                if (pair.v < pair2.v) {
                    return 1;
                }
                if (pair.v > pair2.v) {
                    return -1;
                }
                if (pair.i < pair2.i) {
                    return 1;
                }
                if (pair.i > pair2.i) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Pair pair, Pair pair2) {
                return this.compare(pair, pair2) == 0;
            }
        }
        Arrays.sort(pairArray, new PairCompare());
        Arrays.sort(pairArray2, new PairCompare());
        Pair[] pairArray3 = new Pair[n];
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            Pair pair = pairArray[i];
            if (i > 0 && pairArray[i].v == pairArray[i - 1].v) {
                pairArray3[pair.i] = new Pair(n3, pair.v);
                continue;
            }
            pairArray3[pair.i] = new Pair(i + 1, pair.v);
            n3 = i + 1;
        }
        n3 = 1;
        Pair[] pairArray4 = new Pair[n];
        for (int i = 0; i < n; ++i) {
            object = pairArray2[i];
            if (i > 0 && pairArray2[i].v == pairArray2[i - 1].v) {
                pairArray4[((Pair)object).i] = new Pair(n3, ((Pair)object).v);
                continue;
            }
            pairArray4[((Pair)object).i] = new Pair(i + 1, ((Pair)object).v);
            n3 = i + 1;
        }
        int[] nArray = new int[n2];
        object = new boolean[n];
        Arrays.fill((boolean[])object, false);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            while (n4 < n && object[pairArray[n4].i] != false) {
                ++n4;
            }
            while (n5 < n && object[pairArray2[n5].i] != false) {
                ++n5;
            }
            if (n4 < n && 1 == new PairCompare().compare(pairArray[n4], pairArray2[n5])) {
                nArray[i] = pairArray[n4].i;
                object[nArray[i]] = true;
                ++n4;
                continue;
            }
            nArray[i] = pairArray2[n5].i;
            object[nArray[i]] = true;
            ++n5;
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += 0.5 * (double)(pairArray3[nArray[i]].i + pairArray4[nArray[i]].i);
        }
        return (double)n2 / d;
    }

    public static double averageCommonFeatureRank(Vector vector, Vector vector2) {
        return Similarity.averageCommonFeatureRank(Vectors.asDouble(vector).toArray(), Vectors.asDouble(vector2).toArray());
    }

    public static double averageCommonFeatureRank(int[] nArray, int[] nArray2) {
        return Similarity.averageCommonFeatureRank(Vectors.asVector(nArray), Vectors.asVector(nArray2));
    }

    public static double linSimilarity(DoubleVector doubleVector, DoubleVector doubleVector2) {
        Similarity.check(doubleVector, doubleVector2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (doubleVector instanceof SparseVector && doubleVector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)doubleVector);
            int[] nArray = sparseVector.getNonZeroIndices();
            Object object = (SparseVector)((Object)doubleVector2);
            int[] nArray2 = object.getNonZeroIndices();
            if (nArray2.length < nArray.length) {
                SparseVector sparseVector2 = sparseVector;
                int[] nArray3 = nArray;
                sparseVector = object;
                nArray = nArray2;
                object = sparseVector2;
                nArray2 = nArray3;
            }
            for (Object object2 : (SparseVector)nArray) {
                double d4 = doubleVector.get((int)object2);
                double d5 = doubleVector2.get((int)object2);
                d += d4;
                d3 += d4 + d5;
            }
            for (Object object2 : (SparseVector)nArray2) {
                d2 += doubleVector2.get((int)object2);
            }
        } else {
            for (int i = 0; i < doubleVector.length(); ++i) {
                double d6 = doubleVector.get(i);
                d += d6;
                double d7 = doubleVector2.get(i);
                d2 += d7;
                if (d6 == 0.0 || d7 == 0.0) continue;
                d3 += d6 + d2;
            }
        }
        return d3 / (d + d2);
    }

    public static double linSimilarity(IntegerVector integerVector, IntegerVector integerVector2) {
        Similarity.check(integerVector, integerVector2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (integerVector instanceof SparseVector && integerVector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)integerVector);
            int[] nArray = sparseVector.getNonZeroIndices();
            Object object = (SparseVector)((Object)integerVector2);
            int[] nArray2 = object.getNonZeroIndices();
            if (nArray2.length < nArray.length) {
                SparseVector sparseVector2 = sparseVector;
                int[] nArray3 = nArray;
                sparseVector = object;
                nArray = nArray2;
                object = sparseVector2;
                nArray2 = nArray3;
            }
            for (Object object2 : (SparseVector)nArray) {
                double d4 = integerVector.get((int)object2);
                double d5 = integerVector2.get((int)object2);
                d += d4;
                d3 += d4 + d5;
            }
            for (Object object2 : (SparseVector)nArray2) {
                d2 += (double)integerVector2.get((int)object2);
            }
        } else {
            for (int i = 0; i < integerVector.length(); ++i) {
                double d6 = integerVector.get(i);
                d += d6;
                double d7 = integerVector2.get(i);
                d2 += d7;
                if (d6 == 0.0 || d7 == 0.0) continue;
                d3 += d6 + d2;
            }
        }
        return d3 / (d + d2);
    }

    public static double linSimilarity(Vector vector, Vector vector2) {
        Similarity.check(vector, vector2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (vector instanceof SparseVector && vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            int[] nArray = sparseVector.getNonZeroIndices();
            Object object = (SparseVector)vector2;
            int[] nArray2 = object.getNonZeroIndices();
            if (nArray2.length < nArray.length) {
                SparseVector sparseVector2 = sparseVector;
                int[] nArray3 = nArray;
                sparseVector = object;
                nArray = nArray2;
                object = sparseVector2;
                nArray2 = nArray3;
            }
            for (Object object2 : (SparseVector)nArray) {
                double d4 = vector.getValue((int)object2).doubleValue();
                double d5 = vector2.getValue((int)object2).doubleValue();
                d += d4;
                d3 += d4 + d5;
            }
            for (Object object2 : (SparseVector)nArray2) {
                d2 += vector2.getValue((int)object2).doubleValue();
            }
        } else {
            for (int i = 0; i < vector.length(); ++i) {
                double d6 = vector.getValue(i).doubleValue();
                d += d6;
                double d7 = vector2.getValue(i).doubleValue();
                d2 += d7;
                if (d6 == 0.0 || d7 == 0.0) continue;
                d3 += d6 + d2;
            }
        }
        return d3 / (d + d2);
    }

    public static double linSimilarity(double[] dArray, double[] dArray2) {
        Similarity.check(dArray, dArray2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            d2 += dArray2[i];
            if (dArray[i] == 0.0 || dArray2[i] == 0.0) continue;
            d3 += dArray[i] + dArray2[i];
        }
        return d3 / (d + d2);
    }

    public static double linSimilarity(int[] nArray, int[] nArray2) {
        Similarity.check(nArray, nArray2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
            d2 += (double)nArray2[i];
            if ((double)nArray[i] == 0.0 || (double)nArray2[i] == 0.0) continue;
            d3 += (double)(nArray[i] + nArray2[i]);
        }
        return d3 / (d + d2);
    }

    public static double klDivergence(DoubleVector doubleVector, DoubleVector doubleVector2) {
        Similarity.check(doubleVector, doubleVector2);
        double d = 0.0;
        if (doubleVector instanceof SparseVector) {
            int[] nArray;
            SparseVector sparseVector = (SparseVector)((Object)doubleVector);
            for (int n : nArray = sparseVector.getNonZeroIndices()) {
                double d2 = doubleVector.get(n);
                double d3 = doubleVector2.get(n);
                if (d3 == 0.0) continue;
                d += d2 * Math.log(d2 / d3);
            }
        } else {
            for (int i = 0; i < doubleVector.length(); ++i) {
                double d4 = doubleVector.get(i);
                double d5 = doubleVector2.get(i);
                if (d4 == 0.0 || d5 == 0.0) continue;
                d += d4 * Math.log(d4 / d5);
            }
        }
        return d;
    }

    public static double klDivergence(IntegerVector integerVector, IntegerVector integerVector2) {
        Similarity.check(integerVector, integerVector2);
        double d = 0.0;
        if (integerVector instanceof SparseVector) {
            int[] nArray;
            SparseVector sparseVector = (SparseVector)((Object)integerVector);
            for (int n : nArray = sparseVector.getNonZeroIndices()) {
                double d2 = integerVector.get(n);
                double d3 = integerVector2.get(n);
                if (d3 == 0.0) continue;
                d += d2 * Math.log(d2 / d3);
            }
        } else {
            for (int i = 0; i < integerVector.length(); ++i) {
                double d4 = integerVector.get(i);
                double d5 = integerVector2.get(i);
                if (d4 == 0.0 || d5 == 0.0) continue;
                d += d4 * Math.log(d4 / d5);
            }
        }
        return d;
    }

    public static double klDivergence(Vector vector, Vector vector2) {
        Similarity.check(vector, vector2);
        double d = 0.0;
        if (vector instanceof SparseVector) {
            int[] nArray;
            SparseVector sparseVector = (SparseVector)vector;
            for (int n : nArray = sparseVector.getNonZeroIndices()) {
                double d2 = vector.getValue(n).doubleValue();
                double d3 = vector2.getValue(n).doubleValue();
                if (d3 == 0.0) continue;
                d += d2 * Math.log(d2 / d3);
            }
        } else {
            for (int i = 0; i < vector.length(); ++i) {
                double d4 = vector.getValue(i).doubleValue();
                double d5 = vector2.getValue(i).doubleValue();
                if (d4 == 0.0 || d5 == 0.0) continue;
                d += d4 * Math.log(d4 / d5);
            }
        }
        return d;
    }

    public static double klDivergence(double[] dArray, double[] dArray2) {
        Similarity.check(dArray, dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0 || dArray2[i] == 0.0) continue;
            d += dArray[i] * Math.log(dArray[i] / dArray2[i]);
        }
        return d;
    }

    public static double klDivergence(int[] nArray, int[] nArray2) {
        Similarity.check(nArray, nArray2);
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            if ((double)nArray[i] == 0.0 || (double)nArray2[i] == 0.0) continue;
            d += (double)nArray[i] * Math.log((double)nArray[i] / (double)nArray2[i]);
        }
        return d;
    }

    public static enum SimType {
        COSINE,
        PEARSON_CORRELATION,
        EUCLIDEAN,
        SPEARMAN_RANK_CORRELATION,
        JACCARD_INDEX,
        LIN,
        KL_DIVERGENCE,
        AVERAGE_COMMON_FEATURE_RANK;

    }
}

