/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.OnDiskSemanticSpace;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.StaticSemanticSpace;
import edu.ucla.sspace.util.SerializableUtil;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorIO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Set;
import java.util.logging.Logger;

public class SemanticSpaceIO {
    private static final Logger LOGGER = Logger.getLogger(SemanticSpaceIO.class.getName());

    private SemanticSpaceIO() {
    }

    static SSpaceFormat getFormat(File file) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        char c = dataInputStream.readChar();
        if (c != 's') {
            dataInputStream.close();
            return SSpaceFormat.SERIALIZE;
        }
        char c2 = dataInputStream.readChar();
        int n = c2 - 48;
        dataInputStream.close();
        return n < 0 || n > SSpaceFormat.values().length ? SSpaceFormat.SERIALIZE : SSpaceFormat.values()[n];
    }

    static boolean fitsInMemory(long l, SSpaceFormat sSpaceFormat) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        long l2 = memoryUsage.getMax() - memoryUsage.getUsed();
        boolean bl = false;
        switch (sSpaceFormat) {
            case BINARY: 
            case SPARSE_BINARY: 
            case SERIALIZE: {
                bl = l < l2;
                break;
            }
            case TEXT: {
                bl = (long)(0.6666666666666666 * (double)l) < l2;
                break;
            }
            case SPARSE_TEXT: {
                bl = (long)(0.75 * (double)l) < l2;
                break;
            }
            default: {
                assert (false) : sSpaceFormat;
                break;
            }
        }
        return bl;
    }

    public static SemanticSpace load(String string) throws IOException {
        return SemanticSpaceIO.load(new File(string));
    }

    @Deprecated
    public static SemanticSpace load(String string, SSpaceFormat sSpaceFormat) throws IOException {
        return SemanticSpaceIO.load(new File(string), sSpaceFormat);
    }

    public static SemanticSpace load(File file) throws IOException {
        SSpaceFormat sSpaceFormat = SemanticSpaceIO.getFormat(file);
        if (sSpaceFormat == null) {
            throw new IllegalArgumentException("The file " + file.getName() + " does not contain any " + "internal format specification.");
        }
        return SemanticSpaceIO.loadInternal(file, sSpaceFormat, false);
    }

    @Deprecated
    public static SemanticSpace load(File file, SSpaceFormat sSpaceFormat) throws IOException {
        return SemanticSpaceIO.loadInternal(file, sSpaceFormat, true);
    }

    private static SemanticSpace loadInternal(File file, SSpaceFormat sSpaceFormat, boolean bl) throws IOException {
        if (sSpaceFormat.equals((Object)SSpaceFormat.SERIALIZE)) {
            LOGGER.fine("Loading serialized SemanticSpace from " + file);
            return (SemanticSpace)SerializableUtil.load(file);
        }
        if (SemanticSpaceIO.fitsInMemory(file.length(), sSpaceFormat)) {
            LOGGER.fine((Object)((Object)sSpaceFormat) + "-formatted .sspace file will fit into " + "memory; creating StaticSemanticSpace");
            if (bl) {
                StaticSemanticSpace staticSemanticSpace = new StaticSemanticSpace(file, sSpaceFormat);
                return staticSemanticSpace;
            }
            return new StaticSemanticSpace(file);
        }
        LOGGER.fine((Object)((Object)sSpaceFormat) + "-formatted .sspace file will not fit into" + "memory; creating OnDiskSemanticSpace");
        if (bl) {
            OnDiskSemanticSpace onDiskSemanticSpace = new OnDiskSemanticSpace(file, sSpaceFormat);
            return onDiskSemanticSpace;
        }
        return new OnDiskSemanticSpace(file);
    }

    public static void save(SemanticSpace semanticSpace, String string) throws IOException {
        SemanticSpaceIO.save(semanticSpace, new File(string), SSpaceFormat.TEXT);
    }

    public static void save(SemanticSpace semanticSpace, File file) throws IOException {
        SemanticSpaceIO.save(semanticSpace, file, SSpaceFormat.TEXT);
    }

    public static void save(SemanticSpace semanticSpace, File file, SSpaceFormat sSpaceFormat) throws IOException {
        switch (sSpaceFormat) {
            case TEXT: {
                SemanticSpaceIO.writeText(semanticSpace, file);
                break;
            }
            case BINARY: {
                SemanticSpaceIO.writeBinary(semanticSpace, file);
                break;
            }
            case SPARSE_TEXT: {
                SemanticSpaceIO.writeSparseText(semanticSpace, file);
                break;
            }
            case SPARSE_BINARY: {
                SemanticSpaceIO.writeSparseBinary(semanticSpace, file);
                break;
            }
            case SERIALIZE: {
                LOGGER.fine("Saving " + semanticSpace + " to disk as serialized object");
                SerializableUtil.save((Object)semanticSpace, file);
                break;
            }
            default: {
                assert (false) : sSpaceFormat;
                break;
            }
        }
    }

    static void writeHeader(OutputStream outputStream, SSpaceFormat sSpaceFormat) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeChar(115);
        dataOutputStream.writeChar(48 + sSpaceFormat.ordinal());
    }

    private static void writeText(SemanticSpace semanticSpace, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        Set<String> set = semanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = semanticSpace.getVectorLength();
        }
        SemanticSpaceIO.writeHeader(fileOutputStream, SSpaceFormat.TEXT);
        printWriter.println(set.size() + " " + n);
        LOGGER.fine("saving text S-Space with " + set.size() + " words with " + n + "-dimensional vectors");
        for (String string : set) {
            printWriter.println(string + "|" + VectorIO.toString(semanticSpace.getVector(string)));
        }
        printWriter.close();
    }

    private static void writeBinary(SemanticSpace semanticSpace, File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        Set<String> set = semanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = semanticSpace.getVectorLength();
        }
        SemanticSpaceIO.writeHeader(dataOutputStream, SSpaceFormat.BINARY);
        dataOutputStream.writeInt(set.size());
        dataOutputStream.writeInt(n);
        LOGGER.fine("saving binary S-Space with " + set.size() + " words with " + n + "-dimensional vectors");
        for (String string : set) {
            dataOutputStream.writeUTF(string);
            Vector vector = semanticSpace.getVector(string);
            for (int i = 0; i < vector.length(); ++i) {
                dataOutputStream.writeDouble(vector.getValue(i).doubleValue());
            }
        }
        dataOutputStream.close();
    }

    private static void writeSparseText(SemanticSpace semanticSpace, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        Set<String> set = semanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = semanticSpace.getVectorLength();
        }
        SemanticSpaceIO.writeHeader(fileOutputStream, SSpaceFormat.SPARSE_TEXT);
        printWriter.println(set.size() + " " + n);
        LOGGER.fine("saving sparse-text S-Space with " + set.size() + " words with " + n + "-dimensional vectors");
        for (String string : set) {
            printWriter.print(string + "|");
            Vector vector = semanticSpace.getVector(string);
            StringBuilder stringBuilder = null;
            if (vector instanceof SparseVector) {
                int n2;
                if (vector instanceof DoubleVector) {
                    SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)vector;
                    int[] nArray = sparseDoubleVector.getNonZeroIndices();
                    stringBuilder = new StringBuilder(nArray.length * 4);
                    stringBuilder.append(nArray[0]).append(",").append(sparseDoubleVector.get(nArray[0]));
                    for (n2 = 1; n2 < nArray.length; ++n2) {
                        stringBuilder.append(",").append(nArray[n2]).append(",").append((Double)sparseDoubleVector.getValue(nArray[n2]));
                    }
                } else {
                    SparseVector sparseVector = (SparseVector)vector;
                    int[] nArray = sparseVector.getNonZeroIndices();
                    stringBuilder = new StringBuilder(nArray.length * 4);
                    stringBuilder.append(nArray[0]).append(",").append(sparseVector.getValue(nArray[0]).doubleValue());
                    for (n2 = 1; n2 < nArray.length; ++n2) {
                        stringBuilder.append(",").append(nArray[n2]).append(",").append(sparseVector.getValue(nArray[n2]).doubleValue());
                    }
                }
            } else {
                boolean bl = true;
                stringBuilder = new StringBuilder(n / 2);
                for (int i = 0; i < vector.length(); ++i) {
                    double d = vector.getValue(i).doubleValue();
                    if (d == 0.0) continue;
                    if (bl) {
                        stringBuilder.append(i).append(",").append(d);
                        bl = false;
                        continue;
                    }
                    stringBuilder.append(",").append(i).append(",").append(d);
                }
            }
            printWriter.println(stringBuilder.toString());
        }
        printWriter.flush();
        printWriter.close();
    }

    private static void writeSparseBinary(SemanticSpace semanticSpace, File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        Set<String> set = semanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = semanticSpace.getVectorLength();
        }
        SemanticSpaceIO.writeHeader(dataOutputStream, SSpaceFormat.SPARSE_BINARY);
        dataOutputStream.writeInt(set.size());
        dataOutputStream.writeInt(n);
        LOGGER.fine("saving sparse-binary S-Space with " + set.size() + " words with " + n + "-dimensional vectors");
        for (String string : set) {
            int n2;
            dataOutputStream.writeUTF(string);
            Vector vector = semanticSpace.getVector(string);
            if (vector instanceof SparseVector) {
                if (vector instanceof DoubleVector) {
                    SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)vector;
                    int[] nArray = sparseDoubleVector.getNonZeroIndices();
                    dataOutputStream.writeInt(nArray.length);
                    for (int n3 : nArray) {
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.writeDouble(sparseDoubleVector.get(n3));
                    }
                    continue;
                }
                SparseVector sparseVector = (SparseVector)vector;
                int[] nArray = sparseVector.getNonZeroIndices();
                dataOutputStream.writeInt(nArray.length);
                for (int n3 : nArray) {
                    dataOutputStream.writeInt(n3);
                    dataOutputStream.writeDouble(sparseVector.getValue(n3).doubleValue());
                }
                continue;
            }
            int n4 = 0;
            for (n2 = 0; n2 < vector.length(); ++n2) {
                if (vector.getValue(n2).doubleValue() == 0.0) continue;
                ++n4;
            }
            dataOutputStream.writeInt(n4);
            for (n2 = 0; n2 < vector.length(); ++n2) {
                double d = vector.getValue(n2).doubleValue();
                if (d == 0.0) continue;
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeDouble(d);
            }
        }
        dataOutputStream.close();
    }

    public static enum SSpaceFormat {
        TEXT,
        BINARY,
        SPARSE_TEXT,
        SPARSE_BINARY,
        SERIALIZE;

    }
}

