/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OnDiskSemanticSpace
implements SemanticSpace {
    private static final Logger LOGGER = Logger.getLogger(OnDiskSemanticSpace.class.getName());
    private Map<String, Long> termToOffset;
    private final boolean containsHeader;
    private int dimensions;
    private String spaceName;
    private RandomAccessBufferedReader textSSpace;
    private RandomAccessFile binarySSpace;
    private SemanticSpaceIO.SSpaceFormat format;

    public OnDiskSemanticSpace(String string) throws IOException {
        this(new File(string));
    }

    public OnDiskSemanticSpace(File file) throws IOException {
        this.containsHeader = true;
        SemanticSpaceIO.SSpaceFormat sSpaceFormat = SemanticSpaceIO.getFormat(file);
        if (sSpaceFormat == null) {
            throw new Error("Unrecognzied format in file: " + file.getName());
        }
        this.loadOffsetsFromFormat(file, sSpaceFormat);
    }

    @Deprecated
    public OnDiskSemanticSpace(File file, SemanticSpaceIO.SSpaceFormat sSpaceFormat) throws IOException {
        this.containsHeader = false;
        this.loadOffsetsFromFormat(file, sSpaceFormat);
    }

    private void loadOffsetsFromFormat(File file, SemanticSpaceIO.SSpaceFormat sSpaceFormat) throws IOException {
        this.format = sSpaceFormat;
        this.spaceName = file.getName();
        this.termToOffset = new LinkedHashMap<String, Long>();
        long l = System.currentTimeMillis();
        int n = -1;
        RandomAccessFile randomAccessFile = null;
        RandomAccessBufferedReader randomAccessBufferedReader = null;
        switch (sSpaceFormat) {
            case TEXT: {
                randomAccessBufferedReader = new RandomAccessBufferedReader(file);
                n = this.loadTextOffsets(randomAccessBufferedReader);
                break;
            }
            case BINARY: {
                randomAccessFile = new RandomAccessFile(file, "r");
                n = this.loadBinaryOffsets(randomAccessFile);
                break;
            }
            case SPARSE_TEXT: {
                randomAccessBufferedReader = new RandomAccessBufferedReader(file);
                n = this.loadSparseTextOffsets(randomAccessBufferedReader);
                break;
            }
            case SPARSE_BINARY: {
                randomAccessFile = new RandomAccessFile(file, "r");
                n = this.loadSparseBinaryOffsets(randomAccessFile);
                break;
            }
            default: {
                assert (false) : sSpaceFormat;
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("loaded " + (Object)((Object)sSpaceFormat) + " .sspace file in " + (System.currentTimeMillis() - l) + "ms");
        }
        this.dimensions = n;
        this.binarySSpace = randomAccessFile;
        this.textSSpace = randomAccessBufferedReader;
    }

    private int loadTextOffsets(RandomAccessBufferedReader randomAccessBufferedReader) throws IOException {
        String string = randomAccessBufferedReader.readLine();
        if (string == null) {
            throw new IOError(new Throwable("An empty file has been passed in"));
        }
        if (this.containsHeader) {
            string = string.substring(4);
        }
        String[] stringArray = string.split("\\s");
        int n = Integer.parseInt(stringArray[1]);
        int n2 = 1;
        while ((string = randomAccessBufferedReader.readLine()) != null) {
            String[] stringArray2 = string.split("\\|");
            this.termToOffset.put(stringArray2[0], Long.valueOf(n2));
            ++n2;
        }
        return n;
    }

    private double[] loadTextVector(String string) throws IOException {
        Long l = this.termToOffset.get(string);
        if (l == null) {
            return null;
        }
        this.textSSpace.moveToLine(l.intValue());
        String string2 = this.textSSpace.readLine();
        double[] dArray = new double[this.dimensions];
        String[] stringArray = string2.split("\\|");
        String[] stringArray2 = stringArray[1].split("\\s");
        if (stringArray2.length != this.dimensions) {
            throw new IOError(new Throwable("improperly formated semantic space file"));
        }
        for (int i = 0; i < this.dimensions; ++i) {
            double d;
            dArray[i] = d = Double.parseDouble(stringArray2[i]);
        }
        return dArray;
    }

    private int loadSparseTextOffsets(RandomAccessBufferedReader randomAccessBufferedReader) throws IOException {
        String string = randomAccessBufferedReader.readLine();
        if (string == null) {
            throw new IOError(new Throwable("An empty file has been passed in"));
        }
        if (this.containsHeader) {
            string = string.substring(4);
            System.out.println(string);
        }
        String[] stringArray = string.split("\\s");
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = 1;
        while ((string = randomAccessBufferedReader.readLine()) != null) {
            String[] stringArray2 = string.split("\\|");
            this.termToOffset.put(stringArray2[0], Long.valueOf(n3));
            ++n3;
        }
        if (n3 - 1 != n2) {
            throw new IOException(String.format("Different number of rows than specified (%d): %d", n2, n3));
        }
        return n;
    }

    private double[] loadSparseTextVector(String string) throws IOException {
        Long l = this.termToOffset.get(string);
        if (l == null) {
            return null;
        }
        this.textSSpace.moveToLine(l.intValue());
        String string2 = this.textSSpace.readLine();
        if (string2 == null) {
            System.out.printf("%s -> null row %d%n", string, l);
        }
        double[] dArray = new double[this.dimensions];
        String[] stringArray = string2.split("\\|");
        String[] stringArray2 = stringArray[1].split(",");
        for (int i = 0; i < stringArray2.length; i += 2) {
            double d;
            int n = Integer.parseInt(stringArray2[i]);
            dArray[n] = d = Double.parseDouble(stringArray2[i + 1]);
        }
        return dArray;
    }

    private int loadBinaryOffsets(RandomAccessFile randomAccessFile) throws IOException {
        if (this.containsHeader) {
            randomAccessFile.readInt();
        }
        int n = randomAccessFile.readInt();
        int n2 = randomAccessFile.readInt();
        for (int i = 0; i < n; ++i) {
            String string = randomAccessFile.readUTF();
            this.termToOffset.put(string, randomAccessFile.getFilePointer());
            for (int j = 0; j < n2; ++j) {
                randomAccessFile.readDouble();
            }
        }
        return n2;
    }

    private double[] loadBinaryVector(String string) throws IOException {
        Long l = this.termToOffset.get(string);
        if (l == null) {
            return null;
        }
        this.binarySSpace.seek(l);
        double[] dArray = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            dArray[i] = this.binarySSpace.readDouble();
        }
        return dArray;
    }

    private int loadSparseBinaryOffsets(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        if (this.containsHeader) {
            n = randomAccessFile.readInt();
        }
        n = randomAccessFile.readInt();
        int n2 = randomAccessFile.readInt();
        for (long i = 0L; i < (long)n; ++i) {
            String string = randomAccessFile.readUTF();
            this.termToOffset.put(string, randomAccessFile.getFilePointer());
            int n3 = randomAccessFile.readInt();
            for (int j = 0; j < n3; ++j) {
                randomAccessFile.readInt();
                randomAccessFile.readDouble();
            }
        }
        return n2;
    }

    private double[] loadSparseBinaryVector(String string) throws IOException {
        Long l = this.termToOffset.get(string);
        if (l == null) {
            return null;
        }
        this.binarySSpace.seek(l);
        int n = this.binarySSpace.readInt();
        double[] dArray = new double[this.dimensions];
        for (int i = 0; i < n; ++i) {
            double d;
            int n2 = this.binarySSpace.readInt();
            dArray[n2] = d = this.binarySSpace.readDouble();
        }
        return dArray;
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.termToOffset.keySet());
    }

    @Override
    public synchronized Vector getVector(String string) {
        try {
            switch (this.format) {
                case TEXT: {
                    return new DenseVector(this.loadTextVector(string));
                }
                case BINARY: {
                    return new DenseVector(this.loadBinaryVector(string));
                }
                case SPARSE_TEXT: {
                    return new CompactSparseVector(this.loadSparseTextVector(string));
                }
                case SPARSE_BINARY: {
                    return new CompactSparseVector(this.loadSparseBinaryVector(string));
                }
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return null;
    }

    @Override
    public String getSpaceName() {
        return this.spaceName;
    }

    @Override
    public int getVectorLength() {
        return this.dimensions;
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) {
        throw new UnsupportedOperationException("OnDiskSemanticSpace instances cannot be updated");
    }

    @Override
    public void processSpace(Properties properties) {
        throw new UnsupportedOperationException("OnDiskSemanticSpace instances cannot be updated");
    }

    private static class RandomAccessBufferedReader {
        private final File backingFile;
        private BufferedReader current;
        private int currentLineNumber;

        public RandomAccessBufferedReader(File file) throws IOException {
            this.backingFile = file;
            this.reset();
        }

        public int getLineNumber() {
            return this.currentLineNumber;
        }

        public void moveToLine(int n) throws IOException {
            if (n < this.currentLineNumber) {
                this.reset();
            }
            for (int i = this.currentLineNumber; i < n; ++i) {
                this.current.readLine();
            }
            this.currentLineNumber = n;
        }

        public String readLine() throws IOException {
            ++this.currentLineNumber;
            return this.current.readLine();
        }

        private void reset() throws IOException {
            this.current = new BufferedReader(new FileReader(this.backingFile));
            this.currentLineNumber = 0;
        }
    }
}

