/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.Transform;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.LoggerUtil;
import edu.ucla.sspace.util.SparseArray;
import edu.ucla.sspace.util.SparseIntHashArray;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public abstract class GenericTermDocumentVectorSpace
implements SemanticSpace {
    protected static final Logger LOG = Logger.getLogger(GenericTermDocumentVectorSpace.class.getName());
    private final BasisMapping<String, String> termToIndex;
    protected final AtomicInteger documentCounter;
    private final MatrixBuilder termDocumentMatrixBuilder;
    private final boolean readHeaderToken;
    protected Matrix wordSpace;

    public GenericTermDocumentVectorSpace() throws IOException {
        this(false, new StringBasisMapping(), Matrices.getMatrixBuilderForSVD());
    }

    public GenericTermDocumentVectorSpace(boolean bl, BasisMapping<String, String> basisMapping, MatrixBuilder matrixBuilder) throws IOException {
        this.readHeaderToken = bl;
        this.termToIndex = basisMapping;
        this.documentCounter = new AtomicInteger(0);
        this.termDocumentMatrixBuilder = matrixBuilder;
        this.wordSpace = null;
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        Serializable serializable;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(1000);
        Iterator<String> iterator = IteratorFactory.tokenize(bufferedReader);
        int n = this.documentCounter.getAndAdd(1);
        if (this.readHeaderToken) {
            this.handleDocumentHeader(n, iterator.next());
        }
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.equals("")) continue;
            this.termToIndex.getDimension(string);
            serializable = (Integer)hashMap.get(string);
            hashMap.put(string, serializable == null ? 1 : 1 + (Integer)serializable);
        }
        bufferedReader.close();
        if (hashMap.isEmpty()) {
            return;
        }
        int n2 = this.termToIndex.numDimensions();
        serializable = new SparseIntHashArray(n2);
        for (Map.Entry entry : hashMap.entrySet()) {
            serializable.set(this.termToIndex.getDimension((String)entry.getKey()), entry.getValue());
        }
        this.termDocumentMatrixBuilder.addColumn((SparseArray<? extends Number>)((Object)serializable));
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.termToIndex.keySet());
    }

    @Override
    public Vector getVector(String string) {
        int n = this.termToIndex.getDimension(string);
        return n < 0 ? null : this.wordSpace.getRowVector(n);
    }

    @Override
    public int getVectorLength() {
        return this.wordSpace.columns();
    }

    protected MatrixFile processSpace(Transform transform) throws IOException {
        this.termDocumentMatrixBuilder.finish();
        File file = this.termDocumentMatrixBuilder.getFile();
        if (transform != null) {
            LoggerUtil.info(LOG, "performing %s transform", transform);
            LoggerUtil.verbose(LOG, "stored term-document matrix in format %s at %s", new Object[]{this.termDocumentMatrixBuilder.getMatrixFormat(), file.getAbsolutePath()});
            file = transform.transform(file, this.termDocumentMatrixBuilder.getMatrixFormat());
            LoggerUtil.verbose(LOG, "transformed matrix to %s", file.getAbsolutePath());
        }
        return new MatrixFile(file, this.termDocumentMatrixBuilder.getMatrixFormat());
    }

    protected void handleDocumentHeader(int n, String string) {
    }
}

