/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.OnDiskSemanticSpace;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class CachingOnDiskSemanticSpace
implements SemanticSpace {
    private static final Logger LOGGER = Logger.getLogger(CachingOnDiskSemanticSpace.class.getName());
    private final Map<String, Vector> wordToVector;
    private final SemanticSpace backingSpace;

    public CachingOnDiskSemanticSpace(String string) throws IOException {
        this(new File(string));
    }

    public CachingOnDiskSemanticSpace(File file) throws IOException {
        this.backingSpace = new OnDiskSemanticSpace(file);
        this.wordToVector = new WeakHashMap<String, Vector>();
    }

    @Override
    public String getSpaceName() {
        return this.backingSpace.getSpaceName();
    }

    @Override
    public Set<String> getWords() {
        return this.backingSpace.getWords();
    }

    @Override
    public synchronized Vector getVector(String string) {
        Vector vector = this.wordToVector.get(string);
        if (vector != null) {
            return Vectors.immutable(vector);
        }
        Vector vector2 = this.backingSpace.getVector(string);
        if (vector2 != null) {
            this.wordToVector.put(string, vector2);
        }
        return vector2;
    }

    @Override
    public int getVectorLength() {
        return this.backingSpace.getVectorLength();
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) {
        throw new UnsupportedOperationException("CachingOnDiskSemanticSpace instances cannot be updated");
    }

    @Override
    public void processSpace(Properties properties) {
        throw new UnsupportedOperationException("CachingOnDiskSemanticSpace instances cannot be updated");
    }
}

