/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ArgOptions {
    private final List<String> positionalArgs = new ArrayList<String>();
    private final Map<Option, String> optionToValue = new HashMap<Option, String>();
    private final Map<String, Option> longNameToOption = new HashMap<String, Option>();
    private final Map<Character, Option> shortNameToOption = new HashMap<Character, Option>();
    private final Map<String, Set<Option>> groupToOptions = new LinkedHashMap<String, Set<Option>>();

    public void addOption(char c, String string, String string2) {
        this.addOption(c, string, string2, false, null, null);
    }

    public void addOption(char c, String string, String string2, boolean bl, String string3) {
        this.addOption(c, string, string2, bl, string3, null);
    }

    public void addOption(char c, String string, String string2, boolean bl, String string3, String string4) {
        Set<Option> set;
        if (string != null && string.length() == 1) {
            throw new IllegalArgumentException("long name must be at least two characters");
        }
        if (bl && string3 == null) {
            throw new IllegalArgumentException("value name must be supposed");
        }
        Option option = new Option(c, string, string2, string3, string4);
        if (this.shortNameToOption.containsKey(Character.valueOf(c)) || string != null && this.longNameToOption.containsKey(string)) {
            throw new IllegalArgumentException("Already specified value with the name: " + string);
        }
        this.shortNameToOption.put(Character.valueOf(c), option);
        if (string != null) {
            this.longNameToOption.put(string, option);
        }
        if ((set = this.groupToOptions.get(string4)) == null) {
            set = new TreeSet<Option>();
            this.groupToOptions.put(string4, set);
        }
        set.add(option);
    }

    public void removeOption(char c) {
        Option option = this.shortNameToOption.remove(Character.valueOf(c));
        if (option == null) {
            return;
        }
        String string = option.longName;
        if (string != null) {
            this.longNameToOption.remove(string);
        }
        Set<Option> set = this.groupToOptions.get(option.optionGroupName);
        set.remove(option);
    }

    public void removeOption(String string) {
        Option option = this.longNameToOption.remove(string);
        if (option == null) {
            return;
        }
        char c = option.shortName;
        this.shortNameToOption.remove(Character.valueOf(c));
        Set<Option> set = this.groupToOptions.get(option.optionGroupName);
        set.remove(option);
    }

    public void parseOptions(String[] stringArray) {
        block0: for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            int n;
            String string = stringArray[i];
            if (string.startsWith("--")) {
                String string2;
                n = string.indexOf("=");
                if (n > 0) {
                    string2 = string.substring(2, n);
                    object2 = string.substring(n + 1);
                    if (((String)object2).length() == 0) {
                        throw new Error("no value specified for " + string2);
                    }
                    object = this.longNameToOption.get(string2);
                    if (object == null) {
                        throw new IllegalArgumentException("unrecognizedOption: " + string);
                    }
                    if (!((Option)object).hasValue()) {
                        throw new Error("Option " + string2 + " does not " + "take a value");
                    }
                    this.optionToValue.put((Option)object, (String)object2);
                    continue;
                }
                string2 = string.substring(2);
                object2 = this.longNameToOption.get(string2);
                if (object2 == null) {
                    throw new IllegalArgumentException("unrecognizedOption: " + string);
                }
                if (((Option)object2).hasValue()) {
                    if (i + 1 >= stringArray.length) {
                        throw new Error("no value specified for " + string2);
                    }
                    object = stringArray[++i];
                    this.optionToValue.put((Option)object2, (String)object);
                    continue;
                }
                this.optionToValue.put((Option)object2, null);
                continue;
            }
            if (string.startsWith("-")) {
                for (n = 1; n < string.length(); ++n) {
                    char c = string.charAt(n);
                    object2 = this.shortNameToOption.get(Character.valueOf(c));
                    if (object2 == null) {
                        throw new IllegalArgumentException("unrecognizedOption: " + string);
                    }
                    if (((Option)object2).hasValue()) {
                        if (n + 1 < string.length()) {
                            object = string.substring(n + 1);
                            this.optionToValue.put((Option)object2, (String)object);
                            continue block0;
                        }
                        if (i + 1 == stringArray.length) {
                            throw new Error("no value specified for " + object2);
                        }
                        object = stringArray[++i];
                        this.optionToValue.put((Option)object2, (String)object);
                        continue block0;
                    }
                    this.optionToValue.put((Option)object2, null);
                }
                continue;
            }
            this.positionalArgs.add(string);
        }
    }

    public int numPositionalArgs() {
        return this.positionalArgs.size();
    }

    public int numProvidedOptions() {
        return this.optionToValue.size();
    }

    public String getPositionalArg(int n) {
        return this.positionalArgs.get(n);
    }

    public List<String> getPositionalArgs() {
        return this.positionalArgs;
    }

    private Option getOption(char c) {
        Option option = this.shortNameToOption.get(Character.valueOf(c));
        if (option == null) {
            throw new IllegalArgumentException("no such option name: " + c);
        }
        return option;
    }

    private Option getOption(String string) {
        Option option = this.longNameToOption.get(string);
        if (option == null) {
            throw new IllegalArgumentException("no such option name: " + string);
        }
        return option;
    }

    public double getDoubleOption(char c) {
        Option option = this.getOption(c);
        if (this.optionToValue.containsKey(option)) {
            return Double.parseDouble(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option -" + c + " does not have a value");
    }

    public double getDoubleOption(char c, double d) {
        Option option = this.getOption(c);
        return this.optionToValue.containsKey(option) ? Double.parseDouble(this.optionToValue.get(option)) : d;
    }

    public double getDoubleOption(String string) {
        Option option = this.getOption(string);
        if (this.optionToValue.containsKey(option)) {
            return Double.parseDouble(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option " + string + " does not have a value");
    }

    public double getDoubleOption(String string, double d) {
        Option option = this.getOption(string);
        return this.optionToValue.containsKey(option) ? Double.parseDouble(this.optionToValue.get(option)) : d;
    }

    public long getLongOption(char c) {
        Option option = this.getOption(c);
        if (this.optionToValue.containsKey(option)) {
            return Long.parseLong(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option -" + c + " does not have a value");
    }

    public long getLongOption(char c, long l) {
        Option option = this.getOption(c);
        return this.optionToValue.containsKey(option) ? Long.parseLong(this.optionToValue.get(option)) : l;
    }

    public long getLongOption(String string) {
        Option option = this.getOption(string);
        if (this.optionToValue.containsKey(option)) {
            return Long.parseLong(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option " + string + " does not have a value");
    }

    public long getLongOption(String string, long l) {
        Option option = this.getOption(string);
        return this.optionToValue.containsKey(option) ? Long.parseLong(this.optionToValue.get(option)) : l;
    }

    public int getIntOption(char c) {
        Option option = this.getOption(c);
        if (this.optionToValue.containsKey(option)) {
            return Integer.parseInt(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option -" + c + " does not have a value");
    }

    public int getIntOption(char c, int n) {
        Option option = this.getOption(c);
        return this.optionToValue.containsKey(option) ? Integer.parseInt(this.optionToValue.get(option)) : n;
    }

    public int getIntOption(String string) {
        Option option = this.getOption(string);
        if (this.optionToValue.containsKey(option)) {
            return Integer.parseInt(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option " + string + " does not have a value");
    }

    public int getIntOption(String string, int n) {
        Option option = this.getOption(string);
        return this.optionToValue.containsKey(option) ? Integer.parseInt(this.optionToValue.get(option)) : n;
    }

    public boolean getBooleanOption(char c) {
        Option option = this.getOption(c);
        if (this.optionToValue.containsKey(option)) {
            return Boolean.parseBoolean(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option -" + c + " does not have a value");
    }

    public boolean getBooleanOption(char c, boolean bl) {
        Option option = this.getOption(c);
        return this.optionToValue.containsKey(option) ? Boolean.parseBoolean(this.optionToValue.get(option)) : bl;
    }

    public boolean getBooleanOption(String string) {
        Option option = this.getOption(string);
        if (this.optionToValue.containsKey(option)) {
            return Boolean.parseBoolean(this.optionToValue.get(option));
        }
        throw new IllegalArgumentException("Option " + string + " does not have a value");
    }

    public boolean getBooleanOption(String string, boolean bl) {
        Option option = this.getOption(string);
        return this.optionToValue.containsKey(option) ? Boolean.parseBoolean(this.optionToValue.get(option)) : bl;
    }

    public String getStringOption(char c) {
        Option option = this.getOption(c);
        if (this.optionToValue.containsKey(option)) {
            return this.optionToValue.get(option);
        }
        throw new IllegalArgumentException("Option -" + c + " does not have a value");
    }

    public String getStringOption(char c, String string) {
        Option option = this.getOption(c);
        return this.optionToValue.containsKey(option) ? this.optionToValue.get(option) : string;
    }

    public String getStringOption(String string) {
        Option option = this.getOption(string);
        if (this.optionToValue.containsKey(option)) {
            return this.optionToValue.get(option);
        }
        throw new IllegalArgumentException("Option " + string + " does not have a value");
    }

    public <T> T getObjectOption(char c, T t) {
        Option option = this.getOption(c);
        if (this.optionToValue.containsKey(option)) {
            return ReflectionUtil.getObjectInstance(this.optionToValue.get(option));
        }
        return t;
    }

    public <T> T getObjectOption(String string, T t) {
        Option option = this.getOption(string);
        if (this.optionToValue.containsKey(option)) {
            return ReflectionUtil.getObjectInstance(this.optionToValue.get(option));
        }
        return t;
    }

    public String getStringOption(String string, String string2) {
        Option option = this.getOption(string);
        return this.optionToValue.containsKey(option) ? this.optionToValue.get(option) : string2;
    }

    public boolean hasOption(String string) {
        Option option = this.longNameToOption.get(string);
        return option == null ? false : this.optionToValue.containsKey(option);
    }

    public boolean hasOption(char c) {
        Option option = this.shortNameToOption.get(Character.valueOf(c));
        return option == null ? false : this.optionToValue.containsKey(option);
    }

    public String prettyPrint() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (Option set2 : this.shortNameToOption.values()) {
            String string;
            String string2 = set2.longName;
            String string3 = set2.valueName;
            if (string2 != null) {
                int n4;
                int n5 = n4 = string3 == null ? string2.length() : string2.length() + string3.length();
                if (n4 > n) {
                    n = n4;
                }
            }
            if ((string = set2.description) == null || n2 >= string.length()) continue;
            n2 = string.length();
        }
        n3 = n + 4 + 9;
        StringBuilder stringBuilder = new StringBuilder(100);
        Set<Option> set = this.groupToOptions.get(null);
        if (set != null) {
            this.printOption(set, "Options", n, n3, stringBuilder);
        }
        for (Map.Entry entry : this.groupToOptions.entrySet()) {
            if (entry.getKey() == null) continue;
            this.printOption((Set)entry.getValue(), (String)entry.getKey(), n, n3, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(12 * this.optionToValue.size());
        stringBuilder.append("Options[");
        for (Map.Entry<Option, String> entry : this.optionToValue.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        return stringBuilder.toString();
    }

    private void printOption(Set<Option> set, String string, int n, int n2, StringBuilder stringBuilder) {
        stringBuilder.append(string).append(":\n");
        for (Option option : set) {
            int n3;
            stringBuilder.append("  -").append(option.shortName);
            int n4 = -1;
            if (option.longName != null) {
                n3 = option.longName.length();
                stringBuilder.append(", --").append(option.longName);
                if (option.valueName != null) {
                    stringBuilder.append("=").append(option.valueName);
                    n3 += option.valueName.length();
                } else {
                    --n3;
                }
                n4 = n - n3 + 4;
            } else {
                n4 = n + 4;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuilder.append(" ");
            }
            if (option.description != null) {
                String[] stringArray = option.description.split("\\s+");
                int n5 = 80 - n2;
                for (String string2 : stringArray) {
                    if (n5 < string2.length()) {
                        stringBuilder.append("\n");
                        for (int i = 0; i < n2; ++i) {
                            stringBuilder.append(" ");
                        }
                        n5 = 80 - n2;
                    }
                    stringBuilder.append(string2).append(" ");
                    n5 -= string2.length() + 1;
                }
            }
            stringBuilder.append("\n");
        }
    }

    private static class Option
    implements Comparable<Option> {
        final char shortName;
        final String longName;
        final String description;
        final String valueName;
        final String optionGroupName;

        public Option(char c, String string, String string2, String string3, String string4) {
            this.shortName = c;
            this.longName = string;
            this.description = string2;
            this.valueName = string3;
            this.optionGroupName = string4;
        }

        @Override
        public int compareTo(Option option) {
            return this.shortName - option.shortName;
        }

        public boolean equals(Object object) {
            if (object instanceof Option) {
                Option option = (Option)object;
                return option.shortName == this.shortName || option.longName != this.longName && option.longName.equals(this.longName);
            }
            return false;
        }

        public int hashCode() {
            return this.longName.hashCode();
        }

        public boolean hasValue() {
            return this.valueName != null;
        }

        public String toString() {
            return "-" + this.shortName + ", --" + this.longName;
        }
    }
}

