/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.coals;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.matrix.CellMaskedSparseMatrix;
import edu.ucla.sspace.matrix.CorrelationTransform;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SVD;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorMath;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Coals
implements SemanticSpace {
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.coals.Coals";
    public static final String REDUCE_MATRIX_PROPERTY = "edu.ucla.sspace.coals.Coals.reduce";
    public static final String REDUCE_DIMENSION_PROPERTY = "edu.ucla.sspace.coals.Coals.dimension";
    public static final String MAX_DIMENSIONS_PROPERTY = "edu.ucla.sspace.coals.Coals.maxDimensions";
    public static final String MAX_WORDS_PROPERTY = "edu.ucla.sspace.coals.Coals.maxWords";
    public static final String DO_NOT_NORMALIZE_PROPERTY = "edu.ucla.sspace.coals.Coals.doNotNormalize";
    private static final String DEFAULT_REDUCE_DIMENSIONS = "800";
    private static final String DEFAULT_MAX_DIMENSIONS = "14000";
    private static final String DEFAULT_MAX_WORDS = "15000";
    public static final String COALS_SSPACE_NAME = "coals-semantic-space";
    private static final Logger COALS_LOGGER = Logger.getLogger(Coals.class.getName());
    private Map<String, SparseDoubleVector> wordToSemantics;
    private Map<String, Integer> termToIndex = new HashMap<String, Integer>();
    private ConcurrentMap<String, AtomicInteger> totalWordFreq = new ConcurrentHashMap<String, AtomicInteger>();
    Matrix finalCorrelation = null;
    boolean reduceMatrix;
    int reducedDimensions;
    private int wordIndexCounter;

    public Coals() {
        this.wordToSemantics = new HashMap<String, SparseDoubleVector>(1024, 4.0f);
    }

    @Override
    public Set<String> getWords() {
        return this.termToIndex.keySet();
    }

    @Override
    public Vector getVector(String string) {
        Integer n = this.termToIndex.get(string);
        if (n == null) {
            return null;
        }
        return Vectors.immutable(this.finalCorrelation.getRowVector(n));
    }

    @Override
    public String getSpaceName() {
        String string = COALS_SSPACE_NAME;
        if (this.reduceMatrix) {
            string = string + "-svd-" + this.reducedDimensions;
        }
        return string;
    }

    @Override
    public int getVectorLength() {
        return this.finalCorrelation.columns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        SparseDoubleVector sparseDoubleVector;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, SparseDoubleVector> hashMap2 = new HashMap<String, SparseDoubleVector>();
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            arrayDeque2.offer(iterator.next());
        }
        while (!arrayDeque2.isEmpty()) {
            String string;
            if (iterator.hasNext()) {
                arrayDeque2.offer(iterator.next());
            }
            if (!(string = (String)arrayDeque2.remove()).equals("")) {
                int n;
                this.getIndexFor(string);
                Integer object = (Integer)hashMap.get(string);
                hashMap.put(string, object == null ? 1 : 1 + object);
                sparseDoubleVector = (SparseDoubleVector)hashMap2.get(string);
                if (sparseDoubleVector == null) {
                    sparseDoubleVector = new SparseHashDoubleVector(Integer.MAX_VALUE);
                    hashMap2.put(string, sparseDoubleVector);
                }
                int n2 = 4 - arrayDeque.size();
                for (String string2 : arrayDeque) {
                    ++n2;
                    if (string2.equals("")) continue;
                    n = this.getIndexFor(string2);
                    sparseDoubleVector.add(n, n2);
                }
                n2 = 5;
                for (String string2 : arrayDeque2) {
                    --n2;
                    if (string2.equals("")) continue;
                    n = this.getIndexFor(string2);
                    sparseDoubleVector.add(n, n2);
                }
            }
            arrayDeque.offer(string);
            if (arrayDeque.size() <= 4) continue;
            arrayDeque.remove();
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            sparseDoubleVector = this.getSemanticVector((String)entry.getKey());
            sparseDoubleVector.getNonZeroIndices();
            SparseDoubleVector sparseDoubleVector2 = sparseDoubleVector;
            synchronized (sparseDoubleVector2) {
                VectorMath.add(sparseDoubleVector, (DoubleVector)entry.getValue());
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            int n = (Integer)entry.getValue();
            AtomicInteger atomicInteger = this.totalWordFreq.putIfAbsent((String)entry.getKey(), new AtomicInteger(n));
            if (atomicInteger == null) continue;
            atomicInteger.addAndGet(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparseDoubleVector getSemanticVector(String string) {
        SparseDoubleVector sparseDoubleVector = this.wordToSemantics.get(string);
        if (sparseDoubleVector == null) {
            Coals coals = this;
            synchronized (coals) {
                sparseDoubleVector = this.wordToSemantics.get(string);
                if (sparseDoubleVector == null) {
                    sparseDoubleVector = new CompactSparseVector();
                    this.wordToSemantics.put(string, sparseDoubleVector);
                }
            }
        }
        return sparseDoubleVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndexFor(String string) {
        Integer n = this.termToIndex.get(string);
        if (n == null) {
            Coals coals = this;
            synchronized (coals) {
                n = this.termToIndex.get(string);
                if (n == null) {
                    int n2 = this.wordIndexCounter++;
                    this.termToIndex.put(string, n2);
                    return n2;
                }
            }
        }
        return n;
    }

    @Override
    public void processSpace(Properties properties) {
        Matrix[] matrixArray;
        this.reduceMatrix = properties.getProperty(REDUCE_MATRIX_PROPERTY) != null;
        this.reducedDimensions = Integer.parseInt(properties.getProperty(REDUCE_DIMENSION_PROPERTY, DEFAULT_REDUCE_DIMENSIONS));
        boolean bl = properties.getProperty(DO_NOT_NORMALIZE_PROPERTY) == null;
        int n = Integer.parseInt(properties.getProperty(MAX_WORDS_PROPERTY, DEFAULT_MAX_WORDS));
        int n2 = Integer.parseInt(properties.getProperty(MAX_DIMENSIONS_PROPERTY, DEFAULT_MAX_DIMENSIONS));
        COALS_LOGGER.info("Droppring dimensions from co-occurrance matrix.");
        this.finalCorrelation = this.buildMatrix(n, n2);
        COALS_LOGGER.info("Done dropping dimensions.");
        if (bl) {
            COALS_LOGGER.info("Normalizing co-occurrance matrix.");
            int n3 = this.finalCorrelation.rows();
            matrixArray = new CorrelationTransform();
            this.finalCorrelation = matrixArray.transform(this.finalCorrelation);
            COALS_LOGGER.info("Done normalizing co-occurrance matrix.");
        }
        if (this.reduceMatrix) {
            COALS_LOGGER.info("Reducing using SVD.");
            try {
                File file = File.createTempFile("coals-term-doc-matrix", "dat");
                file.deleteOnExit();
                MatrixIO.writeMatrix(this.finalCorrelation, file, MatrixIO.Format.SVDLIBC_SPARSE_BINARY);
                if (this.reducedDimensions > this.finalCorrelation.columns()) {
                    this.reducedDimensions = this.finalCorrelation.columns();
                }
                matrixArray = SVD.svd(file, SVD.Algorithm.ANY, MatrixIO.Format.SVDLIBC_SPARSE_BINARY, this.reducedDimensions);
                this.finalCorrelation = matrixArray[0];
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            COALS_LOGGER.info("Done reducing using SVD.");
        }
    }

    private Matrix buildMatrix(int n, int n2) {
        SparseDoubleVector[] sparseDoubleVectorArray = new SparseDoubleVector[this.wordToSemantics.size()];
        for (Map.Entry<String, SparseDoubleVector> stringArray2 : this.wordToSemantics.entrySet()) {
            sparseDoubleVectorArray[this.getIndexFor((String)stringArray2.getKey())] = stringArray2.getValue();
        }
        Object object = Matrices.asSparseMatrix(Arrays.asList(sparseDoubleVectorArray));
        if (n == 0) {
            n = this.wordToSemantics.size();
        }
        COALS_LOGGER.info("Forming the inverse mapping from terms to indices.");
        String[] stringArray = new String[this.termToIndex.size()];
        for (Map.Entry<String, Integer> n3 : this.termToIndex.entrySet()) {
            stringArray[n3.getValue().intValue()] = n3.getKey();
        }
        COALS_LOGGER.info("Sorting the terms based on frequency.");
        ArrayList arrayList = new ArrayList(this.totalWordFreq.entrySet());
        Collections.sort(arrayList, new EntryComp());
        COALS_LOGGER.info("Generating the index masks.");
        int n3 = arrayList.size() > n2 ? n2 : arrayList.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n3];
        SparseDoubleVector[] sparseDoubleVectorArray2 = new SparseDoubleVector[n];
        int n4 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Integer n5 = this.termToIndex.get(entry.getKey());
            if (n5 == null) continue;
            if (n4 < n) {
                if (n4 < n3) {
                    nArray2[n4] = n5;
                }
                sparseDoubleVectorArray2[n4] = sparseDoubleVectorArray[n5];
                nArray[n4] = n4;
                this.termToIndex.put((String)entry.getKey(), n4);
                ++n4;
                continue;
            }
            this.termToIndex.remove(entry.getKey());
        }
        this.wordToSemantics = null;
        object = Matrices.asSparseMatrix(Arrays.asList(sparseDoubleVectorArray2));
        return new CellMaskedSparseMatrix((SparseMatrix)object, nArray, nArray2);
    }

    private class EntryComp
    implements Comparator<Map.Entry<String, AtomicInteger>> {
        private EntryComp() {
        }

        @Override
        public int compare(Map.Entry<String, AtomicInteger> entry, Map.Entry<String, AtomicInteger> entry2) {
            int n = entry2.getValue().get() - entry.getValue().get();
            return n != 0 ? n : entry2.getKey().compareTo(entry.getKey());
        }
    }
}

