/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering.seeding;

import edu.ucla.sspace.clustering.seeding.KMeansSeed;
import edu.ucla.sspace.common.Statistics;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.util.BitSet;

public class RandomSeed
implements KMeansSeed {
    @Override
    public DoubleVector[] chooseSeeds(int n, Matrix matrix) {
        DoubleVector[] doubleVectorArray = new DoubleVector[n];
        if (n >= matrix.rows()) {
            int n2;
            for (n2 = 0; n2 < matrix.rows(); ++n2) {
                doubleVectorArray[n2] = matrix.getRowVector(n2);
            }
            for (n2 = matrix.rows(); n2 < n; ++n2) {
                doubleVectorArray[n2] = new DenseVector(matrix.columns());
            }
            return doubleVectorArray;
        }
        BitSet bitSet = Statistics.randomDistribution(n, matrix.rows());
        int n3 = 0;
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            doubleVectorArray[n3] = matrix.getRowVector(n4);
            ++n3;
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        return doubleVectorArray;
    }
}

