/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering.criterion;

import edu.ucla.sspace.clustering.criterion.BaseFunction;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseDynamicMagnitudeVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import java.util.List;

public class E1Function
extends BaseFunction {
    private DoubleVector completeCentroid;
    private double[] simToComplete;

    public E1Function() {
    }

    E1Function(List<DoubleVector> list, DoubleVector[] doubleVectorArray, double[] dArray, int[] nArray, int[] nArray2, DoubleVector doubleVector, double[] dArray2) {
        super(list, doubleVectorArray, dArray, nArray, nArray2);
        this.completeCentroid = doubleVector;
        this.simToComplete = dArray2;
    }

    @Override
    protected void subSetup(Matrix matrix) {
        this.completeCentroid = new DenseDynamicMagnitudeVector(matrix.rows());
        for (DoubleVector doubleVector : this.matrix) {
            VectorMath.add(this.completeCentroid, doubleVector);
        }
        this.simToComplete = new double[this.centroids.length];
        for (int i = 0; i < this.centroids.length; ++i) {
            this.simToComplete[i] = VectorMath.dotProduct(this.centroids[i], this.completeCentroid);
        }
    }

    @Override
    protected double getOldCentroidScore(DoubleVector doubleVector, int n, int n2) {
        double d = this.simToComplete[n];
        d -= VectorMath.dotProduct(this.completeCentroid, doubleVector);
        d /= E1Function.subtractedMagnitude(this.centroids[n], doubleVector);
        return d *= (double)n2;
    }

    @Override
    protected double getNewCentroidScore(int n, DoubleVector doubleVector) {
        double d = VectorMath.dotProduct(this.completeCentroid, doubleVector);
        d += this.simToComplete[n];
        d /= E1Function.modifiedMagnitude(this.centroids[n], doubleVector);
        return d *= (double)(this.clusterSizes[n] + 1);
    }

    @Override
    public boolean isMaximize() {
        return false;
    }

    @Override
    protected void updateScores(int n, int n2, DoubleVector doubleVector) {
        int n3 = n;
        this.simToComplete[n3] = this.simToComplete[n3] + VectorMath.dotProduct(this.completeCentroid, doubleVector);
        int n4 = n2;
        this.simToComplete[n4] = this.simToComplete[n4] - VectorMath.dotProduct(this.completeCentroid, doubleVector);
    }
}

