/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering.criterion;

import edu.ucla.sspace.clustering.criterion.CriterionFunction;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DenseDynamicMagnitudeVector;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseFunction
implements CriterionFunction {
    protected List<DoubleVector> matrix;
    protected int[] assignments;
    protected DoubleVector[] centroids;
    protected int[] clusterSizes;
    protected double[] costs;

    public BaseFunction() {
    }

    BaseFunction(List<DoubleVector> list, DoubleVector[] doubleVectorArray, double[] dArray, int[] nArray, int[] nArray2) {
        this.matrix = list;
        this.centroids = doubleVectorArray;
        this.costs = dArray;
        this.assignments = nArray;
        this.clusterSizes = nArray2;
    }

    @Override
    public void setup(Matrix matrix, int[] nArray, int n) {
        int n2;
        int n3;
        this.assignments = nArray;
        this.matrix = new ArrayList<DoubleVector>(matrix.rows());
        for (n3 = 0; n3 < matrix.rows(); ++n3) {
            this.matrix.add(matrix.getRowVector(n3));
        }
        this.centroids = new DoubleVector[n];
        this.clusterSizes = new int[n];
        this.costs = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            this.centroids[n3] = new DenseVector(matrix.columns());
        }
        for (n3 = 0; n3 < matrix.rows(); ++n3) {
            n2 = nArray[n3];
            VectorMath.add(this.centroids[n2], this.matrix.get(n3));
            int n4 = n2;
            this.clusterSizes[n4] = this.clusterSizes[n4] + 1;
        }
        for (n3 = 0; n3 < n; ++n3) {
            this.centroids[n3] = new DenseDynamicMagnitudeVector(this.centroids[n3].toArray());
        }
        this.subSetup(matrix);
        CompactSparseVector compactSparseVector = new CompactSparseVector(matrix.columns());
        for (n2 = 0; n2 < n; ++n2) {
            if (this.clusterSizes[n2] == 0) continue;
            this.costs[n2] = this.getOldCentroidScore(compactSparseVector, n2, this.clusterSizes[n2]);
        }
    }

    protected void subSetup(Matrix matrix) {
    }

    @Override
    public boolean update(int n) {
        int n2 = this.assignments[n];
        double d = this.isMaximize() ? 0.0 : Double.MAX_VALUE;
        int n3 = -1;
        DoubleVector doubleVector = this.matrix.get(n);
        double d2 = this.clusterSizes[n2] == 1 ? 0.0 : this.getOldCentroidScore(doubleVector, n2, this.clusterSizes[n2] - 1);
        d2 -= this.costs[n2];
        for (int i = 0; i < this.centroids.length; ++i) {
            if (n2 == i) continue;
            double d3 = this.getNewCentroidScore(i, doubleVector);
            double d4 = d3 - this.costs[i] + d2;
            if (this.isMaximize()) {
                if (!(d4 > 0.0) || !(d4 > d)) continue;
                d = d4;
                n3 = i;
                continue;
            }
            if (!(d4 < d)) continue;
            d = d4;
            n3 = i;
        }
        if (n3 >= 0) {
            double d5 = d - d2;
            int n4 = n2;
            this.costs[n4] = this.costs[n4] + d2;
            int n5 = n3;
            this.costs[n5] = this.costs[n5] + d5;
            this.updateScores(n3, n2, doubleVector);
            int n6 = n2;
            this.clusterSizes[n6] = this.clusterSizes[n6] - 1;
            int n7 = n3;
            this.clusterSizes[n7] = this.clusterSizes[n7] + 1;
            this.centroids[n2] = BaseFunction.subtract(this.centroids[n2], doubleVector);
            this.centroids[n3] = VectorMath.add(this.centroids[n3], doubleVector);
            this.assignments[n] = n3;
            return true;
        }
        return false;
    }

    protected abstract double getOldCentroidScore(DoubleVector var1, int var2, int var3);

    protected abstract double getNewCentroidScore(int var1, DoubleVector var2);

    protected void updateScores(int n, int n2, DoubleVector doubleVector) {
    }

    protected static DoubleVector subtract(DoubleVector doubleVector, DoubleVector doubleVector2) {
        DenseDynamicMagnitudeVector denseDynamicMagnitudeVector = new DenseDynamicMagnitudeVector(doubleVector.length());
        if (doubleVector2 instanceof SparseDoubleVector) {
            SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)doubleVector2;
            int[] nArray = sparseDoubleVector.getNonZeroIndices();
            int n = 0;
            for (int i = 0; i < doubleVector.length(); ++i) {
                double d = doubleVector.get(i);
                if (n < nArray.length && i == nArray[n]) {
                    d -= sparseDoubleVector.get(nArray[n++]);
                }
                denseDynamicMagnitudeVector.set(i, d);
            }
        } else {
            for (int i = 0; i < doubleVector.length(); ++i) {
                denseDynamicMagnitudeVector.set(i, doubleVector.get(i) - doubleVector2.get(i));
            }
        }
        return denseDynamicMagnitudeVector;
    }

    @Override
    public int[] assignments() {
        return this.assignments;
    }

    @Override
    public DoubleVector[] centroids() {
        return this.centroids;
    }

    @Override
    public int[] clusterSizes() {
        return this.clusterSizes;
    }

    @Override
    public double score() {
        double d = 0.0;
        for (double d2 : this.costs) {
            d += d2;
        }
        return d;
    }

    protected static double modifiedMagnitudeSqrd(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector2 instanceof SparseDoubleVector) {
            SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)doubleVector2;
            int[] nArray = sparseDoubleVector.getNonZeroIndices();
            double d = Math.pow(doubleVector.magnitude(), 2.0);
            for (int n : nArray) {
                double d2 = doubleVector.get(n);
                d -= Math.pow(d2, 2.0);
                d += Math.pow(d2 + doubleVector2.get(n), 2.0);
            }
            return d;
        }
        double d = 0.0;
        int n = doubleVector.length();
        for (int i = 0; i < n; ++i) {
            double d3 = doubleVector.get(i) + doubleVector2.get(i);
            d += d3 * d3;
        }
        return d;
    }

    protected static double modifiedMagnitude(DoubleVector doubleVector, DoubleVector doubleVector2) {
        return Math.sqrt(BaseFunction.modifiedMagnitudeSqrd(doubleVector, doubleVector2));
    }

    protected static double subtractedMagnitudeSqrd(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector2 instanceof SparseDoubleVector) {
            SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)doubleVector2;
            int[] nArray = sparseDoubleVector.getNonZeroIndices();
            double d = Math.pow(doubleVector.magnitude(), 2.0);
            for (int n : nArray) {
                double d2 = doubleVector.get(n);
                d -= Math.pow(d2, 2.0);
                d += Math.pow(d2 - doubleVector2.get(n), 2.0);
            }
            return d;
        }
        double d = 0.0;
        for (int i = 0; i < doubleVector.length(); ++i) {
            d += Math.pow(doubleVector.get(i) - doubleVector2.get(i), 2.0);
        }
        return d;
    }

    protected static double subtractedMagnitude(DoubleVector doubleVector, DoubleVector doubleVector2) {
        return Math.sqrt(BaseFunction.subtractedMagnitudeSqrd(doubleVector, doubleVector2));
    }
}

