/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.CentroidCluster;
import edu.ucla.sspace.clustering.Cluster;
import edu.ucla.sspace.clustering.OnlineClustering;
import edu.ucla.sspace.util.Generator;
import edu.ucla.sspace.util.Properties;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class StreamingKMeans<T extends DoubleVector>
implements Generator<OnlineClustering<T>> {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.cluster.StreamingKMeans";
    public static final String NUM_POINTS_PROPERTY = "edu.ucla.sspace.cluster.StreamingKMeans.maxPoints";
    public static final String ALPHA_PROPERTY = "edu.ucla.sspace.cluster.StreamingKMeans.alpha";
    public static final String COFL_PROPERTY = "edu.ucla.sspace.cluster.StreamingKMeans.cofl";
    public static final String KOFL_PROPERTY = "edu.ucla.sspace.cluster.StreamingKMeans.kofl";
    public static final String BETA_PROPERTY = "edu.ucla.sspace.cluster.StreamingKMeans.beta";
    public static final String GAMMA_PROPERTY = "edu.ucla.sspace.cluster.StreamingKMeans.gamma";
    public static final int DEFAULT_NUM_CLUSTERS = 2;
    public static final int DEFAULT_NUM_POINTS = 1000;
    public static final double DEFAULT_ALPHA = 2.0;
    public static final double DEFAULT_COFL = 2.0;
    public static final double DEFAULT_KOFL = 2.0;
    public static final double DEFAULT_BETA = 216.25;
    public static final double DEFAULT_GAMMA = 42.25;
    private final int numClusters;
    private final double logNumPoints;
    private final double alpha;
    private final double cofl;
    private final double kofl;
    private final double beta;
    private final double gamma;

    public StreamingKMeans() {
        this(new Properties());
    }

    public StreamingKMeans(Properties properties) {
        this.numClusters = properties.getProperty("edu.ucla.sspace.clustering.OnlineClustering.numClusters", 2);
        int n = properties.getProperty(NUM_POINTS_PROPERTY, 1000);
        this.logNumPoints = Math.log(n) / Math.log(2.0);
        this.alpha = properties.getProperty(ALPHA_PROPERTY, 2.0);
        this.cofl = properties.getProperty(COFL_PROPERTY, 2.0);
        this.kofl = properties.getProperty(KOFL_PROPERTY, 2.0);
        this.beta = 2.0 * this.alpha * this.alpha * this.cofl + 2.0 * this.alpha;
        this.gamma = Math.max(4.0 * this.alpha * this.alpha * this.alpha * this.cofl * this.cofl + 2.0 * this.alpha * this.alpha * this.cofl, this.beta * this.kofl + 1.0);
    }

    @Override
    public OnlineClustering<T> generate() {
        return new StreamingKMeansClustering(this.alpha, this.beta, this.gamma, this.numClusters, this.logNumPoints);
    }

    public String toString() {
        return "StreamingKMeans";
    }

    public class StreamingKMeansClustering<T extends DoubleVector>
    implements OnlineClustering<T> {
        private List<T> firstKPoints;
        private double LCost;
        private double facilityCost;
        private double totalCost;
        private final double alpha;
        private final double beta;
        private final double gamma;
        private final double logNumPoints;
        private final int numClusters;
        private List<Cluster<T>> facilities = new CopyOnWriteArrayList<Cluster<T>>();
        private final AtomicInteger idCounter = new AtomicInteger(1);
        private final double costThreshold;
        private final double facilityThreshold;

        public StreamingKMeansClustering(double d, double d2, double d3, int n, double d4) {
            this.firstKPoints = new ArrayList<T>(n);
            this.numClusters = n;
            this.alpha = d;
            this.beta = d2;
            this.gamma = d3;
            this.logNumPoints = d4;
            this.costThreshold = d3;
            this.facilityThreshold = (1.0 + d4) * (double)n;
            this.LCost = 1.0;
            this.facilityCost = this.LCost / ((double)n * (1.0 + d4));
            this.totalCost = 0.0;
        }

        @Override
        public synchronized int addVector(T t) {
            int n = this.idCounter.getAndAdd(1);
            if (this.addDataPoint(t, n) < 0) {
                List<Cluster<T>> list = this.facilities;
                this.facilities = new ArrayList<Cluster<T>>();
                this.LCost *= this.beta;
                this.facilityCost = this.LCost / ((double)this.numClusters * (1.0 + this.logNumPoints));
                for (Cluster<T> cluster : list) {
                    int n2 = this.addDataPoint(cluster.centroid(), 0);
                    Cluster<T> cluster2 = this.facilities.get(n2);
                    cluster2.dataPointIds().or(cluster.dataPointIds());
                }
            }
            return n;
        }

        private int addDataPoint(T t, int n) {
            boolean bl;
            double d = Double.MAX_VALUE;
            int n2 = 0;
            Cluster<T> cluster = null;
            int n3 = 0;
            for (Cluster<T> cluster2 : this.facilities) {
                double d2 = cluster2.compareWithVector(t);
                if ((d2 = -1.0 * d2 + 1.0) < d) {
                    d = d2;
                    cluster = cluster2;
                    n2 = n3;
                }
                ++n3;
            }
            double d3 = Math.min(d / this.facilityCost, 1.0);
            boolean bl2 = bl = this.facilities.size() == 0 || Math.random() < d3;
            if (bl) {
                CentroidCluster<DoubleVector> centroidCluster = new CentroidCluster<DoubleVector>((DoubleVector)Vectors.instanceOf(t));
                centroidCluster.addVector((DoubleVector)t, n > 0 ? n : -1);
                this.facilities.add(centroidCluster);
                n2 = this.facilities.size() - 1;
            } else {
                cluster.addVector(t, n > 0 ? n : -1);
                this.totalCost += d;
            }
            if (n != 0) {
                if (this.totalCost > this.gamma * this.LCost) {
                    return -1;
                }
                if ((double)this.facilities.size() >= this.facilityThreshold) {
                    return -2;
                }
            }
            return n2;
        }

        @Override
        public Cluster<T> getCluster(int n) {
            if (this.facilities.size() <= n || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.facilities.get(n);
        }

        @Override
        public List<Cluster<T>> getClusters() {
            return this.facilities;
        }

        @Override
        public synchronized int size() {
            return this.facilities.size();
        }

        public String toString() {
            return "StreamingKMeansClustering-numClusters" + this.numClusters;
        }
    }
}

