/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.EigenCut;
import edu.ucla.sspace.clustering.HardAssignment;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.util.Generator;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.ScaledDoubleVector;
import edu.ucla.sspace.vector.ScaledSparseDoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class SpectralClustering {
    private static final Logger LOGGER = Logger.getLogger(SpectralClustering.class.getName());
    private final double alpha;
    private final double beta;
    private final Generator<EigenCut> cutterGenerator;

    public SpectralClustering(double d, Generator<EigenCut> generator) {
        this.alpha = d;
        this.beta = 1.0 - d;
        this.cutterGenerator = generator;
    }

    public Assignments cluster(Matrix matrix) {
        ClusterResult clusterResult = this.fullCluster(this.scaleMatrix(matrix), 0);
        this.verbose("Created " + clusterResult.numClusters + " clusters");
        Assignment[] assignmentArray = new HardAssignment[clusterResult.assignments.length];
        for (int i = 0; i < clusterResult.assignments.length; ++i) {
            assignmentArray[i] = new HardAssignment(clusterResult.assignments[i]);
        }
        return new Assignments(clusterResult.numClusters, assignmentArray, matrix);
    }

    public Assignments cluster(Matrix matrix, int n, boolean bl) {
        LimitedResult[] limitedResultArray = this.limitedCluster(this.scaleMatrix(matrix), n, bl);
        LimitedResult limitedResult = limitedResultArray.length == 1 ? limitedResultArray[0] : limitedResultArray[n - 1];
        for (int i = n - 2; limitedResult == null && i >= 0; --i) {
            limitedResult = limitedResultArray[i];
        }
        this.verbose("Created " + limitedResult.numClusters + " clusters");
        Assignment[] assignmentArray = new HardAssignment[limitedResult.assignments.length];
        for (int i = 0; i < limitedResult.assignments.length; ++i) {
            assignmentArray[i] = new HardAssignment(limitedResult.assignments[i]);
        }
        return new Assignments(limitedResult.numClusters, assignmentArray, matrix);
    }

    private Matrix scaleMatrix(Matrix matrix) {
        if (matrix instanceof SparseMatrix) {
            ArrayList<ScaledSparseDoubleVector> arrayList = new ArrayList<ScaledSparseDoubleVector>(matrix.rows());
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            for (int i = 0; i < matrix.rows(); ++i) {
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
                arrayList.add(new ScaledSparseDoubleVector(sparseDoubleVector, 1.0 / sparseDoubleVector.magnitude()));
            }
            return Matrices.asSparseMatrix(arrayList);
        }
        ArrayList<ScaledDoubleVector> arrayList = new ArrayList<ScaledDoubleVector>(matrix.rows());
        for (int i = 0; i < matrix.rows(); ++i) {
            DoubleVector doubleVector = matrix.getRowVector(i);
            arrayList.add(new ScaledDoubleVector(doubleVector, 1.0 / doubleVector.magnitude()));
        }
        return Matrices.asMatrix(arrayList);
    }

    private ClusterResult fullCluster(Matrix matrix, int n) {
        this.verbose("Clustering at depth " + n);
        if (matrix.rows() <= 1) {
            return new ClusterResult(new int[matrix.rows()], 1);
        }
        EigenCut eigenCut = this.cutterGenerator.generate();
        eigenCut.computeCut(matrix);
        Matrix matrix2 = eigenCut.getLeftCut();
        Matrix matrix3 = eigenCut.getRightCut();
        this.verbose(String.format("Splitting into two matricies %d-%d", matrix2.rows(), matrix3.rows()));
        if (matrix2.rows() == matrix.rows() || matrix3.rows() == matrix.rows()) {
            return new ClusterResult(new int[matrix.rows()], 1);
        }
        ClusterResult clusterResult = this.fullCluster(matrix2, n + 1);
        ClusterResult clusterResult2 = this.fullCluster(matrix3, n + 1);
        this.verbose("Merging at depth " + n);
        double d = eigenCut.getSplitObjective(this.alpha, this.beta, clusterResult.numClusters, clusterResult.assignments, clusterResult2.numClusters, clusterResult2.assignments);
        double d2 = eigenCut.getMergedObjective(this.alpha, this.beta);
        int[] nArray = new int[matrix.rows()];
        int n2 = 1;
        if (d2 < d) {
            this.verbose("Selecting to combine sub trees at depth " + n);
            Arrays.fill(nArray, 0);
        } else {
            int n3;
            this.verbose("Selecting to maintain sub trees at depth " + n);
            n2 = clusterResult.numClusters + clusterResult2.numClusters;
            int[] nArray2 = eigenCut.getLeftReordering();
            int[] nArray3 = eigenCut.getRightReordering();
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                nArray[nArray2[n3]] = clusterResult.assignments[n3];
            }
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                nArray[nArray3[n3]] = clusterResult2.assignments[n3] + clusterResult.numClusters;
            }
        }
        return new ClusterResult(nArray, n2);
    }

    private LimitedResult[] limitedCluster(Matrix matrix, int n) {
        return this.limitedCluster(matrix, n, false);
    }

    private LimitedResult[] limitedCluster(Matrix matrix, int n, boolean bl) {
        this.verbose("Clustering for " + n + " clusters.");
        EigenCut eigenCut = this.cutterGenerator.generate();
        if (matrix.rows() <= 1 || n <= 1) {
            eigenCut.computeRhoSum(matrix);
            LimitedResult limitedResult = bl ? new KMeansLimitedResult(new int[matrix.rows()], 1, eigenCut.getKMeansObjective()) : new SpectralLimitedResult(new int[matrix.rows()], 1, eigenCut.getMergedObjective(this.alpha, this.beta), eigenCut.rhoSum() - (double)matrix.rows() / 2.0, matrix.rows() * (matrix.rows() - 1) / 2);
            return new LimitedResult[]{limitedResult};
        }
        eigenCut.computeCut(matrix);
        Matrix matrix2 = eigenCut.getLeftCut();
        Matrix matrix3 = eigenCut.getRightCut();
        if (matrix2.rows() == matrix.rows() || matrix3.rows() == matrix.rows()) {
            eigenCut.computeRhoSum(matrix);
            LimitedResult limitedResult = bl ? new KMeansLimitedResult(new int[matrix.rows()], 1, eigenCut.getKMeansObjective()) : new SpectralLimitedResult(new int[matrix.rows()], 1, eigenCut.getMergedObjective(this.alpha, this.beta), eigenCut.rhoSum() - (double)matrix.rows() / 2.0, matrix.rows() * (matrix.rows() - 1) / 2);
            return new LimitedResult[]{limitedResult};
        }
        this.verbose(String.format("Splitting into two matricies %d-%d", matrix2.rows(), matrix3.rows()));
        LimitedResult[] limitedResultArray = this.limitedCluster(matrix2, n - 1, bl);
        LimitedResult[] limitedResultArray2 = this.limitedCluster(matrix3, n - 1, bl);
        this.verbose("Merging at for: " + n + " clusters");
        int[] nArray = eigenCut.getLeftReordering();
        int[] nArray2 = eigenCut.getRightReordering();
        LimitedResult[] limitedResultArray3 = new LimitedResult[n];
        limitedResultArray3[0] = bl ? new KMeansLimitedResult(new int[matrix.rows()], 1, eigenCut.getKMeansObjective()) : new SpectralLimitedResult(new int[matrix.rows()], 1, eigenCut.getMergedObjective(this.alpha, this.beta), eigenCut.rhoSum() - (double)matrix.rows() / 2.0, matrix.rows() * (matrix.rows() - 1) / 2);
        for (int i = 0; i < limitedResultArray.length; ++i) {
            LimitedResult limitedResult = limitedResultArray[i];
            if (limitedResult == null) continue;
            for (int j = 0; j < limitedResultArray2.length; ++j) {
                int n2;
                LimitedResult limitedResult2 = limitedResultArray2[j];
                if (limitedResult2 == null || (n2 = limitedResult.numClusters + limitedResult2.numClusters - 1) >= limitedResultArray3.length) continue;
                LimitedResult limitedResult3 = bl ? limitedResult.combine(limitedResult, limitedResult2, nArray, nArray2, 0.0) : limitedResult.combine(limitedResult, limitedResult2, nArray, nArray2, eigenCut.rhoSum());
                if (limitedResultArray3[n2] != null && !(limitedResultArray3[n2].compareTo(limitedResult3) < 0.0)) continue;
                limitedResultArray3[n2] = limitedResult3;
            }
        }
        return limitedResultArray3;
    }

    private void verbose(String string) {
        LOGGER.info(string);
    }

    private class ClusterResult {
        public int[] assignments;
        public int numClusters;

        public ClusterResult(int[] nArray, int n) {
            this.assignments = nArray;
            this.numClusters = n;
        }
    }

    private class SpectralLimitedResult
    extends LimitedResult {
        public double totalScore;
        public double rawInterScore;
        public int interCount;

        public SpectralLimitedResult(int[] nArray, int n, double d, double d2, int n2) {
            super(nArray, n);
            this.totalScore = d;
            this.rawInterScore = d2;
            this.interCount = n2;
        }

        @Override
        public double score() {
            return this.totalScore;
        }

        @Override
        public double compareTo(LimitedResult limitedResult) {
            return limitedResult.score() - this.score();
        }

        @Override
        LimitedResult combine(LimitedResult limitedResult, LimitedResult limitedResult2, int[] nArray, int[] nArray2, double d) {
            SpectralLimitedResult spectralLimitedResult = (SpectralLimitedResult)limitedResult;
            SpectralLimitedResult spectralLimitedResult2 = (SpectralLimitedResult)limitedResult2;
            int[] nArray3 = this.combineAssignments(limitedResult, limitedResult2, nArray, nArray2);
            int n = limitedResult.numClusters + limitedResult2.numClusters;
            double d2 = spectralLimitedResult.rawInterScore + spectralLimitedResult2.rawInterScore;
            int n2 = spectralLimitedResult.interCount + spectralLimitedResult2.interCount;
            double d3 = (d - (double)nArray3.length) / 2.0 - d2;
            d2 = (double)n2 - d2;
            double d4 = SpectralClustering.this.alpha * d2 + SpectralClustering.this.beta * d3;
            return new SpectralLimitedResult(nArray3, n, d4, d2, n2);
        }
    }

    private class KMeansLimitedResult
    extends LimitedResult {
        public double score;

        public KMeansLimitedResult(int[] nArray, int n, double d) {
            super(nArray, n);
            this.score = d;
        }

        @Override
        LimitedResult combine(LimitedResult limitedResult, LimitedResult limitedResult2, int[] nArray, int[] nArray2, double d) {
            KMeansLimitedResult kMeansLimitedResult = (KMeansLimitedResult)limitedResult;
            KMeansLimitedResult kMeansLimitedResult2 = (KMeansLimitedResult)limitedResult2;
            int[] nArray3 = this.combineAssignments(limitedResult, limitedResult2, nArray, nArray2);
            int n = limitedResult.numClusters + limitedResult2.numClusters;
            double d2 = kMeansLimitedResult.score + kMeansLimitedResult2.score;
            return new KMeansLimitedResult(nArray3, n, d2);
        }

        @Override
        public double score() {
            return this.score;
        }

        @Override
        public double compareTo(LimitedResult limitedResult) {
            return this.score() - limitedResult.score();
        }
    }

    private abstract class LimitedResult {
        public int[] assignments;
        public int numClusters;

        public LimitedResult(int[] nArray, int n) {
            this.assignments = nArray;
            this.numClusters = n;
        }

        int[] combineAssignments(LimitedResult limitedResult, LimitedResult limitedResult2, int[] nArray, int[] nArray2) {
            int n;
            int[] nArray3 = new int[limitedResult.assignments.length + limitedResult2.assignments.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray3[nArray[n]] = limitedResult.assignments[n];
            }
            for (n = 0; n < nArray2.length; ++n) {
                nArray3[nArray2[n]] = limitedResult2.assignments[n] + limitedResult.numClusters;
            }
            return nArray3;
        }

        abstract double score();

        abstract double compareTo(LimitedResult var1);

        abstract LimitedResult combine(LimitedResult var1, LimitedResult var2, int[] var3, int[] var4, double var5);
    }
}

