/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering;
import edu.ucla.sspace.clustering.Merge;
import edu.ucla.sspace.clustering.SoftAssignment;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.AbstractMatrix;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.SparseHashMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.SparseSymmetricMatrix;
import edu.ucla.sspace.util.HashMultiMap;
import edu.ucla.sspace.util.MultiMap;
import edu.ucla.sspace.util.WorkQueue;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinkClustering
implements Clustering,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.LinkClustering";
    public static final String KEEP_SIMILARITY_MATRIX_IN_MEMORY_PROPERTY = "edu.ucla.sspace.clustering.LinkClustering.keepSimilarityMatrixInMemory";
    private static final Logger LOGGER = Logger.getLogger(LinkClustering.class.getName());
    private static final WorkQueue WORK_QUEUE = new WorkQueue();
    private List<Merge> mergeOrder = null;
    private List<Edge> edgeList = null;
    private int numRows = 0;

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        LOGGER.warning("Link clustering does not take a specified number of clusters.  Clustering the matrix anyway.");
        return this.cluster(matrix, properties);
    }

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        int n;
        int n222;
        Object object;
        Object object2;
        int n3;
        int n4;
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Input matrix is not square. Matrix is expected to be a square matrix whose values (i,j) denote an edge from row i to row j");
        }
        if (!(matrix instanceof SparseMatrix)) {
            throw new IllegalArgumentException("Input matrix must be a sparse matrix.");
        }
        SparseMatrix sparseMatrix = (SparseMatrix)matrix;
        String string = properties.getProperty(KEEP_SIMILARITY_MATRIX_IN_MEMORY_PROPERTY);
        boolean bl = string != null ? Boolean.parseBoolean(string) : true;
        this.numRows = n4 = sparseMatrix.rows();
        LOGGER.fine("Generating link similarity matrix for " + n4 + " nodes");
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        this.edgeList = arrayList;
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = sparseMatrix.getRowVector(n3);
            for (int n222 : object = object2.getNonZeroIndices()) {
                if (n3 > n222) {
                    arrayList.add(new Edge(n3, n222));
                    continue;
                }
                if (n3 >= n222 || sparseMatrix.get(n222, n3) != 0.0) continue;
                arrayList.add(new Edge(n3, n222));
            }
        }
        n3 = arrayList.size();
        LOGGER.fine("Number of edges to cluster: " + n3);
        object2 = this.getEdgeSimMatrix(arrayList, sparseMatrix, bl);
        LOGGER.fine("Computing single linkage link clustering");
        object = new HierarchicalAgglomerativeClustering().buildDendrogram((Matrix)object2, HierarchicalAgglomerativeClustering.ClusterLinkage.SINGLE_LINKAGE);
        this.mergeOrder = object;
        LOGGER.fine("Calculating partition densitities");
        Object object3 = new ConcurrentSkipListMap();
        Object object4 = WORK_QUEUE.registerTaskGroup(object.size());
        int n5 = 0;
        while (n5 < object.size()) {
            n222 = n5++;
            WORK_QUEUE.add(object4, new Runnable((List)object, n222, n3, n4, arrayList, (ConcurrentNavigableMap)object3){
                final /* synthetic */ List val$mergeOrder;
                final /* synthetic */ int val$part;
                final /* synthetic */ int val$numEdges;
                final /* synthetic */ int val$rows;
                final /* synthetic */ List val$edgeList;
                final /* synthetic */ ConcurrentNavigableMap val$partitionDensities;
                {
                    this.val$mergeOrder = list;
                    this.val$part = n;
                    this.val$numEdges = n2;
                    this.val$rows = n3;
                    this.val$edgeList = list2;
                    this.val$partitionDensities = concurrentNavigableMap;
                }

                @Override
                public void run() {
                    List list = this.val$mergeOrder.subList(0, this.val$part);
                    MultiMap multiMap = LinkClustering.convertMergesToAssignments(list, this.val$numEdges);
                    double d = 0.0;
                    for (Integer n : multiMap.keySet()) {
                        Set set = multiMap.get(n);
                        int n2 = set.size();
                        BitSet bitSet = new BitSet(this.val$rows);
                        for (Integer n3 : set) {
                            Edge edge = (Edge)this.val$edgeList.get(n3);
                            bitSet.set(edge.from);
                            bitSet.set(edge.to);
                        }
                        int n4 = bitSet.cardinality();
                        double d2 = ((double)n2 - ((double)n4 - 1.0)) / ((double)n4 * ((double)n4 - 1.0) / 2.0 - (double)(n2 - 1));
                        d += d2;
                    }
                    double d3 = 2.0 / (double)this.val$numEdges * d;
                    LOGGER.log(Level.FINER, "Partition solution {0} had density {1}", new Object[]{this.val$part, d3});
                    this.val$partitionDensities.put(d3, this.val$part);
                }
            });
        }
        WORK_QUEUE.await(object4);
        Map.Entry entry = object3.lastEntry();
        LOGGER.fine("Partition " + entry.getValue() + " had the highest density: " + entry.getKey());
        n222 = (Integer)entry.getValue();
        MultiMap<Integer, Integer> multiMap = LinkClustering.convertMergesToAssignments(object.subList(0, n222), n3);
        ArrayList arrayList2 = new ArrayList(n4);
        for (n = 0; n < n4; ++n) {
            arrayList2.add(new HashSet());
        }
        n = 0;
        for (Integer assignmentArray2 : multiMap.keySet()) {
            Set<Integer> i = multiMap.get(assignmentArray2);
            for (Integer n2 : i) {
                Edge edge = (Edge)arrayList.get(n2);
                ((Set)arrayList2.get(edge.from)).add(n);
                ((Set)arrayList2.get(edge.to)).add(n);
            }
            ++n;
        }
        int n7 = 0;
        Assignment[] assignmentArray = new Assignment[n4];
        for (int i = 0; i < assignmentArray.length; ++i) {
            assignmentArray[i] = new SoftAssignment((Collection)arrayList2.get(i));
        }
        return new Assignments(n7, assignmentArray, matrix);
    }

    private Matrix getEdgeSimMatrix(List<Edge> list, SparseMatrix sparseMatrix, boolean bl) {
        return bl ? this.calculateEdgeSimMatrix(list, sparseMatrix) : new LazySimilarityMatrix(list, sparseMatrix);
    }

    private Matrix calculateEdgeSimMatrix(final List<Edge> list, final SparseMatrix sparseMatrix) {
        final int n = list.size();
        final SparseSymmetricMatrix sparseSymmetricMatrix = new SparseSymmetricMatrix(new SparseHashMatrix(n, n));
        Object object = WORK_QUEUE.registerTaskGroup(n);
        int n2 = 0;
        while (n2 < n) {
            final int n3 = n2++;
            WORK_QUEUE.add(object, new Runnable(){

                @Override
                public void run() {
                    for (int i = n3; i < n; ++i) {
                        Edge edge;
                        Edge edge2 = (Edge)list.get(n3);
                        double d = LinkClustering.this.getEdgeSimilarity(sparseMatrix, edge2, edge = (Edge)list.get(i));
                        if (!(d > 0.0)) continue;
                        sparseSymmetricMatrix.set(n3, i, d);
                    }
                }
            });
        }
        WORK_QUEUE.await(object);
        return sparseSymmetricMatrix;
    }

    private static MultiMap<Integer, Integer> convertMergesToAssignments(List<Merge> list, int n) {
        HashMultiMap<Integer, Integer> hashMultiMap = new HashMultiMap<Integer, Integer>();
        for (int i = 0; i < n; ++i) {
            hashMultiMap.put(i, i);
        }
        for (Merge merge : list) {
            hashMultiMap.putMulti(merge.remainingCluster(), hashMultiMap.remove(merge.mergedCluster()));
        }
        return hashMultiMap;
    }

    protected double getEdgeSimilarity(SparseMatrix sparseMatrix, Edge edge, Edge edge2) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (edge.from == edge2.from) {
            n = edge.from;
            n2 = edge.to;
            n3 = edge2.to;
        } else if (edge.from == edge2.to) {
            n = edge.from;
            n2 = edge.to;
            n3 = edge2.from;
        } else if (edge2.to == edge.from) {
            n = edge.from;
            n2 = edge.to;
            n3 = edge2.from;
        } else if (edge.to == edge2.to) {
            n = edge.to;
            n2 = edge.from;
            n3 = edge2.from;
        } else {
            return 0.0;
        }
        int[] nArray = LinkClustering.getImpostNeighbors(sparseMatrix, n2);
        int[] nArray2 = LinkClustering.getImpostNeighbors(sparseMatrix, n3);
        double d = Similarity.jaccardIndex(nArray, nArray2);
        return d;
    }

    private static int[] getImpostNeighbors(SparseMatrix sparseMatrix, int n) {
        int[] nArray = sparseMatrix.getRowVector(n).getNonZeroIndices();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length + 1);
        nArray2[nArray2.length - 1] = n;
        return nArray2;
    }

    public double getSolutionDensity(int n) {
        if (n < 0 || n >= this.mergeOrder.size()) {
            throw new IllegalArgumentException("not a valid solution: " + n);
        }
        if (this.mergeOrder == null || this.edgeList == null) {
            throw new IllegalStateException("initial clustering solution is not valid yet");
        }
        int n2 = this.edgeList.size();
        List<Merge> list = this.mergeOrder.subList(0, n);
        MultiMap<Integer, Integer> multiMap = LinkClustering.convertMergesToAssignments(list, n2);
        double d = 0.0;
        for (Integer n3 : multiMap.keySet()) {
            Set<Integer> set = multiMap.get(n3);
            int n4 = set.size();
            BitSet bitSet = new BitSet(this.numRows);
            for (Integer n5 : set) {
                Edge edge = this.edgeList.get(n5);
                bitSet.set(edge.from);
                bitSet.set(edge.to);
            }
            int n6 = bitSet.cardinality();
            double d2 = ((double)n4 - ((double)n6 - 1.0)) / ((double)n6 * ((double)n6 - 1.0) / 2.0 - (double)(n4 - 1));
            d += d2;
        }
        double d3 = 2.0 / (double)n2 * d;
        return d3;
    }

    public Assignments getSolution(int n) {
        int n2;
        if (n < 0 || n >= this.mergeOrder.size()) {
            throw new IllegalArgumentException("not a valid solution: " + n);
        }
        if (this.mergeOrder == null || this.edgeList == null) {
            throw new IllegalStateException("initial clustering solution is not valid yet");
        }
        int n3 = this.edgeList.size();
        MultiMap<Integer, Integer> multiMap = LinkClustering.convertMergesToAssignments(this.mergeOrder.subList(0, n), n3);
        ArrayList arrayList = new ArrayList(this.numRows);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            arrayList.add(new HashSet());
        }
        n2 = 0;
        for (Integer n4 : multiMap.keySet()) {
            Set<Integer> set = multiMap.get(n4);
            for (Integer n5 : set) {
                Edge edge = this.edgeList.get(n5);
                ((Set)arrayList.get(edge.from)).add(n2);
                ((Set)arrayList.get(edge.to)).add(n2);
            }
            ++n2;
        }
        Assignment[] assignmentArray = new Assignment[this.numRows];
        for (int i = 0; i < assignmentArray.length; ++i) {
            assignmentArray[i] = new SoftAssignment((Collection)arrayList.get(i));
        }
        return new Assignments(n2, assignmentArray);
    }

    public int numberOfSolutions() {
        return this.mergeOrder == null ? 0 : this.mergeOrder.size();
    }

    private class LazySimilarityMatrix
    extends AbstractMatrix {
        private final List<Edge> edgeList;
        private final SparseMatrix sm;

        public LazySimilarityMatrix(List<Edge> list, SparseMatrix sparseMatrix) {
            this.edgeList = list;
            this.sm = sparseMatrix;
        }

        @Override
        public int columns() {
            return this.edgeList.size();
        }

        @Override
        public double get(int n, int n2) {
            Edge edge = this.edgeList.get(n);
            Edge edge2 = this.edgeList.get(n2);
            double d = LinkClustering.this.getEdgeSimilarity(this.sm, edge, edge2);
            return d;
        }

        @Override
        public DoubleVector getRowVector(int n) {
            int n2 = this.columns();
            DenseVector denseVector = new DenseVector(n2);
            for (int i = 0; i < n2; ++i) {
                denseVector.set(i, this.get(n, i));
            }
            return denseVector;
        }

        @Override
        public int rows() {
            return this.edgeList.size();
        }

        @Override
        public void set(int n, int n2, double d) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Edge {
        public final int from;
        public final int to;

        public Edge(int n, int n2) {
            this.from = n;
            this.to = n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Edge) {
                Edge edge = (Edge)object;
                return edge.from == this.from && edge.to == this.to;
            }
            return false;
        }

        public int hashCode() {
            return this.from ^ this.to;
        }

        public String toString() {
            return "(" + this.from + "->" + this.to + ")";
        }
    }
}

