/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.DirectClustering;
import edu.ucla.sspace.clustering.criterion.CriterionFunction;
import edu.ucla.sspace.matrix.ClutoSparseMatrixBuilder;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.RowMagnitudeTransform;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.TfIdfDocStripedTransform;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

public class GapStatistic
implements Clustering {
    private static final Logger LOGGER = Logger.getLogger(GapStatistic.class.getName());
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.GapStatistic";
    public static final String NUM_CLUSTERS_START = "edu.ucla.sspace.clustering.GapStatistic.numClusterStart";
    public static final String NUM_REFERENCE_DATA_SETS = "edu.ucla.sspace.clustering.GapStatistic.numReferenceDataSets";
    public static final String METHOD_PROPERTY = "edu.ucla.sspace.clustering.GapStatistic.method";
    private static final String DEFAULT_NUM_CLUSTERS_START = "1";
    private static final String DEFAULT_NUM_CLUSTERS_END = "10";
    private static final String DEFAULT_NUM_REFERENCE_DATA_SETS = "5";
    private static final String DEFAULT_METHOD = "edu.ucla.sspace.clustering.criterion.H2Function";
    private static final Random random = new Random();

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        return this.cluster(matrix, Integer.MAX_VALUE, properties);
    }

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        int n2 = Integer.parseInt(properties.getProperty(NUM_CLUSTERS_START, DEFAULT_NUM_CLUSTERS_START));
        int n3 = Integer.parseInt(properties.getProperty(NUM_REFERENCE_DATA_SETS, DEFAULT_NUM_REFERENCE_DATA_SETS));
        int n4 = n - n2;
        String string = properties.getProperty(METHOD_PROPERTY, DEFAULT_METHOD);
        this.verbose("Transforming the original data set");
        TfIdfDocStripedTransform tfIdfDocStripedTransform = new TfIdfDocStripedTransform();
        RowMagnitudeTransform rowMagnitudeTransform = new RowMagnitudeTransform();
        matrix = rowMagnitudeTransform.transform(tfIdfDocStripedTransform.transform(matrix));
        this.verbose("Generating the reference data set");
        ReferenceDataGenerator referenceDataGenerator = new ReferenceDataGenerator(matrix);
        Matrix[] matrixArray = new Matrix[n3];
        for (int i = 0; i < n3; ++i) {
            matrixArray[i] = rowMagnitudeTransform.transform(tfIdfDocStripedTransform.transform(referenceDataGenerator.generateTestData()));
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        Assignments[] assignmentsArray = new Assignments[n4];
        Assignments assignments = null;
        double d = Double.NEGATIVE_INFINITY;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            this.clusterIteration(i, n2, string, matrix, matrixArray, dArray, dArray2, assignmentsArray);
            if (d >= dArray[i] - dArray2[i]) break;
            d = dArray[i];
            assignments = assignmentsArray[i];
            n5 = i + n2;
        }
        return assignments;
    }

    private void clusterIteration(int n, int n2, String string, Matrix matrix, Matrix[] matrixArray, double[] dArray, double[] dArray2, Assignments[] assignmentsArray) {
        int n3 = n + n2;
        int n4 = matrixArray.length;
        CriterionFunction criterionFunction = (CriterionFunction)ReflectionUtil.getObjectInstance(string);
        this.verbose("Clustering reference data for %d clusters\n", n3);
        double d = 0.0;
        double[] dArray3 = new double[n4];
        for (int i = 0; i < matrixArray.length; ++i) {
            this.verbose("Clustering reference data %d \n", i);
            Assignments assignments = DirectClustering.cluster(matrixArray[i], n3, 1, criterionFunction);
            dArray3[i] = Math.log(criterionFunction.score());
            d += dArray3[i];
        }
        d /= (double)n4;
        double d2 = 0.0;
        for (double d3 : dArray3) {
            d2 += Math.pow(d3 - d, 2.0);
        }
        d2 /= (double)n4;
        d2 = Math.sqrt(d2);
        this.verbose("Clustering original data for %d clusters\n", n3);
        Assignments assignments = DirectClustering.cluster(matrix, n3, 1, criterionFunction);
        double d4 = Math.log(criterionFunction.score());
        this.verbose("Completed iteration with referenceScore: %f, gap:%f\n", d, d4);
        d4 = d - d4;
        System.out.printf("k: %d gap: %f std: %f\n", n, d4, d2);
        dArray[n] = d4;
        dArray2[n] = d2;
        assignmentsArray[n] = assignments;
    }

    protected void verbose(String string) {
        LOGGER.fine(string);
    }

    protected void verbose(String string, Object ... objectArray) {
        LOGGER.fine(String.format(string, objectArray));
    }

    private class ReferenceDataGenerator {
        private final double[] minValues;
        private final double[] maxValues;
        private final double averageNumValuesPerRow;
        private final double stdevNumValuesPerRow;
        private final int rows;
        private Set<Integer> nonZeroFeatures;

        public ReferenceDataGenerator(Matrix matrix) {
            int n;
            this.rows = matrix.rows();
            this.minValues = new double[matrix.columns()];
            this.maxValues = new double[matrix.columns()];
            this.nonZeroFeatures = new HashSet<Integer>();
            int[] nArray = new int[matrix.rows()];
            double d = 0.0;
            if (matrix instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                for (n = 0; n < matrix.rows(); ++n) {
                    SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(n);
                    int[] nArray2 = sparseDoubleVector.getNonZeroIndices();
                    int n2 = n;
                    nArray[n2] = nArray[n2] + nArray2.length;
                    d += (double)nArray2.length;
                    for (int n3 : nArray2) {
                        this.nonZeroFeatures.add(n3);
                        double d2 = sparseDoubleVector.get(n3);
                        if (d2 < this.minValues[n3]) {
                            this.minValues[n3] = d2;
                        }
                        if (!(d2 > this.maxValues[n3])) continue;
                        this.maxValues[n3] = d2;
                    }
                }
            } else {
                for (int i = 0; i < matrix.rows(); ++i) {
                    for (n = 0; n < matrix.columns(); ++n) {
                        double d3 = matrix.get(i, n);
                        if (d3 < this.minValues[n]) {
                            this.minValues[n] = d3;
                        }
                        if (d3 > this.maxValues[n]) {
                            this.maxValues[n] = d3;
                        }
                        if (d3 == 0.0) continue;
                        int n4 = i;
                        nArray[n4] = nArray[n4] + 1;
                        d += 1.0;
                        this.nonZeroFeatures.add(n);
                    }
                }
            }
            this.averageNumValuesPerRow = d / (double)matrix.rows();
            double d4 = 0.0;
            for (Object object : (SparseDoubleVector)nArray) {
                d4 += Math.pow(this.averageNumValuesPerRow - (double)object, 2.0);
            }
            this.stdevNumValuesPerRow = Math.sqrt(d4 / (double)matrix.rows());
        }

        public Matrix generateTestData() {
            GapStatistic.this.verbose("Generating a new reference set");
            ArrayList<CompactSparseVector> arrayList = new ArrayList<CompactSparseVector>();
            ClutoSparseMatrixBuilder clutoSparseMatrixBuilder = new ClutoSparseMatrixBuilder();
            for (int i = 0; i < this.rows; ++i) {
                int n = this.minValues.length;
                CompactSparseVector compactSparseVector = new CompactSparseVector(n);
                int n2 = (int)(random.nextGaussian() * this.stdevNumValuesPerRow + this.averageNumValuesPerRow);
                if (n2 == 0) {
                    ++n2;
                }
                for (int j = 0; j < n2; ++j) {
                    int n3 = this.getNonZeroColumn();
                    double d = random.nextDouble() * (this.maxValues[n3] - this.minValues[n3]) + this.minValues[n3];
                    compactSparseVector.set(n3, d);
                }
                arrayList.add(compactSparseVector);
            }
            return Matrices.asSparseMatrix(arrayList);
        }

        private int getNonZeroColumn() {
            int n;
            while (!this.nonZeroFeatures.contains(n = random.nextInt(this.minValues.length))) {
            }
            return n;
        }
    }
}

