/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.HardAssignment;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SparseMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClutoWrapper {
    private static final Logger LOGGER = Logger.getLogger(ClutoWrapper.class.getName());

    private ClutoWrapper() {
    }

    static Assignments cluster(Matrix matrix, String string, String string2, int n) throws IOException {
        Assignment[] assignmentArray = new Assignment[matrix.rows()];
        File file = File.createTempFile("cluto-output", ".matrix");
        file.deleteOnExit();
        ClutoWrapper.cluster(assignmentArray, matrix, string, string2, n, file);
        ClutoWrapper.extractAssignments(file, assignmentArray);
        return new Assignments(n, assignmentArray, matrix);
    }

    static String cluster(Assignment[] assignmentArray, Matrix matrix, String string, String string2, int n, File file) throws IOException {
        LOGGER.log(Level.FINE, "clustering {0} data points with {1} features", new Object[]{matrix.rows(), matrix.columns()});
        File file2 = File.createTempFile("cluto-input", ".matrix");
        MatrixIO.writeMatrix(matrix, file2, matrix instanceof SparseMatrix ? MatrixIO.Format.CLUTO_SPARSE : MatrixIO.Format.CLUTO_DENSE);
        String string3 = ClutoWrapper.cluster(assignmentArray, file2, string, string2, file, n);
        if (!file2.delete()) {
            file2.deleteOnExit();
        }
        return string3;
    }

    public static String cluster(Assignment[] assignmentArray, File file, String string, String string2, File file2, int n) throws IOException {
        String string3 = "vcluster -clmethod=" + string + " " + "-clustfile=" + file2 + " " + "-crfun=" + string2 + " " + file + " " + n;
        LOGGER.fine("executing: " + string3);
        Process process = Runtime.getRuntime().exec(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string4 = null;
        StringBuilder stringBuilder = new StringBuilder("Cluto output:\n");
        String string5 = null;
        while ((string5 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string5).append("\n");
        }
        string4 = stringBuilder.toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            System.err.println(string4);
        }
        int n2 = 0;
        try {
            n2 = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.SEVERE, "Cluto", interruptedException);
        }
        LOGGER.finer("Cluto exit status: " + n2);
        if (n2 == 0 && assignmentArray != null) {
            ClutoWrapper.extractAssignments(file2, assignmentArray);
        } else if (n2 != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string6 = null;
            while ((string6 = bufferedReader2.readLine()) != null) {
                stringBuilder2.append(string6).append("\n");
            }
            LOGGER.warning("Cluto exited with error status.  " + n2 + " stderr:\n" + stringBuilder2.toString());
            throw new Error("Clustering failed");
        }
        bufferedReader.close();
        bufferedReader2.close();
        return string4;
    }

    static void extractAssignments(File file, Assignment[] assignmentArray) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        for (int i = 0; i < assignmentArray.length; ++i) {
            int n = Integer.parseInt(bufferedReader.readLine());
            assignmentArray[i] = n < 0 ? new HardAssignment() : new HardAssignment(n);
        }
        bufferedReader.close();
    }
}

