/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Cluster;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class CentroidCluster<T extends DoubleVector>
implements Cluster<T> {
    private T centroid;
    private BitSet assignments;

    public CentroidCluster(T t) {
        this.centroid = t;
        this.assignments = new BitSet();
    }

    @Override
    public void addVector(T t, int n) {
        VectorMath.add(this.centroid, t);
        if (n >= 0) {
            this.assignments.set(n);
        }
    }

    @Override
    public double compareWithVector(T t) {
        return Similarity.cosineSimilarity(this.centroid, t);
    }

    @Override
    public T centroid() {
        return this.centroid;
    }

    @Override
    public List<T> dataPointValues() {
        return new ArrayList();
    }

    @Override
    public BitSet dataPointIds() {
        return this.assignments;
    }

    @Override
    public void merge(Cluster<T> cluster) {
        VectorMath.add(this.centroid, cluster.centroid());
        for (DoubleVector doubleVector : cluster.dataPointValues()) {
            VectorMath.add(this.centroid, doubleVector);
        }
        int n = cluster.dataPointIds().nextSetBit(0);
        while (n >= 0) {
            this.assignments.set(n);
            n = cluster.dataPointIds().nextSetBit(n + 1);
        }
    }

    @Override
    public int size() {
        return this.assignments.size();
    }
}

