/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.BaseSpectralCut;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.EigenCut;
import edu.ucla.sspace.clustering.SpectralClustering;
import edu.ucla.sspace.common.Statistics;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.util.Generator;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.util.Properties;

public class CKVWSpectralClustering06
implements Clustering {
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.CKVWSpectralClustering06";
    public static final String USE_KMEANS = "edu.ucla.sspace.clustering.CKVWSpectralClustering06.useKMeans";

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        SpectralClustering spectralClustering = new SpectralClustering(0.2, new SuperSpectralGenerator());
        return spectralClustering.cluster(matrix);
    }

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        SpectralClustering spectralClustering = new SpectralClustering(0.2, new SuperSpectralGenerator());
        return spectralClustering.cluster(matrix, n, properties.getProperty(USE_KMEANS) != null);
    }

    public String toString() {
        return "CKVWSpectralClustering06";
    }

    public class SuperSpectralGenerator
    implements Generator<EigenCut> {
        @Override
        public EigenCut generate() {
            return new SuperSpectralCut();
        }
    }

    public class SuperSpectralCut
    extends BaseSpectralCut {
        @Override
        protected DoubleVector computeSecondEigenVector(Matrix matrix, int n) {
            int n2;
            DenseVector denseVector = new DenseVector(n);
            DenseVector denseVector2 = new DenseVector(n);
            DenseVector denseVector3 = new DenseVector(n);
            for (int i = 0; i < n; ++i) {
                double d = this.rho.get(i) / this.pSum;
                denseVector.set(i, d);
                if (!(d > 0.0)) continue;
                denseVector2.set(i, Math.sqrt(d));
                denseVector3.set(i, d / denseVector2.get(i));
            }
            DoubleVector doubleVector = new DenseVector(n);
            for (n2 = 0; n2 < doubleVector.length(); ++n2) {
                doubleVector.set(n2, Math.random());
            }
            n2 = (int)Statistics.log2(n);
            for (int i = 0; i < n2; ++i) {
                doubleVector = SuperSpectralCut.orthonormalize(doubleVector, denseVector3);
                for (int j = 0; j < n; ++j) {
                    if (denseVector2.get(j) == 0.0) continue;
                    doubleVector.set(j, doubleVector.get(j) / denseVector2.get(j));
                }
                DoubleVector doubleVector2 = SuperSpectralCut.computeMatrixTransposeV(matrix, doubleVector);
                SuperSpectralCut.computeMatrixDotV(matrix, doubleVector2, doubleVector);
                for (int j = 0; j < n; ++j) {
                    double d = doubleVector.get(j);
                    double d2 = d * denseVector2.get(j) / this.rho.get(j);
                    doubleVector.set(j, d2);
                }
            }
            return doubleVector;
        }
    }
}

