/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.BaseSpectralCut;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.clustering.EigenCut;
import edu.ucla.sspace.clustering.SpectralClustering;
import edu.ucla.sspace.common.Statistics;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.RowScaledMatrix;
import edu.ucla.sspace.matrix.RowScaledSparseMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.util.Generator;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.util.Properties;

public class CKVWSpectralClustering03
implements Clustering {
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.clustering.CKVWSpectralClustering03";
    public static final String USE_KMEANS = "edu.ucla.sspace.clustering.CKVWSpectralClustering03.useKMeans";

    @Override
    public Assignments cluster(Matrix matrix, Properties properties) {
        SpectralClustering spectralClustering = new SpectralClustering(0.2, new SpectralCutGenerator());
        return spectralClustering.cluster(matrix);
    }

    @Override
    public Assignments cluster(Matrix matrix, int n, Properties properties) {
        SpectralClustering spectralClustering = new SpectralClustering(0.2, new SpectralCutGenerator());
        return spectralClustering.cluster(matrix, n, properties.getProperty(USE_KMEANS) != null);
    }

    public String toString() {
        return "CKVWSpectralClustering03";
    }

    public class SpectralCutGenerator
    implements Generator<EigenCut> {
        @Override
        public EigenCut generate() {
            return new SpectralCut();
        }
    }

    public class SpectralCut
    extends BaseSpectralCut {
        @Override
        protected DoubleVector computeSecondEigenVector(Matrix matrix, int n) {
            DenseVector denseVector = new DenseVector(n);
            DenseVector denseVector2 = new DenseVector(n);
            for (int i = 0; i < n; ++i) {
                denseVector.set(i, 1.0 / Math.sqrt(this.rho.get(i)));
                denseVector2.set(i, this.rho.get(i) * denseVector.get(i));
            }
            DoubleVector doubleVector = new DenseVector(n);
            for (int i = 0; i < doubleVector.length(); ++i) {
                doubleVector.set(i, Math.random());
            }
            RowScaledMatrix rowScaledMatrix = matrix instanceof SparseMatrix ? new RowScaledSparseMatrix((SparseMatrix)matrix, (DoubleVector)denseVector) : new RowScaledMatrix(matrix, denseVector);
            int n2 = (int)Statistics.log2(n);
            for (int i = 0; i < n2; ++i) {
                doubleVector = SpectralCut.orthonormalize(doubleVector, denseVector2);
                DoubleVector doubleVector2 = SpectralCut.computeMatrixTransposeV(rowScaledMatrix, doubleVector);
                SpectralCut.computeMatrixDotV(rowScaledMatrix, doubleVector2, doubleVector);
            }
            return doubleVector;
        }
    }
}

