/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.EigenCut;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.RowMaskedMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.SparseRowMaskedMatrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.ScaledDoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import edu.ucla.sspace.vector.Vectors;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class BaseSpectralCut
implements EigenCut {
    private static final Logger LOGGER = Logger.getLogger(BaseSpectralCut.class.getName());
    protected Matrix dataMatrix;
    protected int numRows;
    protected DoubleVector rho;
    protected DoubleVector matrixRowSums;
    protected double pSum;
    protected int[] leftReordering;
    protected int[] rightReordering;
    protected Matrix leftSplit;
    protected Matrix rightSplit;

    @Override
    public double rhoSum() {
        return this.pSum;
    }

    @Override
    public DoubleVector computeRhoSum(Matrix matrix) {
        LOGGER.info("Computing rho and rhoSum");
        int n = matrix.rows();
        this.matrixRowSums = BaseSpectralCut.computeMatrixRowSum(matrix);
        this.dataMatrix = matrix;
        this.rho = new DenseVector(n);
        this.pSum = 0.0;
        for (int i = 0; i < matrix.rows(); ++i) {
            double d = VectorMath.dotProduct(this.matrixRowSums, matrix.getRowVector(i));
            this.pSum += d;
            this.rho.set(i, d);
        }
        return this.matrixRowSums;
    }

    @Override
    public void computeCut(Matrix matrix) {
        this.dataMatrix = matrix;
        int n = matrix.rows();
        int n2 = matrix.rows();
        DoubleVector doubleVector = this.computeRhoSum(matrix);
        LOGGER.info("Computing the second eigen vector");
        DoubleVector doubleVector2 = this.computeSecondEigenVector(matrix, n2);
        Object[] objectArray = new Index[doubleVector2.length()];
        for (int i = 0; i < doubleVector2.length(); ++i) {
            objectArray[i] = new Index(doubleVector2.get(i), i);
        }
        Arrays.sort(objectArray);
        DenseVector denseVector = new DenseVector(matrix.rows());
        int[] nArray = new int[doubleVector2.length()];
        for (int i = 0; i < doubleVector2.length(); ++i) {
            nArray[i] = ((Index)objectArray[i]).index;
            denseVector.set(i, this.rho.get(((Index)objectArray[i]).index));
        }
        RowMaskedMatrix rowMaskedMatrix = matrix instanceof SparseMatrix ? new SparseRowMaskedMatrix((SparseMatrix)matrix, nArray) : new RowMaskedMatrix(matrix, nArray);
        LOGGER.info("Computing the spectral cut");
        int n3 = BaseSpectralCut.computeCut(rowMaskedMatrix, denseVector, this.pSum, doubleVector);
        this.leftReordering = Arrays.copyOfRange(nArray, 0, n3);
        this.rightReordering = Arrays.copyOfRange(nArray, n3, nArray.length);
        if (matrix instanceof SparseMatrix) {
            this.leftSplit = new SparseRowMaskedMatrix((SparseMatrix)matrix, this.leftReordering);
            this.rightSplit = new SparseRowMaskedMatrix((SparseMatrix)matrix, this.rightReordering);
        } else {
            this.leftSplit = new RowMaskedMatrix(matrix, this.leftReordering);
            this.rightSplit = new RowMaskedMatrix(matrix, this.rightReordering);
        }
    }

    protected abstract DoubleVector computeSecondEigenVector(Matrix var1, int var2);

    @Override
    public Matrix getLeftCut() {
        return this.leftSplit;
    }

    @Override
    public Matrix getRightCut() {
        return this.rightSplit;
    }

    @Override
    public int[] getLeftReordering() {
        return this.leftReordering;
    }

    @Override
    public int[] getRightReordering() {
        return this.rightReordering;
    }

    @Override
    public double getKMeansObjective() {
        ScaledDoubleVector scaledDoubleVector = new ScaledDoubleVector(this.matrixRowSums, 1.0 / (double)this.dataMatrix.rows());
        double d = 0.0;
        for (int i = 0; i < this.dataMatrix.rows(); ++i) {
            d += VectorMath.dotProduct(scaledDoubleVector, this.dataMatrix.getRowVector(i));
        }
        return d;
    }

    @Override
    public double getKMeansObjective(double d, double d2, int n, int[] nArray, int n2, int[] nArray2) {
        double d3 = 0.0;
        d3 += BaseSpectralCut.kMeansObjective(n, nArray, this.leftSplit);
        return d3 += BaseSpectralCut.kMeansObjective(n2, nArray2, this.rightSplit);
    }

    public static double kMeansObjective(int n, int[] nArray, Matrix matrix) {
        int n2;
        double d = 0.0;
        DoubleVector[] doubleVectorArray = new DoubleVector[n];
        double[] dArray = new double[n];
        for (n2 = 0; n2 < doubleVectorArray.length; ++n2) {
            doubleVectorArray[n2] = new DenseVector(matrix.columns());
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            VectorMath.add(doubleVectorArray[nArray[n2]], matrix.getRowVector(n2));
            int n3 = nArray[n2];
            dArray[n3] = dArray[n3] + 1.0;
        }
        for (n2 = 0; n2 < doubleVectorArray.length; ++n2) {
            if (dArray[n2] == 0.0) continue;
            doubleVectorArray[n2] = new ScaledDoubleVector(doubleVectorArray[n2], 1.0 / dArray[n2]);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            d += VectorMath.dotProduct(doubleVectorArray[nArray[n2]], matrix.getRowVector(n2));
        }
        return d;
    }

    @Override
    public double getSplitObjective(double d, double d2, int n, int[] nArray, int n2, int[] nArray2) {
        double d3 = 0.0;
        int[] nArray3 = new int[n];
        d3 += BaseSpectralCut.computeIntraClusterScore(nArray, this.leftSplit, nArray3);
        int[] nArray4 = new int[n2];
        double d4 = (this.pSum - (double)this.numRows) / 2.0 - (d3 += BaseSpectralCut.computeIntraClusterScore(nArray2, this.rightSplit, nArray4));
        int n3 = BaseSpectralCut.comparisonCount(nArray3) + BaseSpectralCut.comparisonCount(nArray4);
        d3 = (double)n3 - d3;
        return d * d3 + d2 * d4;
    }

    @Override
    public double getMergedObjective(double d, double d2) {
        double d3 = this.pSum - (double)this.numRows / 2.0;
        double d4 = (double)(this.numRows * (this.numRows - 1)) / 2.0;
        return d * (d4 - d3);
    }

    private static double computeIntraClusterScore(int[] nArray, Matrix matrix, int[] nArray2) {
        DoubleVector[] doubleVectorArray = new DoubleVector[nArray2.length];
        int[] nArray3 = new int[nArray2.length];
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            DoubleVector doubleVector = matrix.getRowVector(i);
            if (doubleVectorArray[n] == null) {
                doubleVectorArray[n] = Vectors.copyOf(doubleVector);
            } else {
                DoubleVector doubleVector2 = doubleVectorArray[n];
                d += (double)nArray3[n] - VectorMath.dotProduct(doubleVector, doubleVector2);
                VectorMath.add(doubleVector2, doubleVector);
                int n2 = n;
                nArray2[n2] = nArray2[n2] + nArray3[n];
            }
            int n3 = n;
            nArray3[n3] = nArray3[n3] + 1;
        }
        return d;
    }

    protected static int comparisonCount(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    protected static DoubleVector orthonormalize(DoubleVector doubleVector, DoubleVector doubleVector2) {
        double d = VectorMath.dotProduct(doubleVector, doubleVector2);
        d -= doubleVector.get(0) * doubleVector2.get(0);
        if (doubleVector2.get(0) != 0.0) {
            doubleVector.add(0, -(d /= doubleVector2.get(0)));
        }
        if (1.0 / (d = VectorMath.dotProduct(doubleVector, doubleVector)) == 0.0 || d == 0.0) {
            return doubleVector;
        }
        return new ScaledDoubleVector(doubleVector, 1.0 / d);
    }

    protected static int computeCut(Matrix matrix, DoubleVector doubleVector, double d, DoubleVector doubleVector2) {
        DenseVector denseVector = new DenseVector(matrix.columns());
        DoubleVector doubleVector3 = doubleVector2;
        VectorMath.subtract(doubleVector3, denseVector);
        VectorMath.add(denseVector, matrix.getRowVector(0));
        double d2 = doubleVector.get(0);
        double d3 = d - doubleVector.get(0);
        double d4 = VectorMath.dotProduct(denseVector, doubleVector3);
        double d5 = d4 / Math.min(d2, d3);
        int n = 0;
        for (int i = 1; i < doubleVector.length() - 2; ++i) {
            DoubleVector doubleVector4 = matrix.getRowVector(i);
            double d6 = VectorMath.dotProduct(denseVector, doubleVector4);
            double d7 = VectorMath.dotProduct(doubleVector3, doubleVector4);
            d4 = d4 - d6 + d7 + 1.0;
            VectorMath.add(denseVector, doubleVector4);
            VectorMath.subtract(doubleVector3, doubleVector4);
            double d8 = d4 / Math.min(d2 += doubleVector.get(i), d3 -= doubleVector.get(i));
            if (!(d8 <= d5)) continue;
            d5 = d8;
            n = i;
        }
        return n + 1;
    }

    protected static DoubleVector computeMatrixTransposeV(Matrix matrix, DoubleVector doubleVector) {
        DenseVector denseVector = new DenseVector(matrix.columns());
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            for (int i = 0; i < sparseMatrix.rows(); ++i) {
                int[] nArray;
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
                for (int n : nArray = sparseDoubleVector.getNonZeroIndices()) {
                    denseVector.add(n, sparseDoubleVector.get(n) * doubleVector.get(i));
                }
            }
        } else {
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = 0; j < matrix.columns(); ++j) {
                    denseVector.add(j, matrix.get(i, j) * doubleVector.get(i));
                }
            }
        }
        return denseVector;
    }

    protected static void computeMatrixDotV(Matrix matrix, DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            for (int i = 0; i < sparseMatrix.rows(); ++i) {
                int[] nArray;
                double d = 0.0;
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
                for (int n : nArray = sparseDoubleVector.getNonZeroIndices()) {
                    d += sparseDoubleVector.get(n) * doubleVector.get(n);
                }
                doubleVector2.set(i, d);
            }
        } else {
            for (int i = 0; i < matrix.rows(); ++i) {
                double d = 0.0;
                for (int j = 0; j < matrix.columns(); ++j) {
                    d += matrix.get(i, j) * doubleVector.get(j);
                }
                doubleVector2.set(i, d);
            }
        }
    }

    protected static <T extends Matrix> DoubleVector computeMatrixRowSum(T t) {
        DenseVector denseVector = new DenseVector(t.columns());
        for (int i = 0; i < t.rows(); ++i) {
            VectorMath.add(denseVector, t.getRowVector(i));
        }
        return denseVector;
    }

    protected static class Index
    implements Comparable {
        public final double weight;
        public final int index;

        public Index(double d, int n) {
            this.weight = d;
            this.index = n;
        }

        public int compareTo(Object object) {
            Index index = (Index)object;
            return (int)(this.weight - index.weight);
        }
    }
}

