/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.clustering;

import edu.ucla.sspace.clustering.Assignment;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.ScaledDoubleVector;
import edu.ucla.sspace.vector.ScaledSparseDoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Assignments
implements Iterable<Assignment> {
    private Assignment[] assignments;
    private int numClusters;
    private Matrix matrix;

    public Assignments(int n, int n2) {
        this(n, n2, null);
    }

    public Assignments(int n, int n2, Matrix matrix) {
        this.numClusters = n;
        this.matrix = matrix;
        this.assignments = new Assignment[n2];
    }

    public Assignments(int n, Assignment[] assignmentArray) {
        this(n, assignmentArray, null);
    }

    public Assignments(int n, Assignment[] assignmentArray, Matrix matrix) {
        this.numClusters = n;
        this.matrix = matrix;
        this.assignments = assignmentArray;
    }

    public void set(int n, Assignment assignment) {
        this.assignments[n] = assignment;
    }

    public int size() {
        return this.assignments.length;
    }

    @Override
    public Iterator<Assignment> iterator() {
        return Arrays.asList(this.assignments).iterator();
    }

    public Assignment get(int n) {
        return this.assignments[n];
    }

    public int numClusters() {
        return this.numClusters;
    }

    public Assignment[] assignments() {
        return this.assignments;
    }

    public List<Set<Integer>> clusters() {
        int n;
        ArrayList<Set<Integer>> arrayList = new ArrayList<Set<Integer>>();
        for (n = 0; n < this.numClusters; ++n) {
            arrayList.add(new HashSet());
        }
        for (n = 0; n < this.assignments.length; ++n) {
            for (int n2 : this.assignments[n].assignments()) {
                ((Set)arrayList.get(n2)).add(n);
            }
        }
        return arrayList;
    }

    public DoubleVector[] getCentroids() {
        int n;
        if (this.matrix == null) {
            throw new IllegalArgumentException("The data matrix was not passed to Assignments.");
        }
        DoubleVector[] doubleVectorArray = new DoubleVector[this.numClusters];
        int[] nArray = new int[this.numClusters];
        for (n = 0; n < this.numClusters; ++n) {
            doubleVectorArray[n] = new DenseVector(this.matrix.columns());
        }
        n = 0;
        for (Assignment assignment : this.assignments) {
            if (assignment.length() != 0) {
                int n2 = assignment.assignments()[0];
                nArray[n2] = nArray[n2] + 1;
                DoubleVector doubleVector = doubleVectorArray[assignment.assignments()[0]];
                VectorMath.add(doubleVector, this.matrix.getRowVector(n));
            }
            ++n;
        }
        for (int i = 0; i < this.numClusters; ++i) {
            if (nArray[i] == 0) continue;
            doubleVectorArray[i] = new ScaledDoubleVector(doubleVectorArray[i], 1.0 / (double)nArray[i]);
        }
        return doubleVectorArray;
    }

    public SparseDoubleVector[] getSparseCentroids() {
        int n;
        if (this.matrix == null) {
            throw new IllegalArgumentException("The data matrix was not passed to Assignments.");
        }
        SparseMatrix sparseMatrix = (SparseMatrix)this.matrix;
        SparseDoubleVector[] sparseDoubleVectorArray = new SparseDoubleVector[this.numClusters];
        int[] nArray = new int[this.numClusters];
        for (n = 0; n < this.numClusters; ++n) {
            sparseDoubleVectorArray[n] = new CompactSparseVector(this.matrix.columns());
        }
        n = 0;
        for (Assignment assignment : this.assignments) {
            if (assignment.length() != 0 && assignment.assignments()[0] != -1) {
                int n2 = assignment.assignments()[0];
                nArray[n2] = nArray[n2] + 1;
                SparseDoubleVector sparseDoubleVector = sparseDoubleVectorArray[assignment.assignments()[0]];
                VectorMath.add(sparseDoubleVector, sparseMatrix.getRowVector(n));
            }
            ++n;
        }
        for (int i = 0; i < this.numClusters; ++i) {
            if (nArray[i] == 0) continue;
            sparseDoubleVectorArray[i] = new ScaledSparseDoubleVector(sparseDoubleVectorArray[i], 1.0 / (double)nArray[i]);
        }
        return sparseDoubleVectorArray;
    }
}

