/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.beagle;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.fft.FastFourierTransform;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class Beagle
implements SemanticSpace {
    public static final int CONTEXT_SIZE = 6;
    public static final String BEAGLE_SSPACE_NAME = "beagle-semantic-space";
    private static final Logger LOGGER = Logger.getLogger(Beagle.class.getName());
    private final Map<String, DoubleVector> vectorMap;
    private final ConcurrentMap<String, DoubleVector> termHolographs;
    private final int indexVectorSize;
    private int prevSize;
    private int nextSize;
    private DoubleVector placeHolder;
    private int[] permute1;
    private int[] permute2;
    private final SemanticType semanticType;

    public Beagle(int n, Map<String, DoubleVector> map) {
        this(n, SemanticType.COMPOSITE, map);
    }

    public Beagle(int n, SemanticType semanticType, Map<String, DoubleVector> map) {
        this.indexVectorSize = n;
        this.vectorMap = map;
        this.termHolographs = new ConcurrentHashMap<String, DoubleVector>();
        this.semanticType = semanticType;
        this.placeHolder = map.get("");
        this.permute1 = new int[this.indexVectorSize];
        this.permute2 = new int[this.indexVectorSize];
        this.randomPermute(this.permute1);
        this.randomPermute(this.permute2);
        this.prevSize = 1;
        this.nextSize = 5;
    }

    @Override
    public Set<String> getWords() {
        return this.termHolographs.keySet();
    }

    @Override
    public DoubleVector getVector(String string) {
        return Vectors.immutable((DoubleVector)this.termHolographs.get(string));
    }

    @Override
    public String getSpaceName() {
        return "beagle-semantic-space-" + this.indexVectorSize + "-" + this.semanticType.toString();
    }

    @Override
    public int getVectorLength() {
        return this.indexVectorSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < this.nextSize && iterator.hasNext(); ++i) {
            arrayDeque2.offer(iterator.next().intern());
        }
        arrayDeque.offer("");
        String string = null;
        while (!arrayDeque2.isEmpty()) {
            string = (String)arrayDeque2.remove();
            if (iterator.hasNext()) {
                arrayDeque2.offer(iterator.next().intern());
            }
            if (!string.equals("")) {
                Object object = (DoubleVector)this.termHolographs.get(string);
                if (object == null) {
                    object = new DenseVector(this.indexVectorSize);
                    hashMap.put(string, object);
                }
                this.updateMeaning((DoubleVector)object, arrayDeque, arrayDeque2);
            }
            arrayDeque.offer(string);
            if (arrayDeque.size() <= 1) continue;
            arrayDeque.remove();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            synchronized (string2) {
                DoubleVector doubleVector = (DoubleVector)this.termHolographs.get(entry.getKey());
                if (doubleVector == null) {
                    this.termHolographs.put((String)entry.getKey(), (DoubleVector)entry.getValue());
                } else {
                    VectorMath.add(doubleVector, (DoubleVector)entry.getValue());
                }
            }
        }
    }

    @Override
    public void processSpace(Properties properties) {
    }

    private void updateMeaning(DoubleVector doubleVector, Queue<String> queue, Queue<String> queue2) {
        DoubleVector doubleVector2;
        if (this.semanticType == SemanticType.COMPOSITE || this.semanticType == SemanticType.CONTEXT) {
            doubleVector2 = new DenseVector(this.indexVectorSize);
            for (String string : queue) {
                if (string.equals("")) continue;
                VectorMath.add(doubleVector2, this.vectorMap.get(string));
            }
            for (String string : queue2) {
                if (string.equals("")) continue;
                VectorMath.add(doubleVector2, this.vectorMap.get(string));
            }
            this.normalize(doubleVector2);
            VectorMath.add(doubleVector, doubleVector2);
        }
        if (this.semanticType == SemanticType.COMPOSITE || this.semanticType == SemanticType.ORDERING) {
            doubleVector2 = this.groupConvolution(queue, queue2);
            this.normalize(doubleVector2);
            VectorMath.add(doubleVector, doubleVector2);
        }
    }

    private void normalize(DoubleVector doubleVector) {
        int n;
        double d = 0.0;
        for (n = 0; n < doubleVector.length(); ++n) {
            d += Math.pow(doubleVector.get(n), 2.0);
        }
        if (d == 0.0) {
            return;
        }
        d = Math.sqrt(d);
        for (n = 0; n < doubleVector.length(); ++n) {
            doubleVector.set(n, doubleVector.get(n) / d);
        }
    }

    private DoubleVector groupConvolution(Queue<String> queue, Queue<String> queue2) {
        DoubleVector doubleVector;
        DenseVector denseVector = new DenseVector(this.indexVectorSize);
        String string = queue.peek();
        if (!string.equals("")) {
            doubleVector = this.convolute(this.vectorMap.get(queue.peek()), this.placeHolder);
            VectorMath.add(denseVector, doubleVector);
        } else {
            doubleVector = this.placeHolder;
        }
        for (String string2 : queue2) {
            if (string2.equals("")) continue;
            doubleVector = this.convolute(doubleVector, this.vectorMap.get(string2));
            VectorMath.add(denseVector, doubleVector);
        }
        doubleVector = this.placeHolder;
        for (String string2 : queue2) {
            if (string2.equals("")) continue;
            doubleVector = this.convolute(doubleVector, this.vectorMap.get(string2));
            VectorMath.add(denseVector, doubleVector);
        }
        return denseVector;
    }

    private void randomPermute(int[] nArray) {
        int n;
        for (n = 0; n < this.indexVectorSize; ++n) {
            nArray[n] = n;
        }
        for (n = this.indexVectorSize - 1; n > 0; --n) {
            int n2 = (int)Math.floor(Math.random() * (double)(n + 1));
            int n3 = nArray[n2];
            nArray[n2] = nArray[n];
            nArray[n] = nArray[n2];
        }
    }

    private DoubleVector convolute(DoubleVector doubleVector, DoubleVector doubleVector2) {
        doubleVector = this.changeVector(doubleVector, this.permute1);
        doubleVector2 = this.changeVector(doubleVector2, this.permute2);
        FastFourierTransform.transform(doubleVector);
        FastFourierTransform.transform(doubleVector2);
        DoubleVector doubleVector3 = VectorMath.multiply(doubleVector, doubleVector2);
        FastFourierTransform.backtransform(doubleVector3);
        return doubleVector3;
    }

    private DoubleVector changeVector(DoubleVector doubleVector, int[] nArray) {
        DenseVector denseVector = new DenseVector(this.indexVectorSize);
        for (int i = 0; i < this.indexVectorSize; ++i) {
            denseVector.set(i, doubleVector.get(nArray[i]));
        }
        return denseVector;
    }

    public static enum SemanticType {
        CONTEXT,
        ORDERING,
        COMPOSITE;

    }
}

