/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.basis;

import edu.ucla.sspace.basis.BasisMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBasisMapping<T, K>
implements BasisMapping<T, K>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K, Integer> mapping = new HashMap<K, Integer>();
    private transient List<K> indexToKeyCache = new ArrayList<K>();
    private boolean readOnly = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K getDimensionDescription(int n) {
        if (n < 0 || n > this.mapping.size()) {
            throw new IllegalArgumentException("invalid dimension: " + n);
        }
        if (this.mapping.size() > this.indexToKeyCache.size()) {
            AbstractBasisMapping abstractBasisMapping = this;
            synchronized (abstractBasisMapping) {
                this.indexToKeyCache = new ArrayList<K>(this.mapping.size());
                for (int i = 0; i < this.mapping.size(); ++i) {
                    this.indexToKeyCache.add(null);
                }
                for (Map.Entry<K, Integer> entry : this.mapping.entrySet()) {
                    this.indexToKeyCache.set(entry.getValue(), entry.getKey());
                }
            }
        }
        return this.indexToKeyCache.get(n);
    }

    @Override
    public Set<K> keySet() {
        return this.mapping.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getDimensionInternal(K k) {
        Integer n = this.mapping.get(k);
        if (this.readOnly) {
            return n == null ? -1 : n;
        }
        if (n == null) {
            AbstractBasisMapping abstractBasisMapping = this;
            synchronized (abstractBasisMapping) {
                n = this.mapping.get(k);
                if (n == null) {
                    int n2 = this.mapping.size();
                    this.mapping.put(k, n2);
                    return n2;
                }
            }
        }
        return n;
    }

    protected Map<K, Integer> getMapping() {
        return this.mapping;
    }

    @Override
    public int numDimensions() {
        return this.mapping.size();
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

