/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.edu.mit.tedlab;

import ch.akuhn.edu.mit.tedlab.DMat;
import ch.akuhn.edu.mit.tedlab.SMat;
import ch.akuhn.edu.mit.tedlab.SVDRec;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Random;
import java.util.Scanner;

public class Svdlib {
    String SVDVersion = "1.34";
    long SVDVerbosity = 0L;
    static int MAXLL = 2;
    static String[] error_msg = new String[]{null, "", "ENDL MUST BE LESS THAN ENDR", "REQUESTED DIMENSIONS CANNOT EXCEED NUM ITERATIONS", "ONE OF YOUR DIMENSIONS IS LESS THAN OR EQUAL TO ZERO", "NUM ITERATIONS (NUMBER OF LANCZOS STEPS) IS INVALID", "REQUESTED DIMENSIONS (NUMBER OF EIGENPAIRS DESIRED) IS INVALID", "6*N+4*ITERATIONS+1 + ITERATIONS*ITERATIONS CANNOT EXCEED NW", "6*N+4*ITERATIONS+1 CANNOT EXCEED NW", null};
    double[][] LanStore;
    double[] OPBTemp;
    double eps;
    double eps1;
    double reps;
    double eps34;
    long ierr;

    static long[] svd_longArray(int n, boolean bl, String string) {
        return new long[n];
    }

    static double[] svd_doubleArray(int n, boolean bl, String string) {
        return new double[n];
    }

    static void svd_beep() {
        System.err.print('\n');
    }

    static void svd_debug(String string, Object ... objectArray) {
        System.err.printf(string, objectArray);
    }

    static void svd_error(String string, Object ... objectArray) {
        Svdlib.svd_beep();
        System.err.print("ERROR: ");
        System.err.printf(string, objectArray);
        System.err.println();
    }

    static void svd_fatalError(String string, Object ... objectArray) {
        Svdlib.svd_error(string, objectArray);
        System.exit(1);
    }

    static double svd_fsign(double d, double d2) {
        if (d >= 0.0 && d2 >= 0.0 || d < 0.0 && d2 < 0.0) {
            return d;
        }
        return -d;
    }

    static double svd_dmax(double d, double d2) {
        return Math.max(d, d2);
    }

    static double svd_dmin(double d, double d2) {
        return Math.min(d, d2);
    }

    static int svd_imax(int n, int n2) {
        return Math.max(n, n2);
    }

    static int svd_imin(int n, int n2) {
        return Math.min(n, n2);
    }

    static void svd_dscal(int n, double d, double[] dArray, int n2) {
        if (n <= 0 || n2 == 0) {
            return;
        }
        int n3 = n2 < 0 ? n - 1 : 0;
        for (int i = 0; i < n; ++i) {
            int n4 = n3;
            dArray[n4] = dArray[n4] * d;
            n3 += n2;
        }
    }

    static void svd_datx(int n, double d, double[] dArray, int n2, double[] dArray2, int n3) {
        assert (n2 == 1 || n2 == -1 || n2 == 0);
        assert (n3 == 1 || n3 == -1 || n3 == 0);
        if (n <= 0 || n2 == 0 || n3 == 0) {
            return;
        }
        int n4 = n2 == 1 ? 0 : n - 1;
        int n5 = n3 == 1 ? 0 : n - 1;
        for (int i = 0; i < n; ++i) {
            dArray2[n5] = d * dArray[n4];
            n5 += n3;
            n4 += n2;
        }
    }

    static void svd_dcopy(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        Svdlib.svd_dcopy(n, dArray, 0, n2, dArray2, 0, n3);
    }

    static void svd_dcopy(int n, double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5) {
        assert (n3 == 1 || n3 == -1 || n3 == 0);
        assert (n5 == 1 || n5 == -1 || n5 == 0);
        if (n <= 0 || n3 == 0 || n5 == 0) {
            return;
        }
        int n6 = n3 == 1 ? n2 : n - 1 + n2;
        int n7 = n5 == 1 ? n4 : n - 1 + n4;
        for (int i = 0; i < n; ++i) {
            dArray2[n7] = dArray[n6];
            n7 += n5;
            n6 += n3;
        }
    }

    static double svd_ddot(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        double d = 0.0;
        int n4 = 0;
        int n5 = 0;
        assert (n2 == 1 || n2 == -1 || n2 == 0);
        assert (n3 == 1 || n3 == -1 || n3 == 0);
        if (n <= 0 || n2 == 0 || n3 == 0) {
            return 0.0;
        }
        int n6 = n2 == 1 ? n4 : n - 1 + n4;
        int n7 = n3 == 1 ? n5 : n - 1 + n5;
        for (int i = 0; i < n; ++i) {
            d += dArray2[n7] * dArray[n6];
            n7 += n3;
            n6 += n2;
        }
        return d;
    }

    static void svd_daxpy(int n, double d, double[] dArray, int n2, double[] dArray2, int n3) {
        if (n <= 0 || n2 == 0 || n3 == 0) {
            return;
        }
        int n4 = n2 == 1 ? 0 : n - 1;
        int n5 = n3 == 1 ? 0 : n - 1;
        for (int i = 0; i < n; ++i) {
            int n6 = n5;
            dArray2[n6] = dArray2[n6] + d * dArray[n4];
            n5 += n3;
            n4 += n2;
        }
    }

    static void svd_dsort2(int n, int n2, double[] dArray, double[] dArray2) {
        if (0 == n) {
            return;
        }
        for (int i = n; i < n2; ++i) {
            int n3 = i - n;
            int n4 = i;
            while (n3 >= 0 && dArray[n3] > dArray[n4]) {
                double d = dArray[n3];
                dArray[n3] = dArray[n4];
                dArray[n4] = d;
                d = dArray2[n3];
                dArray2[n3] = dArray2[n4];
                dArray2[n4] = d;
                n4 = (n3 -= n) + n;
            }
        }
        Svdlib.svd_dsort2(n / 2, n2, dArray, dArray2);
    }

    static void svd_dswap(int n, double[] dArray, int n2, double[] dArray2, int n3) {
        if (n <= 0 || n2 == 0 || n3 == 0) {
            return;
        }
        int n4 = n2 == 1 ? 0 : n - 1;
        int n5 = n3 == 1 ? 0 : n - 1;
        for (int i = 0; i < n; ++i) {
            double d = dArray2[n5];
            dArray2[n5] = dArray[n4];
            dArray[n4] = d;
            n5 += n3;
            n4 += n2;
        }
    }

    static int svd_idamax(int n, double[] dArray, int n2, int n3) {
        int n4;
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        if (n3 == 0) {
            return -1;
        }
        int n5 = n4 = n3 < 0 ? n2 + (-n + 1) * n3 : n2;
        double d = Svdlib.fabs(dArray[n4]);
        for (int i = 1; i < n; ++i) {
            double d2 = Svdlib.fabs(dArray[n4 += n3]);
            if (!(d2 > d)) continue;
            d = d2;
            n5 = n4;
        }
        return n5;
    }

    static void svd_opb(SMat sMat, double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2;
        int n3;
        int[] nArray = sMat.pointr;
        int[] nArray2 = sMat.rowind;
        double[] dArray4 = sMat.value;
        int n4 = sMat.cols;
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3] = 0.0;
        }
        for (n3 = 0; n3 < sMat.rows; ++n3) {
            dArray3[n3] = 0.0;
        }
        for (n3 = 0; n3 < sMat.cols; ++n3) {
            n2 = nArray[n3 + 1];
            for (n = nArray[n3]; n < n2; ++n) {
                int n5 = nArray2[n];
                dArray3[n5] = dArray3[n5] + dArray4[n] * dArray[n3];
            }
        }
        for (n3 = 0; n3 < sMat.cols; ++n3) {
            n2 = nArray[n3 + 1];
            for (n = nArray[n3]; n < n2; ++n) {
                int n6 = n3;
                dArray2[n6] = dArray2[n6] + dArray4[n] * dArray3[nArray2[n]];
            }
        }
    }

    static void svd_opa(SMat sMat, double[] dArray, double[] dArray2) {
        int n;
        int[] nArray = sMat.pointr;
        int[] nArray2 = sMat.rowind;
        double[] dArray3 = sMat.value;
        for (n = 0; n < sMat.rows; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < sMat.cols; ++n) {
            int n2 = nArray[n + 1];
            for (int i = nArray[n]; i < n2; ++i) {
                int n3 = nArray2[i];
                dArray2[n3] = dArray2[n3] + dArray3[i] * dArray[n];
            }
        }
    }

    static double svd_random2(long[] lArray) {
        throw null;
    }

    static double svd_pythag(double d, double d2) {
        double d3 = Svdlib.svd_dmax(Math.abs(d), Math.abs(d2));
        if (d3 != 0.0) {
            double d4 = Svdlib.svd_dmin(Math.abs(d), Math.abs(d2)) / d3;
            double d5 = d4 * d4;
            double d6 = 4.0 + d5;
            while (d6 != 4.0) {
                double d7 = d5 / d6;
                double d8 = 1.0 + 2.0 * d7;
                d3 *= d8;
                d4 = d7 / d8;
                d6 = 4.0 + (d5 *= d4 * d4);
            }
        }
        return d3;
    }

    static void svdResetCounters() {
        throw null;
    }

    static DMat svdConvertStoD(SMat sMat) {
        throw null;
    }

    static SMat svdConvertDtoS(DMat dMat) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < dMat.rows; ++n2) {
            for (n = 0; n < dMat.cols; ++n) {
                if (dMat.value[n2][n] == 0.0) continue;
                ++n3;
            }
        }
        SMat sMat = new SMat(dMat.rows, dMat.cols, n3);
        n3 = 0;
        for (n = 0; n < dMat.cols; ++n) {
            sMat.pointr[n] = n3;
            for (n2 = 0; n2 < dMat.rows; ++n2) {
                if (dMat.value[n2][n] == 0.0) continue;
                sMat.rowind[n3] = n2;
                sMat.value[n3] = dMat.value[n2][n];
                ++n3;
            }
        }
        sMat.pointr[sMat.cols] = sMat.vals;
        return sMat;
    }

    static DMat svdTransposeD(DMat dMat) {
        DMat dMat2 = new DMat(dMat.cols, dMat.rows);
        for (int i = 0; i < dMat.rows; ++i) {
            for (int j = 0; j < dMat.cols; ++j) {
                dMat2.value[j][i] = dMat.value[i][j];
            }
        }
        return dMat2;
    }

    static SMat svdTransposeS(SMat sMat) {
        int n;
        int n2;
        SMat sMat2 = new SMat(sMat.cols, sMat.rows, sMat.vals);
        for (n2 = 0; n2 < sMat.vals; ++n2) {
            int n3 = sMat.rowind[n2];
            sMat2.pointr[n3] = sMat2.pointr[n3] + 1;
        }
        sMat2.pointr[sMat.rows] = sMat.vals - sMat2.pointr[sMat.rows - 1];
        for (n = sMat.rows - 1; n > 0; --n) {
            sMat2.pointr[n] = sMat2.pointr[n + 1] - sMat2.pointr[n - 1];
        }
        sMat2.pointr[0] = 0;
        n2 = 0;
        for (int i = 0; i < sMat.cols; ++i) {
            while (n2 < sMat.pointr[i + 1]) {
                n = sMat.rowind[n2];
                int n4 = n + 1;
                sMat2.pointr[n4] = sMat2.pointr[n4] + 1;
                sMat2.rowind[var4_5] = i;
                sMat2.value[var4_5] = sMat.value[n2];
                ++n2;
            }
        }
        return sMat2;
    }

    static int check_parameters(SMat sMat, long l, long l2, double d, double d2, boolean bl) {
        int n = 0;
        if (d > d2) {
            n = 2;
        } else if (l > l2) {
            n = 3;
        } else if (sMat.cols <= 0 || sMat.rows <= 0) {
            n = 4;
        } else if (l2 <= 0L || l2 > (long)sMat.cols || l2 > (long)sMat.rows) {
            n = 5;
        } else if (l <= 0L || l > l2) {
            n = 6;
        }
        if (0 != n) {
            Svdlib.svd_error("svdLAS2 parameter error: %s\n", error_msg[n]);
        }
        return n;
    }

    void write_header(long l, long l2, double d, double d2, boolean bl, double d3, long l3, long l4, long l5) {
        Svdlib.printf("SOLVING THE [A^TA] EIGENPROBLEM\n", new Object[0]);
        Svdlib.printf("NO. OF ROWS               = %6d\n", l3);
        Svdlib.printf("NO. OF COLUMNS            = %6d\n", l4);
        Svdlib.printf("NO. OF NON-ZERO VALUES    = %6d\n", l5);
        Svdlib.printf("MATRIX DENSITY            = %6.2f%%\n", Float.valueOf((float)l5 / (float)l3 * 100.0f / (float)l4));
        Svdlib.printf("MAX. NO. OF LANCZOS STEPS = %6d\n", l);
        Svdlib.printf("MAX. NO. OF EIGENPAIRS    = %6d\n", l2);
        Svdlib.printf("LEFT  END OF THE INTERVAL = %9.2E\n", d);
        Svdlib.printf("RIGHT END OF THE INTERVAL = %9.2E\n", d2);
        Svdlib.printf("KAPPA                     = %9.2E\n", d3);
        Svdlib.printf("\n", new Object[0]);
    }

    static void printf(String string, Object ... objectArray) {
        System.out.printf(string, objectArray);
    }

    static void fake_memset_127(double[] dArray) {
        double d = Double.longBitsToDouble(0x7F7F7F7F7F7F7F7FL);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
    }

    public SVDRec svdLAS2A(SMat sMat, int n) {
        double[] dArray = new double[]{-1.0E-30, 1.0E-30};
        double d = 1.0E-6;
        if (sMat == null) {
            Svdlib.svd_error("svdLAS2A called with NULL array\n", new Object[0]);
            return null;
        }
        return this.svdLAS2(sMat, n, 0, dArray, d);
    }

    public SVDRec svdLAS2(SMat sMat, int n, int n2, double[] dArray, double d) {
        boolean bl = false;
        double[][] dArrayArray = new double[10][];
        SVDRec sVDRec = null;
        int n3 = Svdlib.svd_imin(sMat.rows, sMat.cols);
        if (n <= 0 || n > n3) {
            n = n3;
        }
        if (n2 <= 0 || n2 > n3) {
            n2 = n3;
        }
        if (n2 < n) {
            n2 = n;
        }
        if (this.SVDVerbosity > 0L) {
            this.write_header(n2, n, dArray[0], dArray[1], true, d, sMat.rows, sMat.cols, sMat.vals);
        }
        if (0 != Svdlib.check_parameters(sMat, n, n2, dArray[0], dArray[1], true)) {
            if (sMat.rows == 0 || sMat.cols == 0) {
                sVDRec = new SVDRec();
                sVDRec.S = new double[0];
                sVDRec.Ut = new DMat(0, sMat.rows);
                sVDRec.Vt = new DMat(0, sMat.cols);
                return sVDRec;
            }
            return null;
        }
        if ((double)sMat.cols >= (double)sMat.rows * 1.2) {
            if (this.SVDVerbosity > 0L) {
                Svdlib.printf("TRANSPOSING THE MATRIX FOR SPEED\n", new Object[0]);
            }
            bl = true;
            sMat = Svdlib.svdTransposeS(sMat);
        }
        int n4 = sMat.cols;
        this.machar();
        this.eps1 = this.eps * Math.sqrt(n4);
        this.reps = Math.sqrt(this.eps);
        this.eps34 = this.reps * Math.sqrt(this.reps);
        dArrayArray[0] = new double[n4];
        dArrayArray[1] = new double[n4];
        dArrayArray[2] = new double[n4];
        dArrayArray[3] = new double[n4];
        dArrayArray[4] = new double[n4];
        dArrayArray[5] = new double[n4];
        dArrayArray[6] = new double[n2];
        dArrayArray[7] = new double[n2];
        dArrayArray[8] = new double[n2];
        dArrayArray[9] = new double[n2 + 1];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        Svdlib.fake_memset_127(dArray3);
        this.LanStore = new double[n2 + MAXLL][];
        this.OPBTemp = Svdlib.svd_doubleArray(sMat.rows, false, "las2: OPBTemp");
        int[] nArray = new int[]{0};
        int n5 = this.lanso(sMat, n2, n, dArray[0], dArray[1], dArray2, dArray3, dArrayArray, nArray, n4);
        int n6 = nArray[0];
        if (this.SVDVerbosity > 0L) {
            Svdlib.printf("NUMBER OF LANCZOS STEPS   = %6d\nRITZ VALUES STABILIZED    = %6d\n", n5 + 1, n6);
        }
        if (this.SVDVerbosity > 2L) {
            Svdlib.printf("\nCOMPUTED RITZ VALUES  (ERROR BNDS)\n", new Object[0]);
            for (int i = 0; i <= n5; ++i) {
                Svdlib.printf("%3d  %22.14E  (%11.2E)\n", i + 1, dArray2[i], dArray3[i]);
            }
        }
        dArrayArray[0] = null;
        dArrayArray[1] = null;
        dArrayArray[2] = null;
        dArrayArray[3] = null;
        dArrayArray[4] = null;
        dArrayArray[7] = null;
        dArrayArray[8] = null;
        d = Svdlib.svd_dmax(Svdlib.fabs(d), this.eps34);
        sVDRec = new SVDRec();
        sVDRec.d = n;
        sVDRec.Ut = new DMat(sVDRec.d, sMat.rows);
        sVDRec.S = Svdlib.svd_doubleArray(sVDRec.d, true, "las2: R->s");
        sVDRec.Vt = new DMat(sVDRec.d, sMat.cols);
        this.ritvec(n4, sMat, sVDRec, d, dArray2, dArray3, dArrayArray[6], dArrayArray[9], dArrayArray[5], n5, n6);
        if (this.SVDVerbosity > 1L) {
            Svdlib.printf("\nSINGULAR VALUES: ", new Object[0]);
            Svdlib.svdWriteDenseArray(sVDRec.S, sVDRec.d, "-", false);
            if (this.SVDVerbosity > 2L) {
                Svdlib.printf("\nLEFT SINGULAR VECTORS (transpose of U): ", new Object[0]);
                Svdlib.printf("\nRIGHT SINGULAR VECTORS (transpose of V): ", new Object[0]);
            }
        } else if (this.SVDVerbosity > 0L) {
            Svdlib.printf("SINGULAR VALUES FOUND     = %6d\n", sVDRec.d);
        }
        if (bl) {
            DMat dMat = sVDRec.Ut;
            sVDRec.Ut = sVDRec.Vt;
            sVDRec.Vt = dMat;
        }
        return sVDRec;
    }

    static void svdWriteDenseArray(double[] dArray, int n, String string, boolean bl) {
        System.out.println("Declare victory!");
    }

    static void rotateArray(double[][] dArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        double d = dArray[0][0];
        int n5 = dArray.length;
        for (int i = 0; i < n; ++i) {
            int n6 = n4 >= n2 ? n4 - n2 : n4 + n - n2;
            double d2 = dArray[n6 % n5][n6 / n5];
            dArray[n6 % n5][n6 / n5] = d;
            d = d2;
            n4 = n6;
            if (n4 != n3) continue;
            n3 = ++n4;
            d = dArray[n4 % n5][n4 / n5];
        }
    }

    long ritvec(int n, SMat sMat, SVDRec sVDRec, double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n2, long l) {
        int n3;
        double[] dArray6 = sVDRec.Vt.value[0];
        int n4 = n2 + 1;
        int n5 = n4 * n4;
        double[] dArray7 = Svdlib.svd_doubleArray(n5, true, "ritvec: s");
        double[] dArray8 = Svdlib.svd_doubleArray(n, false, "ritvec: xv2");
        for (n3 = 0; n3 < n5; n3 += n4 + 1) {
            dArray7[n3] = 1.0;
        }
        Svdlib.svd_dcopy(n4, dArray3, 1, dArray6, -1);
        Svdlib.svd_dcopy(n2, dArray4, 1, 1, dArray5, 1, -1);
        this.imtql2(n4, n4, dArray6, dArray5, dArray7);
        if (0L != this.ierr) {
            return 0L;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = n5 - n4;
        for (int i = 0; i < n4; ++i) {
            int n9 = n8;
            if (dArray2[i] <= d * Math.abs(dArray[i]) && (long)i > (long)n4 - l - 1L) {
                if (--n7 < 0) {
                    n7 = sVDRec.d - 1;
                }
                dArray6 = sVDRec.Vt.value[n7];
                for (n3 = 0; n3 < n; ++n3) {
                    dArray6[n3] = 0.0;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    this.store(n, storeVals.RETRQ, n3, dArray5);
                    Svdlib.svd_daxpy(n, dArray7[n9], dArray5, 1, dArray6, 1);
                    n9 -= n4;
                }
                ++n6;
            }
            ++n8;
        }
        dArray7 = null;
        Svdlib.rotateArray(sVDRec.Vt.value, sVDRec.Vt.rows * sVDRec.Vt.cols, n7 * sVDRec.Vt.cols);
        sVDRec.d = Svdlib.svd_imin(sVDRec.d, n6);
        for (n7 = 0; n7 < sVDRec.d; ++n7) {
            Svdlib.svd_opb(sMat, sVDRec.Vt.value[n7], dArray8, this.OPBTemp);
            double d2 = Svdlib.svd_ddot(n, sVDRec.Vt.value[n7], 1, dArray8, 1);
            Svdlib.svd_daxpy(n, -d2, sVDRec.Vt.value[n7], 1, dArray8, 1);
            d2 = Math.sqrt(d2);
            double d3 = Math.sqrt(Svdlib.svd_ddot(n, dArray8, 1, dArray8, 1));
            Svdlib.svd_opa(sMat, sVDRec.Vt.value[n7], sVDRec.Ut.value[n7]);
            double d4 = 1.0 / d2;
            Svdlib.svd_dscal(sMat.rows, d4, sVDRec.Ut.value[n7], 1);
            dArray2[n3] = d3 *= d4;
            sVDRec.S[n7] = d2;
        }
        dArray8 = null;
        return n6;
    }

    int lanso(SMat sMat, int n, int n2, double d, double d2, double[] dArray, double[] dArray2, double[][] dArray3, int[] nArray, int n3) {
        int n4 = 0;
        int n5 = 0;
        double[] dArray4 = dArray3[6];
        double[] dArray5 = dArray3[7];
        double[] dArray6 = dArray3[8];
        double[] dArray7 = dArray3[9];
        double[] dArray8 = dArray3[5];
        double[] dArray9 = new double[]{0.0};
        double[] dArray10 = new double[]{0.0};
        this.stpone(sMat, dArray3, dArray9, dArray10, n3);
        double d3 = dArray10[0];
        double d4 = dArray9[0];
        if (0.0 == d4 || 0L != this.ierr) {
            return 0;
        }
        dArray5[0] = this.eps1;
        dArray6[0] = this.eps1;
        int n6 = 0;
        int n7 = 1;
        int n8 = Svdlib.svd_imin(n2 + Svdlib.svd_imax(8, n2), n);
        boolean bl = false;
        while (!bl) {
            if (d4 <= d3) {
                d4 = 0.0;
            }
            int[] nArray2 = new int[]{n6};
            boolean[] blArray = new boolean[]{bl};
            double[] dArray11 = new double[]{d4};
            double[] dArray12 = new double[]{d3};
            n4 = this.lanczos_step(sMat, n7, n8, dArray3, dArray4, dArray5, dArray6, dArray7, nArray2, blArray, dArray11, dArray12, n3);
            n6 = nArray2[0];
            bl = blArray[0];
            d3 = dArray12[0];
            d4 = dArray11[0];
            n4 = bl ? --n4 : n8 - 1;
            n7 = n4 + 1;
            dArray7[n4 + 1] = d4;
            int n9 = 0;
            for (int i = 0; i < n4 && n9 <= n4; ++i) {
                int n10;
                int n11;
                for (n11 = n9; n11 <= n4 && 0.0 != dArray7[n11 + 1]; ++n11) {
                }
                if (n11 > n4) {
                    n11 = n4;
                }
                Svdlib.svd_dcopy(n11 - n9 + 1, dArray4, n9, 1, dArray, n9, -1);
                Svdlib.svd_dcopy(n11 - n9, dArray7, n9 + 1, 1, dArray8, n9 + 1, -1);
                this.imtqlb(n11 - n9 + 1, dArray, dArray8, dArray2, n9);
                if (0L != this.ierr) {
                    Svdlib.svd_error("svdLAS2: imtqlb failed to converge (ierr = %ld)\n", this.ierr);
                    Svdlib.svd_error("  l = %ld  i = %ld\n", n9, n11);
                    for (n10 = n9; n10 <= n11; ++n10) {
                        Svdlib.svd_error("  %ld  %lg  %lg  %lg\n", n10, dArray[n10], dArray8[n10], dArray2[n10]);
                    }
                }
                for (n10 = n9; n10 <= n11; ++n10) {
                    dArray2[n10] = d4 * Svdlib.fabs(dArray2[n10]);
                }
                n9 = n11 + 1;
            }
            Svdlib.svd_dsort2((n4 + 1) / 2, n4 + 1, dArray, dArray2);
            boolean[] blArray2 = new boolean[]{bl};
            int n12 = this.error_bound(blArray2, d, d2, dArray, dArray2, n4, d3);
            bl = blArray2[0];
            nArray[0] = n12;
            if (n12 < n2) {
                if (0 == n12) {
                    n8 = n7 + 9;
                    n5 = n7;
                } else {
                    n8 = n7 + Svdlib.svd_imax(3, 1 + (n4 - n5) * (n2 - n12) / n12);
                }
                n8 = Svdlib.svd_imin(n8, n);
            } else {
                bl = true;
            }
            bl = bl || n7 >= n;
        }
        this.store(n3, storeVals.STORQ, n4, dArray3[1]);
        return n4;
    }

    int lanczos_step(SMat sMat, int n, int n2, double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int[] nArray, boolean[] blArray, double[] dArray6, double[] dArray7, int n3) {
        int n4;
        double d = dArray6[0];
        double d2 = dArray7[0];
        for (n4 = n; n4 < n2; ++n4) {
            double[] dArray8 = dArray[2];
            dArray[2] = dArray[1];
            dArray[1] = dArray8;
            dArray8 = dArray[3];
            dArray[3] = dArray[4];
            dArray[4] = dArray8;
            this.store(n3, storeVals.STORQ, n4 - 1, dArray[2]);
            if (n4 - 1 < MAXLL) {
                this.store(n3, storeVals.STORP, n4 - 1, dArray[4]);
            }
            dArray5[n4] = d;
            if (0.0 == dArray5[n4]) {
                d = this.startv(sMat, dArray, n4, n3);
                if (0L != this.ierr) {
                    return n4;
                }
                if (0.0 == d) {
                    blArray[0] = true;
                }
            }
            if (blArray[0]) {
                dArray8 = dArray[2];
                dArray[2] = dArray[1];
                dArray[1] = dArray8;
                break;
            }
            double d3 = 1.0 / d;
            Svdlib.svd_datx(n3, d3, dArray[0], 1, dArray[1], 1);
            Svdlib.svd_dscal(n3, d3, dArray[3], 1);
            Svdlib.svd_opb(sMat, dArray[3], dArray[0], this.OPBTemp);
            Svdlib.svd_daxpy(n3, -d, dArray[2], 1, dArray[0], 1);
            dArray2[n4] = Svdlib.svd_ddot(n3, dArray[0], 1, dArray[3], 1);
            Svdlib.svd_daxpy(n3, -dArray2[n4], dArray[1], 1, dArray[0], 1);
            if (n4 <= MAXLL && Math.abs(dArray2[n4 - 1]) > 4.0 * Math.abs(dArray2[n4])) {
                nArray[0] = n4;
            }
            for (int i = 0; i < Svdlib.svd_imin(nArray[0], n4 - 1); ++i) {
                this.store(n3, storeVals.RETRP, i, dArray[5]);
                d3 = Svdlib.svd_ddot(n3, dArray[5], 1, dArray[0], 1);
                this.store(n3, storeVals.RETRQ, i, dArray[5]);
                Svdlib.svd_daxpy(n3, -d3, dArray[5], 1, dArray[0], 1);
                dArray3[i] = this.eps1;
                dArray4[i] = this.eps1;
            }
            d3 = Svdlib.svd_ddot(n3, dArray[0], 1, dArray[4], 1);
            Svdlib.svd_daxpy(n3, -d3, dArray[2], 1, dArray[0], 1);
            if (dArray5[n4] > 0.0) {
                dArray5[n4] = dArray5[n4] + d3;
            }
            d3 = Svdlib.svd_ddot(n3, dArray[0], 1, dArray[3], 1);
            Svdlib.svd_daxpy(n3, -d3, dArray[1], 1, dArray[0], 1);
            dArray2[n4] = dArray2[n4] + d3;
            Svdlib.svd_dcopy(n3, dArray[0], 1, dArray[4], 1);
            d = Math.sqrt(Svdlib.svd_ddot(n3, dArray[0], 1, dArray[4], 1));
            double d4 = dArray5[n4] + Math.abs(dArray2[n4]) + d;
            d2 = this.reps * d4;
            this.ortbnd(dArray2, dArray3, dArray4, dArray5, n4, d);
            double[] dArray9 = new double[]{d};
            this.purge(n3, nArray[0], dArray[0], dArray[1], dArray[4], dArray[3], dArray[5], dArray3, dArray4, n4, dArray9, d2);
            d = dArray9[0];
            if (!(d <= d2)) continue;
            d = 0.0;
        }
        dArray6[0] = d;
        dArray7[0] = d2;
        return n4;
    }

    void ortbnd(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double d) {
        if (n < 1) {
            return;
        }
        if (0.0 != d) {
            if (n > 1) {
                dArray3[0] = (dArray4[1] * dArray2[1] + (dArray[0] - dArray[n]) * dArray2[0] - dArray4[n] * dArray3[0]) / d + this.eps1;
            }
            for (int i = 1; i <= n - 2; ++i) {
                dArray3[i] = (dArray4[i + 1] * dArray2[i + 1] + (dArray[i] - dArray[n]) * dArray2[i] + dArray4[i] * dArray2[i - 1] - dArray4[n] * dArray3[i]) / d + this.eps1;
            }
        }
        dArray3[n - 1] = this.eps1;
        Svdlib.svd_dswap(n, dArray3, 1, dArray2, 1);
        dArray2[n] = this.eps1;
    }

    void purge(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, int n3, double[] dArray8, double d) {
        double d2 = dArray8[0];
        if (n3 < n2 + 2) {
            return;
        }
        int n4 = Svdlib.svd_idamax(n3 - (n2 + 1), dArray6, n2, 1) + n2;
        if (Math.abs(dArray6[n4]) > this.reps) {
            int n5;
            double d3 = this.eps1 / this.reps;
            boolean bl = true;
            for (int i = 0; i < 2 && bl; ++i) {
                double d4;
                if (!(d2 > d)) continue;
                double d5 = 0.0;
                double d6 = 0.0;
                for (n5 = n2; n5 < n3; ++n5) {
                    this.store(n, storeVals.RETRQ, n5, dArray5);
                    d4 = -Svdlib.svd_ddot(n, dArray4, 1, dArray5, 1);
                    d5 += Math.abs(d4);
                    Svdlib.svd_daxpy(n, d4, dArray5, 1, dArray2, 1);
                    d4 = -Svdlib.svd_ddot(n, dArray3, 1, dArray5, 1);
                    d6 += Math.abs(d4);
                    Svdlib.svd_daxpy(n, d4, dArray5, 1, dArray, 1);
                }
                Svdlib.svd_dcopy(n, dArray2, 1, dArray4, 1);
                d4 = -Svdlib.svd_ddot(n, dArray, 1, dArray4, 1);
                d6 += Math.abs(d4);
                Svdlib.svd_daxpy(n, d4, dArray2, 1, dArray, 1);
                Svdlib.svd_dcopy(n, dArray, 1, dArray3, 1);
                d2 = Math.sqrt(Svdlib.svd_ddot(n, dArray3, 1, dArray, 1));
                if (!(d5 <= d3) || !(d6 <= d3 * d2)) continue;
                bl = false;
            }
            for (n5 = n2; n5 <= n3; ++n5) {
                dArray6[n5] = this.eps1;
                dArray7[n5] = this.eps1;
            }
        }
        dArray8[0] = d2;
    }

    static double fabs(double d) {
        return Math.abs(d);
    }

    void stpone(SMat sMat, double[][] dArray, double[] dArray2, double[] dArray3, int n) {
        double[] dArray4 = dArray[6];
        double d = this.startv(sMat, dArray, 0, n);
        if (d == 0.0 || this.ierr != 0L) {
            return;
        }
        double d2 = 1.0 / d;
        Svdlib.svd_datx(n, d2, dArray[0], 1, dArray[1], 1);
        Svdlib.svd_dscal(n, d2, dArray[3], 1);
        Svdlib.svd_opb(sMat, dArray[3], dArray[0], this.OPBTemp);
        dArray4[0] = Svdlib.svd_ddot(n, dArray[0], 1, dArray[3], 1);
        Svdlib.svd_daxpy(n, -dArray4[0], dArray[1], 1, dArray[0], 1);
        d2 = Svdlib.svd_ddot(n, dArray[0], 1, dArray[3], 1);
        Svdlib.svd_daxpy(n, -d2, dArray[1], 1, dArray[0], 1);
        dArray4[0] = dArray4[0] + d2;
        Svdlib.svd_dcopy(n, dArray[0], 1, dArray[4], 1);
        d = Math.sqrt(Svdlib.svd_ddot(n, dArray[0], 1, dArray[4], 1));
        double d3 = d + Svdlib.fabs(dArray4[0]);
        dArray2[0] = d;
        dArray3[0] = this.reps * d3;
    }

    double startv(SMat sMat, double[][] dArray, int n, int n2) {
        int n3;
        double d = Svdlib.svd_ddot(n2, dArray[0], 1, dArray[0], 1);
        Random random = new Random(918273L + (long)n);
        double[] dArray2 = dArray[0];
        for (int i = 0; i < 3; ++i) {
            if (i > 0 || n > 0 || d == 0.0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray2[n3] = random.nextDouble();
                }
            }
            Svdlib.svd_dcopy(n2, dArray[0], 1, dArray[3], 1);
            Svdlib.svd_opb(sMat, dArray[3], dArray[0], this.OPBTemp);
            Svdlib.svd_dcopy(n2, dArray[0], 1, dArray[3], 1);
            d = Svdlib.svd_ddot(n2, dArray[0], 1, dArray[3], 1);
            if (d > 0.0) break;
        }
        if (d <= 0.0) {
            this.ierr = 8192L;
            return -1.0;
        }
        if (n > 0) {
            double d2;
            for (n3 = 0; n3 < n; ++n3) {
                this.store(n2, storeVals.RETRQ, n3, dArray[5]);
                d2 = -Svdlib.svd_ddot(n2, dArray[3], 1, dArray[5], 1);
                Svdlib.svd_daxpy(n2, d2, dArray[5], 1, dArray[0], 1);
            }
            d2 = Svdlib.svd_ddot(n2, dArray[4], 1, dArray[0], 1);
            Svdlib.svd_daxpy(n2, -d2, dArray[2], 1, dArray[0], 1);
            Svdlib.svd_dcopy(n2, dArray[0], 1, dArray[3], 1);
            d2 = Svdlib.svd_ddot(n2, dArray[3], 1, dArray[0], 1);
            if (d2 <= this.eps * d) {
                d2 = 0.0;
            }
            d = d2;
        }
        return Math.sqrt(d);
    }

    int error_bound(boolean[] blArray, double d, double d2, double[] dArray, double[] dArray2, int n, double d3) {
        int n2;
        int n3 = Svdlib.svd_idamax(n + 1, dArray2, 0, 1);
        for (n2 = (n + 1 + (n - 1)) / 2; n2 >= n3 + 1; --n2) {
            if (!(Svdlib.fabs(dArray[n2 - 1] - dArray[n2]) < this.eps34 * Svdlib.fabs(dArray[n2])) || !(dArray2[n2] > d3) || !(dArray2[n2 - 1] > d3)) continue;
            dArray2[n2 - 1] = Math.sqrt(dArray2[n2] * dArray2[n2] + dArray2[n2 - 1] * dArray2[n2 - 1]);
            dArray2[n2] = 0.0;
        }
        for (n2 = (n + 1 - (n - 1)) / 2; n2 <= n3 - 1; ++n2) {
            if (!(Svdlib.fabs(dArray[n2 + 1] - dArray[n2]) < this.eps34 * Svdlib.fabs(dArray[n2])) || !(dArray2[n2] > d3) || !(dArray2[n2 + 1] > d3)) continue;
            dArray2[n2 + 1] = Math.sqrt(dArray2[n2] * dArray2[n2] + dArray2[n2 + 1] * dArray2[n2 + 1]);
            dArray2[n2] = 0.0;
        }
        int n4 = 0;
        double d4 = dArray[n] - dArray[0];
        for (n2 = 0; n2 <= n; ++n2) {
            double d5 = d4;
            if (n2 < n) {
                d4 = dArray[n2 + 1] - dArray[n2];
            }
            if ((d5 = Svdlib.svd_dmin(d5, d4)) > dArray2[n2]) {
                dArray2[n2] = dArray2[n2] * (dArray2[n2] / d5);
            }
            if (!(dArray2[n2] <= 16.0 * this.eps * Svdlib.fabs(dArray[n2]))) continue;
            ++n4;
            if (blArray[0]) continue;
            blArray[0] = d < dArray[n2] && dArray[n2] < d2;
        }
        return n4;
    }

    void imtqlb(int n, double[] dArray, double[] dArray2, double[] dArray3, int n2) {
        double[] dArray4 = new double[n];
        System.arraycopy(dArray, n2, dArray4, 0, n);
        double[] dArray5 = new double[n];
        System.arraycopy(dArray2, n2, dArray5, 0, n);
        double[] dArray6 = new double[n];
        System.arraycopy(dArray3, n2, dArray6, 0, n);
        this.imtqlb(n, dArray4, dArray5, dArray6);
        System.arraycopy(dArray4, 0, dArray, n2, n);
        System.arraycopy(dArray5, 0, dArray2, n2, n);
        System.arraycopy(dArray6, 0, dArray3, n2, n);
    }

    void imtqlb(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        int n2;
        if (n == 1) {
            return;
        }
        this.ierr = 0L;
        dArray3[0] = 1.0;
        int n3 = n - 1;
        for (n2 = 1; n2 < n; ++n2) {
            dArray3[n2] = 0.0;
            dArray2[n2 - 1] = dArray2[n2];
        }
        dArray2[n3] = 0.0;
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            while (l <= 30L) {
                int n4;
                for (n4 = i; n4 < n; ++n4) {
                    boolean bl = false;
                    if (n4 == n3) break;
                    double d = Svdlib.fabs(dArray[n4]) + Svdlib.fabs(dArray[n4 + 1]);
                    if (d + Svdlib.fabs(dArray2[n4]) == d) {
                        bl = true;
                    }
                    if (bl) break;
                }
                double d = dArray[i];
                double d2 = dArray3[i];
                if (n4 != i) {
                    if (l == 30L) {
                        this.ierr = i;
                        return;
                    }
                    ++l;
                    double d3 = (dArray[i + 1] - d) / (2.0 * dArray2[i]);
                    double d4 = Svdlib.svd_pythag(d3, 1.0);
                    d3 = dArray[n4] - d + dArray2[i] / (d3 + Svdlib.svd_fsign(d4, d3));
                    double d5 = 1.0;
                    double d6 = 1.0;
                    d = 0.0;
                    boolean bl = false;
                    n2 = n4 - 1;
                    while (!bl && n2 >= i) {
                        d2 = d5 * dArray2[n2];
                        double d7 = d6 * dArray2[n2];
                        dArray2[n2 + 1] = d4 = Svdlib.svd_pythag(d2, d3);
                        if (d4 == 0.0) {
                            bl = true;
                            continue;
                        }
                        d5 = d2 / d4;
                        d6 = d3 / d4;
                        d3 = dArray[n2 + 1] - d;
                        d4 = (dArray[n2] - d3) * d5 + 2.0 * d6 * d7;
                        d = d5 * d4;
                        dArray[n2 + 1] = d3 + d;
                        d3 = d6 * d4 - d7;
                        d2 = dArray3[n2 + 1];
                        dArray3[n2 + 1] = d5 * dArray3[n2] + d6 * d2;
                        dArray3[n2] = d6 * dArray3[n2] - d5 * d2;
                        --n2;
                    }
                    if (bl) {
                        int n5 = n2 + 1;
                        dArray[n5] = dArray[n5] - d;
                        dArray2[n4] = 0.0;
                        continue;
                    }
                    int n6 = i;
                    dArray[n6] = dArray[n6] - d;
                    dArray2[i] = d3;
                    dArray2[n4] = 0.0;
                    continue;
                }
                boolean bl = true;
                if (i != 0) {
                    n2 = i;
                    while (n2 >= 1 && bl) {
                        if (d < dArray[n2 - 1]) {
                            dArray[n2] = dArray[n2 - 1];
                            dArray3[n2] = dArray3[n2 - 1];
                            --n2;
                            continue;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    n2 = 0;
                }
                dArray[n2] = d;
                dArray3[n2] = d2;
                l = 31L;
            }
        }
    }

    void imtql2(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3) {
        int n3;
        double d;
        int n4;
        int n5;
        if (n2 == 1) {
            return;
        }
        this.ierr = 0L;
        int n6 = n2 - 1;
        for (n5 = 1; n5 < n2; ++n5) {
            dArray2[n5 - 1] = dArray2[n5];
        }
        dArray2[n6] = 0.0;
        int n7 = n2 * n;
        block1: for (n4 = 0; n4 < n2; ++n4) {
            int n8 = 0;
            while (n8 <= 30) {
                int n9;
                for (n9 = n4; n9 < n2; ++n9) {
                    boolean bl = false;
                    if (n9 == n6) break;
                    double d2 = Svdlib.fabs(dArray[n9]) + Svdlib.fabs(dArray[n9 + 1]);
                    if (d2 + Svdlib.fabs(dArray2[n9]) == d2) {
                        bl = true;
                    }
                    if (bl) break;
                }
                if (n9 == n4) continue block1;
                if (n8 == 30) {
                    this.ierr = n4;
                    return;
                }
                d = dArray[n4];
                ++n8;
                double d3 = (dArray[n4 + 1] - d) / (2.0 * dArray2[n4]);
                double d4 = Svdlib.svd_pythag(d3, 1.0);
                d3 = dArray[n9] - d + dArray2[n4] / (d3 + Svdlib.svd_fsign(d4, d3));
                double d5 = 1.0;
                double d6 = 1.0;
                d = 0.0;
                boolean bl = false;
                n5 = n9 - 1;
                while (!bl && n5 >= n4) {
                    double d7 = d5 * dArray2[n5];
                    double d8 = d6 * dArray2[n5];
                    dArray2[n5 + 1] = d4 = Svdlib.svd_pythag(d7, d3);
                    if (d4 == 0.0) {
                        bl = true;
                        continue;
                    }
                    d5 = d7 / d4;
                    d6 = d3 / d4;
                    d3 = dArray[n5 + 1] - d;
                    d4 = (dArray[n5] - d3) * d5 + 2.0 * d6 * d8;
                    d = d5 * d4;
                    dArray[n5 + 1] = d3 + d;
                    d3 = d6 * d4 - d8;
                    for (n3 = 0; n3 < n7; n3 += n2) {
                        int n10 = n3 + n5;
                        d7 = dArray3[n10 + 1];
                        dArray3[n10 + 1] = d5 * dArray3[n10] + d6 * d7;
                        dArray3[n10] = d6 * dArray3[n10] - d5 * d7;
                    }
                    --n5;
                }
                if (bl) {
                    int n11 = n5 + 1;
                    dArray[n11] = dArray[n11] - d;
                    dArray2[n9] = 0.0;
                    continue;
                }
                int n12 = n4;
                dArray[n12] = dArray[n12] - d;
                dArray2[n4] = d3;
                dArray2[n9] = 0.0;
            }
        }
        for (n4 = 1; n4 < n2; ++n4) {
            int n13;
            n3 = n5 = n4 - 1;
            d = dArray[n5];
            for (n13 = n4; n13 < n2; ++n13) {
                if (!(dArray[n13] < d)) continue;
                n3 = n13;
                d = dArray[n13];
            }
            if (n3 == n5) continue;
            dArray[n3] = dArray[n5];
            dArray[n5] = d;
            for (n13 = 0; n13 < n7; n13 += n2) {
                d = dArray3[n13 + n5];
                dArray3[n13 + n5] = dArray3[n13 + n3];
                dArray3[n13 + n3] = d;
            }
        }
    }

    long[] machar() {
        double d;
        double d2 = 1.0;
        double d3 = d2 + d2;
        double d4 = d2 - d2;
        double d5 = d2;
        double d6 = d2;
        while (d6 - d2 == d4) {
            d5 += d5;
            d = d5 + d2;
            d6 = d - d5;
        }
        double d7 = d2;
        long l = 0L;
        while (l == 0L) {
            d7 += d7;
            d = d5 + d7;
            l = (long)(d - d5);
        }
        long l2 = l;
        double d8 = l2;
        long l3 = 0L;
        d7 = d2;
        d6 = d2;
        while (d6 - d2 == d4) {
            ++l3;
            d = (d7 *= d8) + d2;
            d6 = d - d7;
        }
        long l4 = 0L;
        double d9 = d8 / d3;
        d = d5 + d9;
        if (d - d5 != d4) {
            l4 = 1L;
        }
        double d10 = d5 + d8;
        d = d10 + d9;
        if (l4 == 0L && d - d10 != d4) {
            l4 = 2L;
        }
        long l5 = l3 + 3L;
        double d11 = d2 / d8;
        d5 = d2;
        for (long i = 0L; i < l5; ++i) {
            d5 *= d11;
        }
        d7 = d5;
        d = d2 - d5;
        while (d - d2 == d4) {
            --l5;
            d = d2 - (d5 *= d8);
        }
        l5 = -l5;
        long l6 = -l3 - 3L;
        d5 = d7;
        d = d2 + d5;
        while (d - d2 == d4) {
            ++l6;
            d = d2 + (d5 *= d8);
        }
        this.eps = d5;
        return new long[]{l2, l3, l4, l6, l5};
    }

    void store(int n, storeVals storeVals2, int n2, double[] dArray) {
        switch (storeVals2) {
            case STORQ: {
                if (null == this.LanStore[n2 + MAXLL]) {
                    this.LanStore[n2 + Svdlib.MAXLL] = Svdlib.svd_doubleArray(n, false, "LanStore[j]");
                }
                Svdlib.svd_dcopy(n, dArray, 1, this.LanStore[n2 + MAXLL], 1);
                break;
            }
            case RETRQ: {
                if (null == this.LanStore[n2 + MAXLL]) {
                    throw new Error(String.format("svdLAS2: store (RETRQ) called on index %d (not allocated)", n2 + MAXLL));
                }
                Svdlib.svd_dcopy(n, this.LanStore[n2 + MAXLL], 1, dArray, 1);
                break;
            }
            case STORP: {
                if (n2 >= MAXLL) {
                    throw new Error("svdLAS2: store (STORP) called with j >= MAXLL");
                }
                if (null == this.LanStore[n2]) {
                    this.LanStore[n2] = Svdlib.svd_doubleArray(n, false, "LanStore[j]");
                }
                Svdlib.svd_dcopy(n, dArray, 1, this.LanStore[n2], 1);
                break;
            }
            case RETRP: {
                if (n2 >= MAXLL) {
                    Svdlib.svd_error("svdLAS2: store (RETRP) called with j >= MAXLL", new Object[0]);
                    break;
                }
                if (null == this.LanStore[n2]) {
                    throw new Error(String.format("svdLAS2: store (RETRP) called on index %d (not allocated)", n2));
                }
                Svdlib.svd_dcopy(n, this.LanStore[n2], 1, dArray, 1);
            }
        }
    }

    static SMat svdLoadSparseTextHBFile(File file) throws FileNotFoundException {
        int n;
        int n2;
        Scanner scanner = new Scanner(file);
        scanner.nextLine();
        scanner.nextLine();
        scanner.next();
        int n3 = scanner.nextInt();
        int n4 = scanner.nextInt();
        int n5 = scanner.nextInt();
        int n6 = scanner.nextInt();
        scanner.nextLine();
        if (n6 != 0) {
            throw new Error("svdLoadSparseTextHBFile: I don't know how to handle a file with elemental matrices (last entry on header line 3)");
        }
        scanner.nextLine();
        SMat sMat = new SMat(n3, n4, n5);
        for (n2 = 0; n2 <= sMat.cols; ++n2) {
            n = scanner.nextInt();
            sMat.pointr[n2] = n - 1;
        }
        sMat.pointr[sMat.cols] = sMat.vals;
        for (n2 = 0; n2 < sMat.vals; ++n2) {
            n = scanner.nextInt();
            sMat.rowind[n2] = n - 1;
        }
        for (n2 = 0; n2 < sMat.vals; ++n2) {
            sMat.value[n2] = scanner.nextDouble();
        }
        return sMat;
    }

    static enum storeVals {
        STORQ,
        RETRQ,
        STORP,
        RETRP;

    }
}

