/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.AsciiToBetacode;
import greekconverter.BetacodeToSPIonic;
import greekconverter.BetacodeToUnicode;
import greekconverter.BibleWorksToBetacode;
import greekconverter.BibleWorksToUnicode;
import greekconverter.CodeCharts;
import greekconverter.DynShortArray;
import greekconverter.GreekConvCaps;
import greekconverter.GreekConverter;
import greekconverter.GreekFileConverter;
import greekconverter.GreekKeysToUnicode;
import greekconverter.MessageHandler;
import greekconverter.Nereus;
import greekconverter.UC;
import greekconverter.UnicodeDecompose;
import greekconverter.UnicodePrecompose;
import greekconverter.UnicodeToAscii;
import greekconverter.UnicodeToBetacode;
import greekconverter.UnicodeToGreekKeys;
import greekconverter.UnicodeToHtml;
import greekconverter.UnicodeToName;

public class VersionInfo {
    public static final String DEVELOPER_MN = "Michael Neuhold <homepage.neuhold@aon.at>";
    public static final int CLASSINFO_VERSION_DATE = 0;
    public static final int CLASSINFO_PROG_DESCR = 1;
    public static final int CLASSINFO_DEVELOPER = 2;
    private static int currVersionDate;
    private static int maxVersionDate;
    private static String currVersionDateString;
    private static String maxVersionDateString;
    private static String[] months;
    private static final String blanks = "                                                                                ";

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "21-Jun-2004";
                break;
            }
            case 1: {
                info = "Prints out version info";
                break;
            }
            case 2: {
                info = DEVELOPER_MN;
                break;
            }
            default: {
                info = "Medio tutissimus ibis.";
            }
        }
        return info;
    }

    private static int getNumericDate(String date) {
        int mon;
        int year = Integer.parseInt(date.substring(7));
        String month = date.substring(3, 6);
        int day = Integer.parseInt(date.substring(0, 2));
        for (mon = 0; mon < 12 && !months[mon].equalsIgnoreCase(month); ++mon) {
        }
        return day + (mon + 1) * 100 + year * 10000;
    }

    private static String pad(String s, int len) {
        return s + blanks.substring(0, len - s.length());
    }

    private static void checkDate(String cname) {
        System.out.println(VersionInfo.pad(cname, 25) + ": " + currVersionDateString);
        currVersionDate = VersionInfo.getNumericDate(currVersionDateString);
        if (currVersionDate > maxVersionDate) {
            maxVersionDate = currVersionDate;
            maxVersionDateString = currVersionDateString;
        }
    }

    public static void main(String[] args) {
        int infotype = 0;
        System.out.println("\n- = g r e e k c o n v e r t e r = -");
        System.out.println("Package for conversion between various representations of accented Greek");
        System.out.println("Written and currently maintained by Michael Neuhold <homepage.neuhold@aon.at>");
        System.out.println("\nConversion classes:\n===================");
        currVersionDateString = AsciiToBetacode.getClassInfo(infotype);
        VersionInfo.checkDate("AsciiToBetacode");
        currVersionDateString = BetacodeToSPIonic.getClassInfo(infotype);
        VersionInfo.checkDate("BetacodeToSPIonic");
        currVersionDateString = BetacodeToUnicode.getClassInfo(infotype);
        VersionInfo.checkDate("BetacodeToUnicode");
        currVersionDateString = BibleWorksToBetacode.getClassInfo(infotype);
        VersionInfo.checkDate("BibleWorksToBetacode");
        currVersionDateString = BibleWorksToUnicode.getClassInfo(infotype);
        VersionInfo.checkDate("BibleWorksToUnicode");
        currVersionDateString = GreekKeysToUnicode.getClassInfo(infotype);
        VersionInfo.checkDate("GreekKeysToUnicode");
        currVersionDateString = UnicodeDecompose.getClassInfo(infotype);
        VersionInfo.checkDate("UnicodeDecompose");
        currVersionDateString = UnicodePrecompose.getClassInfo(infotype);
        VersionInfo.checkDate("UnicodePrecompose");
        currVersionDateString = UnicodeToAscii.getClassInfo(infotype);
        VersionInfo.checkDate("UnicodeToAscii");
        currVersionDateString = UnicodeToBetacode.getClassInfo(infotype);
        VersionInfo.checkDate("UnicodeToBetacode");
        currVersionDateString = UnicodeToGreekKeys.getClassInfo(infotype);
        VersionInfo.checkDate("UnicodeToGreekKeys");
        currVersionDateString = UnicodeToHtml.getClassInfo(infotype);
        VersionInfo.checkDate("UnicodeToHtml");
        currVersionDateString = UnicodeToName.getClassInfo(infotype);
        VersionInfo.checkDate("UnicodeToName");
        System.out.println("\nWrapper classes:\n================");
        currVersionDateString = GreekConverter.getClassInfo(infotype);
        VersionInfo.checkDate("GreekConverter");
        currVersionDateString = GreekFileConverter.getClassInfo(infotype);
        VersionInfo.checkDate("GreekFileConverter");
        currVersionDateString = Nereus.getClassInfo(infotype);
        VersionInfo.checkDate("Nereus");
        System.out.println("\nHelper classes:\n===============");
        currVersionDateString = CodeCharts.getClassInfo(infotype);
        VersionInfo.checkDate("CodeCharts");
        currVersionDateString = DynShortArray.getClassInfo(infotype);
        VersionInfo.checkDate("DynShortArray");
        currVersionDateString = GreekConvCaps.getClassInfo(infotype);
        VersionInfo.checkDate("GreekConvCaps");
        currVersionDateString = MessageHandler.getClassInfo(infotype);
        VersionInfo.checkDate("MessageHandler");
        currVersionDateString = UC.getClassInfo(infotype);
        VersionInfo.checkDate("UC");
        currVersionDateString = VersionInfo.getClassInfo(infotype);
        VersionInfo.checkDate("VersionInfo");
        System.out.println("\n---");
        System.out.println(VersionInfo.pad("Latest version date", 25) + ": " + maxVersionDateString);
        System.out.println("---");
    }

    static {
        maxVersionDate = 0;
        months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }
}

