/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;
import greekconverter.UnicodeToName;

public class UnicodeToAscii {
    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "23-Mar-2002";
                break;
            }
            case 1: {
                info = "Converts Greek Unicode into ASCII";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = ".";
            }
        }
        return info;
    }

    String convertString(String uniText) {
        int strLen = uniText.length();
        int strPos = 0;
        String asciiText = new String();
        String asciiChar = new String();
        char prevChar = ' ';
        boolean diphthong = false;
        boolean rho = false;
        MessageHandler.clearMsgQueue();
        MessageHandler.enqueueMsg("Input >" + uniText + "< has " + strLen + " characters\n", 30);
        while (strPos < strLen) {
            char nextChar;
            if (this.isDiphthongSecondVowel(nextChar = uniText.charAt(strPos++))) {
                if (this.isDiphthongFirstVowel(prevChar)) {
                    asciiChar = this.convertChar(prevChar, this.getSecondVowelBreathing(nextChar) ? 1 : 0);
                    diphthong = true;
                } else {
                    asciiChar = this.convertChar(prevChar, 0);
                }
            } else if (this.isRho(nextChar) && this.isRho(prevChar)) {
                asciiChar = this.convertChar(prevChar, 0);
                rho = true;
            } else if (diphthong) {
                asciiChar = this.convertChar(prevChar, 2);
                diphthong = false;
            } else if (rho) {
                asciiChar = this.convertChar(prevChar, 1);
                rho = false;
            } else {
                asciiChar = this.convertChar(prevChar, 0);
            }
            asciiText = asciiText + asciiChar;
            prevChar = nextChar;
            MessageHandler.enqueueMsg(" at pos. " + strPos + "\n");
        }
        asciiChar = diphthong ? this.convertChar(prevChar, 2) : this.convertChar(prevChar, 0);
        asciiText = asciiText + asciiChar;
        MessageHandler.enqueueMsg(" at pos. " + strPos);
        return asciiText.substring(1);
    }

    private String convertChar(char uniChar, int alt) {
        String asciiChar = new String();
        switch (uniChar) {
            case '\u03e2': {
                asciiChar = "\u0160";
                break;
            }
            case '\u03e3': {
                asciiChar = "\u0161";
                break;
            }
            case '\u03e4': {
                asciiChar = "F";
                break;
            }
            case '\u03e5': {
                asciiChar = "f";
                break;
            }
            case '\u03e6': {
                asciiChar = "Ch";
                break;
            }
            case '\u03e7': {
                asciiChar = "ch";
                break;
            }
            case '\u03e8': {
                asciiChar = "H";
                break;
            }
            case '\u03e9': {
                asciiChar = "h";
                break;
            }
            case '\u03ea': {
                asciiChar = "D\u0161";
                break;
            }
            case '\u03eb': {
                asciiChar = "d\u0161";
                break;
            }
            case '\u03ec': {
                asciiChar = "\u0160";
                break;
            }
            case '\u03ed': {
                asciiChar = "\u0161";
                break;
            }
            case '\u03ee': {
                asciiChar = "T";
                break;
            }
            case '\u03ef': {
                asciiChar = "ti";
                break;
            }
            case '?': {
                asciiChar = "?";
                break;
            }
            case '\u1f01': 
            case '\u1f03': 
            case '\u1f05': 
            case '\u1f07': 
            case '\u1f81': 
            case '\u1f83': 
            case '\u1f85': 
            case '\u1f87': {
                asciiChar = "ha";
                break;
            }
            case '\u03b1': 
            case '\u1fb0': 
            case '\u1fb1': {
                if (alt == 1) {
                    asciiChar = "ha";
                    break;
                }
            }
            case '\u03ac': 
            case '\u1f00': 
            case '\u1f02': 
            case '\u1f04': 
            case '\u1f06': 
            case '\u1f70': 
            case '\u1f71': 
            case '\u1f80': 
            case '\u1f82': 
            case '\u1f84': 
            case '\u1f86': 
            case '\u1fb2': 
            case '\u1fb3': 
            case '\u1fb4': 
            case '\u1fb6': 
            case '\u1fb7': {
                asciiChar = "a";
                break;
            }
            case '\u0387': {
                asciiChar = ":";
                break;
            }
            case '\u03b2': 
            case '\u03d0': {
                asciiChar = "b";
                break;
            }
            case '\u1f09': 
            case '\u1f0b': 
            case '\u1f0d': 
            case '\u1f0f': 
            case '\u1f89': 
            case '\u1f8b': 
            case '\u1f8d': 
            case '\u1f8f': {
                asciiChar = "Ha";
                break;
            }
            case '\u0391': 
            case '\u1fb8': 
            case '\u1fb9': {
                if (alt == 1) {
                    asciiChar = "Ha";
                    break;
                }
            }
            case '\u0386': 
            case '\u1f08': 
            case '\u1f0a': 
            case '\u1f0c': 
            case '\u1f0e': 
            case '\u1f88': 
            case '\u1f8a': 
            case '\u1f8c': 
            case '\u1f8e': 
            case '\u1fba': 
            case '\u1fbb': 
            case '\u1fbc': {
                asciiChar = "A";
                break;
            }
            case '\u0392': {
                asciiChar = "B";
                break;
            }
            case '\u03a7': {
                asciiChar = "Ch";
                break;
            }
            case '\u0394': {
                asciiChar = "D";
                break;
            }
            case '\u1f19': 
            case '\u1f1b': 
            case '\u1f1d': {
                asciiChar = "He";
                break;
            }
            case '\u0395': {
                if (alt == 1) {
                    asciiChar = "He";
                    break;
                }
            }
            case '\u0388': 
            case '\u1f18': 
            case '\u1f1a': 
            case '\u1f1c': 
            case '\u1fc8': 
            case '\u1fc9': {
                asciiChar = "E";
                break;
            }
            case '\u1f29': 
            case '\u1f2b': 
            case '\u1f2d': 
            case '\u1f2f': 
            case '\u1f99': 
            case '\u1f9b': 
            case '\u1f9d': 
            case '\u1f9f': {
                asciiChar = "H\u00ea";
                break;
            }
            case '\u0397': {
                if (alt == 1) {
                    asciiChar = "H\u00ea";
                    break;
                }
            }
            case '\u0389': 
            case '\u1f28': 
            case '\u1f2a': 
            case '\u1f2c': 
            case '\u1f2e': 
            case '\u1f98': 
            case '\u1f9a': 
            case '\u1f9c': 
            case '\u1f9e': 
            case '\u1fca': 
            case '\u1fcb': 
            case '\u1fcc': {
                asciiChar = "\u00ca";
                break;
            }
            case '\u0393': {
                asciiChar = "G";
                break;
            }
            case '\u1f39': 
            case '\u1f3b': 
            case '\u1f3d': 
            case '\u1f3f': {
                asciiChar = "Hi";
                break;
            }
            case '\u038a': 
            case '\u0399': 
            case '\u1f38': 
            case '\u1f3a': 
            case '\u1f3c': 
            case '\u1f3e': 
            case '\u1fd8': 
            case '\u1fd9': 
            case '\u1fda': 
            case '\u1fdb': {
                asciiChar = "I";
                break;
            }
            case '\u03aa': {
                asciiChar = "\u00cf";
                break;
            }
            case '\u039a': {
                asciiChar = "K";
                break;
            }
            case '\u039b': {
                asciiChar = "L";
                break;
            }
            case '\u039c': {
                asciiChar = "M";
                break;
            }
            case '\u039d': {
                asciiChar = "N";
                break;
            }
            case '\u1f69': 
            case '\u1f6b': 
            case '\u1f6d': 
            case '\u1f6f': 
            case '\u1fa9': 
            case '\u1fab': 
            case '\u1fad': 
            case '\u1faf': {
                asciiChar = "H\u00f4";
                break;
            }
            case '\u03a9': {
                if (alt == 1) {
                    asciiChar = "H\u00f4";
                    break;
                }
            }
            case '\u038f': 
            case '\u1f68': 
            case '\u1f6a': 
            case '\u1f6c': 
            case '\u1f6e': 
            case '\u1fa8': 
            case '\u1faa': 
            case '\u1fac': 
            case '\u1fae': 
            case '\u1ffa': 
            case '\u1ffb': 
            case '\u1ffc': {
                asciiChar = "\u00d4";
                break;
            }
            case '\u1f49': 
            case '\u1f4b': 
            case '\u1f4d': {
                asciiChar = "Ho";
                break;
            }
            case '\u039f': {
                if (alt == 1) {
                    asciiChar = "Ho";
                    break;
                }
            }
            case '\u038c': 
            case '\u1f48': 
            case '\u1f4a': 
            case '\u1f4c': 
            case '\u1ff8': 
            case '\u1ff9': {
                asciiChar = "O";
                break;
            }
            case '\u03a6': {
                asciiChar = "Ph";
                break;
            }
            case '\u03a0': {
                asciiChar = "P";
                break;
            }
            case '\u03a8': {
                asciiChar = "Ps";
                break;
            }
            case '\u03a1': {
                if (alt == 1) {
                    asciiChar = "RH";
                    break;
                }
                asciiChar = "R";
                break;
            }
            case '\u1fec': {
                asciiChar = "Rh";
                break;
            }
            case '\u03a3': {
                asciiChar = "S";
                break;
            }
            case '\u03a4': {
                asciiChar = "T";
                break;
            }
            case '\u0398': {
                asciiChar = "Th";
                break;
            }
            case '\u1f59': 
            case '\u1f5b': 
            case '\u1f5d': 
            case '\u1f5f': {
                asciiChar = "Hy";
                break;
            }
            case '\u03a5': 
            case '\u1fe8': {
                if (alt == 1) {
                    asciiChar = "Hy";
                    break;
                }
            }
            case '\u038e': 
            case '\u1fe9': 
            case '\u1fea': 
            case '\u1feb': {
                asciiChar = "Y";
                break;
            }
            case '\u03ab': {
                asciiChar = "\u0178";
                break;
            }
            case '\u039e': {
                asciiChar = "X";
                break;
            }
            case '\u0396': {
                asciiChar = "Z";
                break;
            }
            case '\u03c7': {
                asciiChar = "ch";
                break;
            }
            case '\u03b4': {
                asciiChar = "d";
                break;
            }
            case '\u03dc': {
                asciiChar = "v";
                break;
            }
            case '\u1f11': 
            case '\u1f13': 
            case '\u1f15': {
                asciiChar = "he";
                break;
            }
            case '\u03b5': {
                if (alt == 1) {
                    asciiChar = "he";
                    break;
                }
            }
            case '\u03ad': 
            case '\u1f10': 
            case '\u1f12': 
            case '\u1f14': 
            case '\u1f72': 
            case '\u1f73': {
                asciiChar = "e";
                break;
            }
            case '\u1f21': 
            case '\u1f23': 
            case '\u1f25': 
            case '\u1f27': 
            case '\u1f91': 
            case '\u1f93': 
            case '\u1f95': 
            case '\u1f97': {
                asciiChar = "h\u00ea";
                break;
            }
            case '\u03b7': {
                if (alt == 1) {
                    asciiChar = "h\u00ea";
                    break;
                }
            }
            case '\u03ae': 
            case '\u1f20': 
            case '\u1f22': 
            case '\u1f24': 
            case '\u1f26': 
            case '\u1f74': 
            case '\u1f75': 
            case '\u1f90': 
            case '\u1f92': 
            case '\u1f94': 
            case '\u1f96': 
            case '\u1fc2': 
            case '\u1fc3': 
            case '\u1fc4': 
            case '\u1fc6': 
            case '\u1fc7': {
                asciiChar = "\u00ea";
                break;
            }
            case '\u03c2': {
                asciiChar = "s";
                break;
            }
            case '\u03b3': {
                asciiChar = "g";
                break;
            }
            case '\u1f31': 
            case '\u1f33': 
            case '\u1f35': 
            case '\u1f37': {
                if (alt == 2) {
                    asciiChar = "i";
                    break;
                }
                asciiChar = "hi";
                break;
            }
            case '\u03af': 
            case '\u03b9': 
            case '\u1f30': 
            case '\u1f32': 
            case '\u1f34': 
            case '\u1f36': 
            case '\u1f76': 
            case '\u1f77': 
            case '\u1fd0': 
            case '\u1fd1': 
            case '\u1fd6': {
                asciiChar = "i";
                break;
            }
            case '\u0390': 
            case '\u03ca': 
            case '\u1fd2': 
            case '\u1fd3': 
            case '\u1fd7': {
                asciiChar = "\u00ef";
                break;
            }
            case '\u03ba': {
                asciiChar = "k";
                break;
            }
            case '\u03f0': {
                asciiChar = "k";
                break;
            }
            case '\u03de': {
                asciiChar = "q";
                break;
            }
            case '\u1fbd': {
                asciiChar = "'";
                break;
            }
            case '\u03bb': {
                asciiChar = "l";
                break;
            }
            case '\u03f2': {
                asciiChar = "s";
                break;
            }
            case '\u03bc': {
                asciiChar = "m";
                break;
            }
            case '\u03bd': {
                asciiChar = "n";
                break;
            }
            case '\u1f61': 
            case '\u1f63': 
            case '\u1f65': 
            case '\u1f67': 
            case '\u1fa1': 
            case '\u1fa3': 
            case '\u1fa5': 
            case '\u1fa7': {
                asciiChar = "h\u00f4";
                break;
            }
            case '\u03c9': {
                if (alt == 1) {
                    asciiChar = "h\u00f4";
                    break;
                }
            }
            case '\u03ce': 
            case '\u1f60': 
            case '\u1f62': 
            case '\u1f64': 
            case '\u1f66': 
            case '\u1f7c': 
            case '\u1f7d': 
            case '\u1fa0': 
            case '\u1fa2': 
            case '\u1fa4': 
            case '\u1fa6': 
            case '\u1ff2': 
            case '\u1ff3': 
            case '\u1ff4': 
            case '\u1ff6': 
            case '\u1ff7': {
                asciiChar = "\u00f4";
                break;
            }
            case '\u1f41': 
            case '\u1f43': 
            case '\u1f45': {
                asciiChar = "ho";
                break;
            }
            case '\u03bf': {
                if (alt == 1) {
                    asciiChar = "ho";
                    break;
                }
            }
            case '\u03cc': 
            case '\u1f40': 
            case '\u1f42': 
            case '\u1f44': 
            case '\u1f78': 
            case '\u1f79': {
                asciiChar = "o";
                break;
            }
            case '\u03c6': 
            case '\u03d5': {
                asciiChar = "ph";
                break;
            }
            case '\u03c0': 
            case '\u03d6': {
                asciiChar = "p";
                break;
            }
            case '\u1fbe': {
                asciiChar = "i";
                break;
            }
            case '\u03c8': {
                asciiChar = "ps";
                break;
            }
            case '\u03c1': {
                if (alt == 1) {
                    asciiChar = "rh";
                    break;
                }
            }
            case '\u03f1': 
            case '\u1fe4': {
                asciiChar = "r";
                break;
            }
            case '\u1fe5': {
                asciiChar = "rh";
                break;
            }
            case '\u03c3': {
                asciiChar = "s";
                break;
            }
            case '\u03c4': {
                asciiChar = "t";
                break;
            }
            case '\u03b8': 
            case '\u03d1': {
                asciiChar = "th";
                break;
            }
            case '\u03b0': 
            case '\u03cb': 
            case '\u03d4': 
            case '\u1fe2': 
            case '\u1fe3': 
            case '\u1fe7': {
                asciiChar = "\u00ff";
                break;
            }
            case '\u1fe1': {
                asciiChar = "y";
                break;
            }
            case '\u1f51': 
            case '\u1f53': 
            case '\u1f55': 
            case '\u1f57': {
                if (alt == 2) {
                    asciiChar = "u";
                    break;
                }
                asciiChar = "hy";
                break;
            }
            case '\u03c5': 
            case '\u03d2': 
            case '\u1fe0': {
                if (alt == 1) {
                    asciiChar = "hy";
                    break;
                }
            }
            case '\u03cd': 
            case '\u03d3': 
            case '\u1f50': 
            case '\u1f52': 
            case '\u1f54': 
            case '\u1f56': 
            case '\u1f7a': 
            case '\u1f7b': 
            case '\u1fe6': {
                if (alt == 2) {
                    asciiChar = "u";
                    break;
                }
                asciiChar = "y";
                break;
            }
            case '\u03be': {
                asciiChar = "x";
                break;
            }
            case '\u03f3': {
                asciiChar = "j";
                break;
            }
            case '\u03b6': {
                asciiChar = "z";
                break;
            }
            default: {
                if (uniChar <= 'y') {
                    asciiChar = String.valueOf(uniChar);
                    break;
                }
                asciiChar = "{?}";
                Integer i = new Integer(uniChar);
                MessageHandler.enqueueMsg("U+" + Integer.toHexString(uniChar) + " cannot be converted", 10);
            }
        }
        MessageHandler.enqueueMsg(UnicodeToName.convertChar(uniChar) + " -> " + asciiChar + (alt > 0 ? " (" + alt + ")" : ""), 30);
        return asciiChar;
    }

    private boolean isDiphthongFirstVowel(char uniChar) {
        switch (uniChar) {
            case '\u0391': 
            case '\u0395': 
            case '\u0397': 
            case '\u039f': 
            case '\u03a5': 
            case '\u03a9': 
            case '\u03b1': 
            case '\u03b5': 
            case '\u03b7': 
            case '\u03bf': 
            case '\u03c5': 
            case '\u03c9': 
            case '\u03d2': 
            case '\u1fb0': 
            case '\u1fb1': 
            case '\u1fb8': 
            case '\u1fb9': 
            case '\u1fe0': 
            case '\u1fe8': {
                return true;
            }
        }
        return false;
    }

    private boolean isDiphthongSecondVowel(char uniChar) {
        switch (uniChar) {
            case '\u03af': 
            case '\u03b9': 
            case '\u03c5': 
            case '\u03cd': 
            case '\u03d2': 
            case '\u03d3': 
            case '\u1f30': 
            case '\u1f31': 
            case '\u1f32': 
            case '\u1f33': 
            case '\u1f34': 
            case '\u1f35': 
            case '\u1f36': 
            case '\u1f37': 
            case '\u1f50': 
            case '\u1f51': 
            case '\u1f52': 
            case '\u1f53': 
            case '\u1f54': 
            case '\u1f55': 
            case '\u1f56': 
            case '\u1f57': 
            case '\u1f76': 
            case '\u1f77': 
            case '\u1f7a': 
            case '\u1f7b': 
            case '\u1fd0': 
            case '\u1fd6': 
            case '\u1fe0': 
            case '\u1fe6': {
                return true;
            }
        }
        return false;
    }

    private boolean getSecondVowelBreathing(char uniChar) {
        switch (uniChar) {
            case '\u1f31': 
            case '\u1f33': 
            case '\u1f35': 
            case '\u1f37': 
            case '\u1f51': 
            case '\u1f53': 
            case '\u1f55': 
            case '\u1f57': {
                return true;
            }
        }
        return false;
    }

    private boolean isRho(char uniChar) {
        switch (uniChar) {
            case '\u03a1': 
            case '\u03c1': 
            case '\u03f1': 
            case '\u1fe4': 
            case '\u1fe5': 
            case '\u1fec': {
                return true;
            }
        }
        return false;
    }
}

