/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

public class UnicodeDecompose {
    public static final int FULL_EQUIVALENTS = 1;
    public static final int SPACING_DIACRITICS = 2;
    public static final int VARIANTS_SYMBOLS = 4;
    private static final String NOT_SUPPORTED = new String("?");
    private static final String RESERVED = new String("#");
    private static final String[][] tblUnicodeBlocks = new String[256][];
    private static final String[] tblLatin1 = new String[256];
    private static final String[] tblDiacritGreek = new String[256];
    private static final String[] tblGreekExtended = new String[256];
    private static final String[] tblNotSupported = new String[256];

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "28-Mar-2002";
                break;
            }
            case 1: {
                info = "Decomposes / normalizes Greek Unicode text";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "De nihilo nihil.";
            }
        }
        return info;
    }

    public static final String normalizeString(String uniString, int mode) {
        int strLen = uniString.length();
        StringBuffer decomposedString = new StringBuffer(strLen * 3);
        if ((mode & 2) == 2) {
            // empty if block
        }
        if ((mode & 4) == 4) {
            // empty if block
        }
        for (int strPos = 0; strPos < strLen; ++strPos) {
            decomposedString.append(UnicodeDecompose.normalizeChar(uniString.charAt(strPos)));
        }
        return decomposedString.toString();
    }

    public static final String normalizeString(String uniString) {
        return UnicodeDecompose.normalizeString(uniString, 6);
    }

    private static final String normalizeChar(char uniChar) {
        return tblUnicodeBlocks[uniChar >> 8][uniChar & 0xFF];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            UnicodeDecompose.tblUnicodeBlocks[i] = tblNotSupported;
            UnicodeDecompose.tblNotSupported[i] = NOT_SUPPORTED;
            UnicodeDecompose.tblLatin1[i] = String.valueOf((char)i);
            UnicodeDecompose.tblDiacritGreek[i] = String.valueOf((char)(768 + i));
            UnicodeDecompose.tblGreekExtended[i] = RESERVED;
        }
        UnicodeDecompose.tblUnicodeBlocks[0] = tblLatin1;
        UnicodeDecompose.tblUnicodeBlocks[3] = tblDiacritGreek;
        UnicodeDecompose.tblUnicodeBlocks[31] = tblGreekExtended;
        UnicodeDecompose.tblLatin1[192] = "A\u0300";
        UnicodeDecompose.tblLatin1[193] = "A\u0301";
        UnicodeDecompose.tblLatin1[194] = "A\u0302";
        UnicodeDecompose.tblLatin1[195] = "A\u0303";
        UnicodeDecompose.tblLatin1[196] = "A\u0308";
        UnicodeDecompose.tblLatin1[197] = "A\u030a";
        UnicodeDecompose.tblLatin1[199] = "C\u0327";
        UnicodeDecompose.tblLatin1[200] = "E\u0300";
        UnicodeDecompose.tblLatin1[201] = "E\u0301";
        UnicodeDecompose.tblLatin1[202] = "E\u0302";
        UnicodeDecompose.tblLatin1[203] = "E\u0308";
        UnicodeDecompose.tblLatin1[204] = "I\u0300";
        UnicodeDecompose.tblLatin1[205] = "I\u0301";
        UnicodeDecompose.tblLatin1[206] = "I\u0302";
        UnicodeDecompose.tblLatin1[207] = "I\u0308";
        UnicodeDecompose.tblLatin1[209] = "N\u0303";
        UnicodeDecompose.tblLatin1[210] = "O\u0300";
        UnicodeDecompose.tblLatin1[211] = "O\u0301";
        UnicodeDecompose.tblLatin1[212] = "O\u0302";
        UnicodeDecompose.tblLatin1[213] = "O\u0303";
        UnicodeDecompose.tblLatin1[214] = "O\u0308";
        UnicodeDecompose.tblLatin1[217] = "U\u0300";
        UnicodeDecompose.tblLatin1[218] = "U\u0301";
        UnicodeDecompose.tblLatin1[219] = "U\u0302";
        UnicodeDecompose.tblLatin1[220] = "U\u0308";
        UnicodeDecompose.tblLatin1[221] = "Y\u0301";
        UnicodeDecompose.tblLatin1[224] = "a\u0300";
        UnicodeDecompose.tblLatin1[225] = "a\u0301";
        UnicodeDecompose.tblLatin1[226] = "a\u0302";
        UnicodeDecompose.tblLatin1[227] = "a\u0303";
        UnicodeDecompose.tblLatin1[228] = "a\u0308";
        UnicodeDecompose.tblLatin1[229] = "a\u030a";
        UnicodeDecompose.tblLatin1[230] = "c\u0327";
        UnicodeDecompose.tblLatin1[232] = "e\u0300";
        UnicodeDecompose.tblLatin1[233] = "e\u0301";
        UnicodeDecompose.tblLatin1[234] = "e\u0302";
        UnicodeDecompose.tblLatin1[235] = "e\u0308";
        UnicodeDecompose.tblLatin1[236] = "i\u0300";
        UnicodeDecompose.tblLatin1[237] = "i\u0301";
        UnicodeDecompose.tblLatin1[238] = "i\u0302";
        UnicodeDecompose.tblLatin1[239] = "i\u0308";
        UnicodeDecompose.tblLatin1[241] = "n\u0303";
        UnicodeDecompose.tblLatin1[242] = "o\u0300";
        UnicodeDecompose.tblLatin1[243] = "o\u0301";
        UnicodeDecompose.tblLatin1[244] = "o\u0302";
        UnicodeDecompose.tblLatin1[245] = "o\u0303";
        UnicodeDecompose.tblLatin1[246] = "o\u0308";
        UnicodeDecompose.tblLatin1[249] = "u\u0300";
        UnicodeDecompose.tblLatin1[250] = "u\u0301";
        UnicodeDecompose.tblLatin1[251] = "u\u0302";
        UnicodeDecompose.tblLatin1[252] = "u\u0308";
        UnicodeDecompose.tblLatin1[253] = "y\u0301";
        UnicodeDecompose.tblLatin1[255] = "y\u0308";
        UnicodeDecompose.tblDiacritGreek[68] = "\u0308\u0300";
        UnicodeDecompose.tblDiacritGreek[122] = " \u0345";
        UnicodeDecompose.tblDiacritGreek[126] = ";";
        UnicodeDecompose.tblDiacritGreek[132] = " \u0301";
        UnicodeDecompose.tblDiacritGreek[133] = " \u0308\u0301";
        UnicodeDecompose.tblDiacritGreek[134] = "\u0391\u0301";
        UnicodeDecompose.tblDiacritGreek[135] = "\u00b7";
        UnicodeDecompose.tblDiacritGreek[136] = "\u0395\u0301";
        UnicodeDecompose.tblDiacritGreek[137] = "\u0397\u0301";
        UnicodeDecompose.tblDiacritGreek[138] = "\u0399\u0301";
        UnicodeDecompose.tblDiacritGreek[140] = "\u039f\u0301";
        UnicodeDecompose.tblDiacritGreek[142] = "\u03a5\u0301";
        UnicodeDecompose.tblDiacritGreek[143] = "\u03a9\u0301";
        UnicodeDecompose.tblDiacritGreek[144] = "\u03b9\u0308\u0301";
        UnicodeDecompose.tblDiacritGreek[170] = "\u0399\u0308";
        UnicodeDecompose.tblDiacritGreek[171] = "\u03a5\u0308";
        UnicodeDecompose.tblDiacritGreek[172] = "\u03b1\u0301";
        UnicodeDecompose.tblDiacritGreek[173] = "\u03b5\u0301";
        UnicodeDecompose.tblDiacritGreek[174] = "\u03b7\u0301";
        UnicodeDecompose.tblDiacritGreek[175] = "\u03b9\u0301";
        UnicodeDecompose.tblDiacritGreek[176] = "\u03c5\u0308\u0301";
        UnicodeDecompose.tblDiacritGreek[202] = "\u03b9\u0308";
        UnicodeDecompose.tblDiacritGreek[203] = "\u03c5\u0308";
        UnicodeDecompose.tblDiacritGreek[204] = "\u03bf\u0301";
        UnicodeDecompose.tblDiacritGreek[205] = "\u03c5\u0301";
        UnicodeDecompose.tblDiacritGreek[206] = "\u03c9\u0301";
        UnicodeDecompose.tblDiacritGreek[208] = "\u03b2";
        UnicodeDecompose.tblDiacritGreek[209] = "\u03b8";
        UnicodeDecompose.tblDiacritGreek[210] = "\u03a5";
        UnicodeDecompose.tblDiacritGreek[211] = "\u03a5\u0301";
        UnicodeDecompose.tblDiacritGreek[212] = "\u03a5\u0308";
        UnicodeDecompose.tblDiacritGreek[213] = "\u03c6";
        UnicodeDecompose.tblDiacritGreek[214] = "\u03c0";
        UnicodeDecompose.tblDiacritGreek[240] = "\u03ba";
        UnicodeDecompose.tblDiacritGreek[241] = "\u03c1";
        UnicodeDecompose.tblDiacritGreek[244] = "\u0398";
        UnicodeDecompose.tblDiacritGreek[245] = "\u03b5";
        UnicodeDecompose.tblGreekExtended[0] = "\u03b1\u0313";
        UnicodeDecompose.tblGreekExtended[1] = "\u03b1\u0314";
        UnicodeDecompose.tblGreekExtended[2] = "\u03b1\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[3] = "\u03b1\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[4] = "\u03b1\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[5] = "\u03b1\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[6] = "\u03b1\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[7] = "\u03b1\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[8] = "\u0391\u0313";
        UnicodeDecompose.tblGreekExtended[9] = "\u0391\u0314";
        UnicodeDecompose.tblGreekExtended[10] = "\u0391\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[11] = "\u0391\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[12] = "\u0391\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[13] = "\u0391\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[14] = "\u0391\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[15] = "\u0391\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[16] = "\u03b5\u0313";
        UnicodeDecompose.tblGreekExtended[17] = "\u03b5\u0314";
        UnicodeDecompose.tblGreekExtended[18] = "\u03b5\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[19] = "\u03b5\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[20] = "\u03b5\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[21] = "\u03b5\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[24] = "\u0395\u0313";
        UnicodeDecompose.tblGreekExtended[25] = "\u0395\u0314";
        UnicodeDecompose.tblGreekExtended[26] = "\u0395\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[27] = "\u0395\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[28] = "\u0395\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[29] = "\u0395\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[32] = "\u03b7\u0313";
        UnicodeDecompose.tblGreekExtended[33] = "\u03b7\u0314";
        UnicodeDecompose.tblGreekExtended[34] = "\u03b7\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[35] = "\u03b7\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[36] = "\u03b7\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[37] = "\u03b7\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[38] = "\u03b7\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[39] = "\u03b7\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[40] = "\u0397\u0313";
        UnicodeDecompose.tblGreekExtended[41] = "\u0397\u0314";
        UnicodeDecompose.tblGreekExtended[42] = "\u0397\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[43] = "\u0397\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[44] = "\u0397\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[45] = "\u0397\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[46] = "\u0397\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[47] = "\u0397\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[48] = "\u03b9\u0313";
        UnicodeDecompose.tblGreekExtended[49] = "\u03b9\u0314";
        UnicodeDecompose.tblGreekExtended[50] = "\u03b9\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[51] = "\u03b9\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[52] = "\u03b9\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[53] = "\u03b9\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[54] = "\u03b9\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[55] = "\u03b9\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[56] = "\u0399\u0313";
        UnicodeDecompose.tblGreekExtended[57] = "\u0399\u0314";
        UnicodeDecompose.tblGreekExtended[58] = "\u0399\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[59] = "\u0399\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[60] = "\u0399\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[61] = "\u0399\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[62] = "\u0399\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[63] = "\u0399\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[64] = "\u03bf\u0313";
        UnicodeDecompose.tblGreekExtended[65] = "\u03bf\u0314";
        UnicodeDecompose.tblGreekExtended[66] = "\u03bf\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[67] = "\u03bf\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[68] = "\u03bf\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[69] = "\u03bf\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[72] = "\u039f\u0313";
        UnicodeDecompose.tblGreekExtended[73] = "\u039f\u0314";
        UnicodeDecompose.tblGreekExtended[74] = "\u039f\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[75] = "\u039f\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[76] = "\u039f\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[77] = "\u039f\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[80] = "\u03c5\u0313";
        UnicodeDecompose.tblGreekExtended[81] = "\u03c5\u0314";
        UnicodeDecompose.tblGreekExtended[82] = "\u03c5\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[83] = "\u03c5\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[84] = "\u03c5\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[85] = "\u03c5\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[86] = "\u03c5\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[87] = "\u03c5\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[89] = "\u03a5\u0314";
        UnicodeDecompose.tblGreekExtended[91] = "\u03a5\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[93] = "\u03a5\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[95] = "\u03a5\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[96] = "\u03c9\u0313";
        UnicodeDecompose.tblGreekExtended[97] = "\u03c9\u0314";
        UnicodeDecompose.tblGreekExtended[98] = "\u03c9\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[99] = "\u03c9\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[100] = "\u03c9\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[101] = "\u03c9\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[102] = "\u03c9\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[103] = "\u03c9\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[104] = "\u03a9\u0313";
        UnicodeDecompose.tblGreekExtended[105] = "\u03a9\u0314";
        UnicodeDecompose.tblGreekExtended[106] = "\u03a9\u0313\u0300";
        UnicodeDecompose.tblGreekExtended[107] = "\u03a9\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[108] = "\u03a9\u0313\u0301";
        UnicodeDecompose.tblGreekExtended[109] = "\u03a9\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[110] = "\u03a9\u0313\u0342";
        UnicodeDecompose.tblGreekExtended[111] = "\u03a9\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[112] = "\u03b1\u0300";
        UnicodeDecompose.tblGreekExtended[113] = "\u03b1\u0301";
        UnicodeDecompose.tblGreekExtended[114] = "\u03b5\u0300";
        UnicodeDecompose.tblGreekExtended[115] = "\u03b5\u0301";
        UnicodeDecompose.tblGreekExtended[116] = "\u03b7\u0300";
        UnicodeDecompose.tblGreekExtended[117] = "\u03b7\u0301";
        UnicodeDecompose.tblGreekExtended[118] = "\u03b9\u0300";
        UnicodeDecompose.tblGreekExtended[119] = "\u03b9\u0301";
        UnicodeDecompose.tblGreekExtended[120] = "\u03bf\u0300";
        UnicodeDecompose.tblGreekExtended[121] = "\u03bf\u0301";
        UnicodeDecompose.tblGreekExtended[122] = "\u03c5\u0300";
        UnicodeDecompose.tblGreekExtended[123] = "\u03c5\u0301";
        UnicodeDecompose.tblGreekExtended[124] = "\u03c9\u0300";
        UnicodeDecompose.tblGreekExtended[125] = "\u03c9\u0301";
        UnicodeDecompose.tblGreekExtended[128] = "\u03b1\u0313\u0345";
        UnicodeDecompose.tblGreekExtended[129] = "\u03b1\u0314\u0345";
        UnicodeDecompose.tblGreekExtended[130] = "\u03b1\u0313\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[131] = "\u03b1\u0314\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[132] = "\u03b1\u0313\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[133] = "\u03b1\u0314\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[134] = "\u03b1\u0313\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[135] = "\u03b1\u0314\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[136] = "\u0391\u0313\u0345";
        UnicodeDecompose.tblGreekExtended[137] = "\u0391\u0314\u0345";
        UnicodeDecompose.tblGreekExtended[138] = "\u0391\u0313\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[139] = "\u0391\u0314\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[140] = "\u0391\u0313\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[141] = "\u0391\u0314\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[142] = "\u0391\u0313\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[143] = "\u0391\u0314\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[144] = "\u03b7\u0313\u0345";
        UnicodeDecompose.tblGreekExtended[145] = "\u03b7\u0314\u0345";
        UnicodeDecompose.tblGreekExtended[146] = "\u03b7\u0313\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[147] = "\u03b7\u0314\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[148] = "\u03b7\u0313\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[149] = "\u03b7\u0314\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[150] = "\u03b7\u0313\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[151] = "\u03b7\u0314\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[152] = "\u0397\u0313\u0345";
        UnicodeDecompose.tblGreekExtended[153] = "\u0397\u0314\u0345";
        UnicodeDecompose.tblGreekExtended[154] = "\u0397\u0313\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[155] = "\u0397\u0314\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[156] = "\u0397\u0313\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[157] = "\u0397\u0314\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[158] = "\u0397\u0313\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[159] = "\u0397\u0314\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[160] = "\u03c9\u0313\u0345";
        UnicodeDecompose.tblGreekExtended[161] = "\u03c9\u0314\u0345";
        UnicodeDecompose.tblGreekExtended[162] = "\u03c9\u0313\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[163] = "\u03c9\u0314\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[164] = "\u03c9\u0313\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[165] = "\u03c9\u0314\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[166] = "\u03c9\u0313\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[167] = "\u03c9\u0314\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[168] = "\u03a9\u0313\u0345";
        UnicodeDecompose.tblGreekExtended[169] = "\u03a9\u0314\u0345";
        UnicodeDecompose.tblGreekExtended[170] = "\u03a9\u0313\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[171] = "\u03a9\u0314\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[172] = "\u03a9\u0313\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[173] = "\u03a9\u0314\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[174] = "\u03a9\u0313\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[175] = "\u03a9\u0314\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[176] = "\u03b1\u0306";
        UnicodeDecompose.tblGreekExtended[177] = "\u03b1\u0304";
        UnicodeDecompose.tblGreekExtended[178] = "\u03b1\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[179] = "\u03b1\u0345";
        UnicodeDecompose.tblGreekExtended[180] = "\u03b1\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[182] = "\u03b1\u0342";
        UnicodeDecompose.tblGreekExtended[183] = "\u03b1\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[184] = "\u0391\u0306";
        UnicodeDecompose.tblGreekExtended[185] = "\u0391\u0304";
        UnicodeDecompose.tblGreekExtended[186] = "\u0391\u0300";
        UnicodeDecompose.tblGreekExtended[187] = "\u0391\u0301";
        UnicodeDecompose.tblGreekExtended[188] = "\u0391\u0345";
        UnicodeDecompose.tblGreekExtended[189] = " \u0313";
        UnicodeDecompose.tblGreekExtended[190] = " \u0345";
        UnicodeDecompose.tblGreekExtended[191] = " \u0313";
        UnicodeDecompose.tblGreekExtended[192] = " \u0342";
        UnicodeDecompose.tblGreekExtended[193] = " \u0308\u0342";
        UnicodeDecompose.tblGreekExtended[194] = "\u03b7\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[195] = "\u03b7\u0345";
        UnicodeDecompose.tblGreekExtended[196] = "\u03b7\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[198] = "\u03b7\u0342";
        UnicodeDecompose.tblGreekExtended[199] = "\u03b7\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[200] = "\u0395\u0300";
        UnicodeDecompose.tblGreekExtended[201] = "\u0395\u0301";
        UnicodeDecompose.tblGreekExtended[202] = "\u0397\u0300";
        UnicodeDecompose.tblGreekExtended[203] = "\u0397\u0301";
        UnicodeDecompose.tblGreekExtended[204] = "\u0397\u0345";
        UnicodeDecompose.tblGreekExtended[205] = " \u0313\u0300";
        UnicodeDecompose.tblGreekExtended[206] = " \u0313\u0301";
        UnicodeDecompose.tblGreekExtended[207] = " \u0313\u0342";
        UnicodeDecompose.tblGreekExtended[208] = "\u03b9\u0306";
        UnicodeDecompose.tblGreekExtended[209] = "\u03b9\u0304";
        UnicodeDecompose.tblGreekExtended[210] = "\u03b9\u0308\u0300";
        UnicodeDecompose.tblGreekExtended[211] = "\u03b9\u0308\u0301";
        UnicodeDecompose.tblGreekExtended[214] = "\u03b9\u0342";
        UnicodeDecompose.tblGreekExtended[215] = "\u03b9\u0308\u0342";
        UnicodeDecompose.tblGreekExtended[216] = "\u0399\u0306";
        UnicodeDecompose.tblGreekExtended[217] = "\u0399\u0304";
        UnicodeDecompose.tblGreekExtended[218] = "\u0399\u0300";
        UnicodeDecompose.tblGreekExtended[219] = "\u0399\u0301";
        UnicodeDecompose.tblGreekExtended[221] = "\u0314\u0300";
        UnicodeDecompose.tblGreekExtended[222] = "\u0314\u0301";
        UnicodeDecompose.tblGreekExtended[223] = "\u0314\u0342";
        UnicodeDecompose.tblGreekExtended[224] = "\u03c5\u0306";
        UnicodeDecompose.tblGreekExtended[225] = "\u03c5\u0304";
        UnicodeDecompose.tblGreekExtended[226] = "\u03c5\u0308\u0300";
        UnicodeDecompose.tblGreekExtended[227] = "\u03c5\u0308\u0301";
        UnicodeDecompose.tblGreekExtended[228] = "\u03c1\u0313";
        UnicodeDecompose.tblGreekExtended[229] = "\u03c1\u0314";
        UnicodeDecompose.tblGreekExtended[230] = "\u03c5\u0342";
        UnicodeDecompose.tblGreekExtended[231] = "\u03c5\u0308\u0342";
        UnicodeDecompose.tblGreekExtended[232] = "\u03a5\u0306";
        UnicodeDecompose.tblGreekExtended[233] = "\u03a5\u0304";
        UnicodeDecompose.tblGreekExtended[234] = "\u03a5\u0300";
        UnicodeDecompose.tblGreekExtended[235] = "\u03a5\u0301";
        UnicodeDecompose.tblGreekExtended[236] = "\u03a1\u0314";
        UnicodeDecompose.tblGreekExtended[237] = " \u0308\u0300";
        UnicodeDecompose.tblGreekExtended[238] = " \u0308\u0301";
        UnicodeDecompose.tblGreekExtended[239] = " \u0300";
        UnicodeDecompose.tblGreekExtended[242] = "\u03c9\u0300\u0345";
        UnicodeDecompose.tblGreekExtended[243] = "\u03c9\u0345";
        UnicodeDecompose.tblGreekExtended[244] = "\u03c9\u0301\u0345";
        UnicodeDecompose.tblGreekExtended[246] = "\u03c9\u0342";
        UnicodeDecompose.tblGreekExtended[247] = "\u03c9\u0342\u0345";
        UnicodeDecompose.tblGreekExtended[248] = "\u039f\u0300";
        UnicodeDecompose.tblGreekExtended[249] = "\u039f\u0301";
        UnicodeDecompose.tblGreekExtended[250] = "\u03a9\u0300";
        UnicodeDecompose.tblGreekExtended[251] = "\u03a9\u0301";
        UnicodeDecompose.tblGreekExtended[252] = "\u03a9\u0345";
        UnicodeDecompose.tblGreekExtended[253] = " \u0301";
        UnicodeDecompose.tblGreekExtended[254] = " \u0314";
    }
}

