/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

public class MessageHandler {
    public static final int MSGLVL_NOMSG = 0;
    public static final int MSGLVL_ERRORMSG = 10;
    public static final int MSGLVL_STATUSMSG = 20;
    public static final int MSGLVL_DEBUGMSG = 30;
    private static int msgLevel = 10;
    private static StringBuffer msgQueue = new StringBuffer(128);
    private static boolean msgSemaphore;

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "20-Aug-2006";
                break;
            }
            case 1: {
                info = "Contains methods for maintaining error and debug messages";
                break;
            }
            case 2: {
                info = "Michael Neuhold <private.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Brevis esse laboro, obscurus fio.";
            }
        }
        return info;
    }

    public static void setMsgLevel(int level) {
        System.out.println("Message level set to: " + level);
        msgLevel = level < 0 ? 0 : (level > 30 ? 30 : level);
    }

    public static int getMsgLevel() {
        return msgLevel;
    }

    public static void enqueueMsg(String msg, int msgLevel) {
        if (msgLevel <= MessageHandler.getMsgLevel()) {
            msgQueue.append(msg);
            msgSemaphore = true;
        }
    }

    public static void enqueueMsg(String msg) {
        if (msgSemaphore) {
            msgQueue.append(msg);
            msgSemaphore = false;
        }
    }

    public static void clearMsgQueue() {
        msgQueue.setLength(0);
        msgSemaphore = false;
    }

    public static boolean isMsgQueueEmpty() {
        return msgQueue.length() == 0;
    }

    public static void printMsgQueue(String infoHeader, String infoFooter) {
        if (!MessageHandler.isMsgQueueEmpty()) {
            if (infoHeader != null) {
                System.err.println(infoHeader);
            }
            System.err.println(msgQueue.toString());
            if (infoFooter != null) {
                System.err.println(infoFooter);
            }
            MessageHandler.clearMsgQueue();
        }
    }

    public static String dequeueMsg() {
        String msgQueueCopy = new String(msgQueue.toString());
        MessageHandler.clearMsgQueue();
        return msgQueueCopy;
    }
}

