/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;
import java.util.Hashtable;

public class HtmlToUnicode {
    private static final Hashtable tblLookup = new Hashtable();
    private static int i;
    private static int j;

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "19-Aug-2006";
                break;
            }
            case 1: {
                info = "Converts an HTML string into Unicode";
                break;
            }
            case 2: {
                info = "Michael Neuhold <private.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Sapienti sat est.";
            }
        }
        return info;
    }

    public static String convertString(String htmlString) {
        int strLen = htmlString.length();
        int entRadix = 0;
        boolean isEntity = false;
        boolean isEntComplete = false;
        String entString = new String();
        StringBuffer uniStrBuf = new StringBuffer(255);
        StringBuffer entStrBuf = new StringBuffer();
        for (int strPos = 0; strPos < strLen; ++strPos) {
            char currChar = htmlString.charAt(strPos);
            switch (currChar) {
                case '&': {
                    isEntity = true;
                    break;
                }
                case '#': {
                    if (!isEntity) break;
                    entRadix = 10;
                    break;
                }
                case 'x': {
                    if (entRadix == 0) break;
                    entRadix = 16;
                    break;
                }
                case ';': {
                    if (!isEntity) break;
                    isEntComplete = true;
                }
            }
            if (isEntity) {
                entStrBuf.append(currChar);
                if (!isEntComplete) continue;
                entString = entStrBuf.toString();
                int entStrPos = 0;
                switch (entRadix) {
                    case 0: {
                        entStrPos = 1;
                        break;
                    }
                    case 10: {
                        entStrPos = 2;
                        break;
                    }
                    case 16: {
                        entStrPos = 3;
                    }
                }
                currChar = HtmlToUnicode.convertEntity(entString.substring(entStrPos, entString.length() - 1), entRadix);
                if (currChar == '\u0000') {
                    uniStrBuf.append(entStrBuf);
                } else {
                    uniStrBuf.append(currChar);
                }
                isEntity = false;
                isEntComplete = false;
                entRadix = 0;
                entStrBuf.delete(0, entStrBuf.length());
                continue;
            }
            uniStrBuf.append(currChar);
        }
        return uniStrBuf.toString();
    }

    private static char convertEntity(String entString, int entRadix) {
        Integer entNumInt;
        MessageHandler.enqueueMsg(">" + entString + "<", 30);
        int entNum = entRadix != 0 ? Integer.parseInt(entString, entRadix) : ((entNumInt = (Integer)tblLookup.get(entString)) == null ? 0 : entNumInt);
        MessageHandler.enqueueMsg("=" + entNum + "\n", 30);
        return (char)entNum;
    }

    static {
        tblLookup.put("nbsp", new Integer(160));
        tblLookup.put("iexcl", new Integer(161));
        tblLookup.put("cent", new Integer(162));
        tblLookup.put("pound", new Integer(163));
        tblLookup.put("curren", new Integer(164));
        tblLookup.put("yen", new Integer(165));
        tblLookup.put("brvbar", new Integer(166));
        tblLookup.put("sect", new Integer(167));
        tblLookup.put("uml", new Integer(168));
        tblLookup.put("copy", new Integer(169));
        tblLookup.put("ordf", new Integer(170));
        tblLookup.put("laquo", new Integer(171));
        tblLookup.put("not", new Integer(172));
        tblLookup.put("shy", new Integer(173));
        tblLookup.put("reg", new Integer(174));
        tblLookup.put("macr", new Integer(175));
        tblLookup.put("deg", new Integer(176));
        tblLookup.put("plusmn", new Integer(177));
        tblLookup.put("sup2", new Integer(178));
        tblLookup.put("sup3", new Integer(179));
        tblLookup.put("acute", new Integer(180));
        tblLookup.put("micro", new Integer(181));
        tblLookup.put("para", new Integer(182));
        tblLookup.put("middot", new Integer(183));
        tblLookup.put("cedil", new Integer(184));
        tblLookup.put("sup1", new Integer(185));
        tblLookup.put("ordm", new Integer(186));
        tblLookup.put("raquo", new Integer(187));
        tblLookup.put("frac14", new Integer(188));
        tblLookup.put("frac12", new Integer(189));
        tblLookup.put("frac34", new Integer(190));
        tblLookup.put("iquest", new Integer(191));
        tblLookup.put("Agrave", new Integer(192));
        tblLookup.put("Aacute", new Integer(193));
        tblLookup.put("Acirc", new Integer(194));
        tblLookup.put("Atilde", new Integer(195));
        tblLookup.put("Auml", new Integer(196));
        tblLookup.put("Aring", new Integer(197));
        tblLookup.put("AElig", new Integer(198));
        tblLookup.put("Ccedil", new Integer(199));
        tblLookup.put("Egrave", new Integer(200));
        tblLookup.put("Eacute", new Integer(201));
        tblLookup.put("Ecirc", new Integer(202));
        tblLookup.put("Euml", new Integer(203));
        tblLookup.put("Igrave", new Integer(204));
        tblLookup.put("Iacute", new Integer(205));
        tblLookup.put("Icirc", new Integer(206));
        tblLookup.put("Iuml", new Integer(207));
        tblLookup.put("ETH", new Integer(208));
        tblLookup.put("Ntilde", new Integer(209));
        tblLookup.put("Ograve", new Integer(210));
        tblLookup.put("Oacute", new Integer(211));
        tblLookup.put("Ocirc", new Integer(212));
        tblLookup.put("Otilde", new Integer(213));
        tblLookup.put("Ouml", new Integer(214));
        tblLookup.put("times", new Integer(215));
        tblLookup.put("Oslash", new Integer(216));
        tblLookup.put("Ugrave", new Integer(217));
        tblLookup.put("Uacute", new Integer(218));
        tblLookup.put("Ucirc", new Integer(219));
        tblLookup.put("Uuml", new Integer(220));
        tblLookup.put("Yacute", new Integer(221));
        tblLookup.put("THORN", new Integer(222));
        tblLookup.put("szlig", new Integer(223));
        tblLookup.put("agrave", new Integer(224));
        tblLookup.put("aacute", new Integer(225));
        tblLookup.put("acirc", new Integer(226));
        tblLookup.put("atilde", new Integer(227));
        tblLookup.put("auml", new Integer(228));
        tblLookup.put("aring", new Integer(229));
        tblLookup.put("aelig", new Integer(230));
        tblLookup.put("ccedil", new Integer(231));
        tblLookup.put("egrave", new Integer(232));
        tblLookup.put("eacute", new Integer(233));
        tblLookup.put("ecirc", new Integer(234));
        tblLookup.put("euml", new Integer(235));
        tblLookup.put("igrave", new Integer(236));
        tblLookup.put("iacute", new Integer(237));
        tblLookup.put("icirc", new Integer(238));
        tblLookup.put("iuml", new Integer(239));
        tblLookup.put("eth", new Integer(240));
        tblLookup.put("ntilde", new Integer(241));
        tblLookup.put("ograve", new Integer(242));
        tblLookup.put("oacute", new Integer(243));
        tblLookup.put("ocirc", new Integer(244));
        tblLookup.put("otilde", new Integer(245));
        tblLookup.put("ouml", new Integer(246));
        tblLookup.put("divide", new Integer(247));
        tblLookup.put("oslash", new Integer(248));
        tblLookup.put("ugrave", new Integer(249));
        tblLookup.put("uacute", new Integer(250));
        tblLookup.put("ucirc", new Integer(251));
        tblLookup.put("uuml", new Integer(252));
        tblLookup.put("yacute", new Integer(253));
        tblLookup.put("thorn", new Integer(254));
        tblLookup.put("yuml", new Integer(255));
        i = 768;
        tblLookup.put("Alpha", new Integer(i + 145));
        tblLookup.put("Beta", new Integer(i + 146));
        tblLookup.put("Gamma", new Integer(i + 147));
        tblLookup.put("Delta", new Integer(i + 148));
        tblLookup.put("Epsilon", new Integer(i + 149));
        tblLookup.put("Zeta", new Integer(i + 150));
        tblLookup.put("Eta", new Integer(i + 151));
        tblLookup.put("Theta", new Integer(i + 152));
        tblLookup.put("Iota", new Integer(i + 153));
        tblLookup.put("Kappa", new Integer(i + 154));
        tblLookup.put("Lambda", new Integer(i + 155));
        tblLookup.put("Mu", new Integer(i + 156));
        tblLookup.put("Nu", new Integer(i + 157));
        tblLookup.put("Xi", new Integer(i + 158));
        tblLookup.put("Omicron", new Integer(i + 159));
        tblLookup.put("Pi", new Integer(i + 160));
        tblLookup.put("Rho", new Integer(i + 161));
        tblLookup.put("Sigma", new Integer(i + 163));
        tblLookup.put("Tau", new Integer(i + 164));
        tblLookup.put("Upsilon", new Integer(i + 165));
        tblLookup.put("Phi", new Integer(i + 166));
        tblLookup.put("Chi", new Integer(i + 167));
        tblLookup.put("Psi", new Integer(i + 168));
        tblLookup.put("Omega", new Integer(i + 169));
        tblLookup.put("alpha", new Integer(i + 177));
        tblLookup.put("beta", new Integer(i + 178));
        tblLookup.put("gamma", new Integer(i + 179));
        tblLookup.put("delta", new Integer(i + 180));
        tblLookup.put("epsilon", new Integer(i + 181));
        tblLookup.put("zeta", new Integer(i + 182));
        tblLookup.put("eta", new Integer(i + 183));
        tblLookup.put("theta", new Integer(i + 184));
        tblLookup.put("iota", new Integer(i + 185));
        tblLookup.put("kappa", new Integer(i + 186));
        tblLookup.put("lambda", new Integer(i + 187));
        tblLookup.put("mu", new Integer(i + 188));
        tblLookup.put("nu", new Integer(i + 189));
        tblLookup.put("xi", new Integer(i + 190));
        tblLookup.put("omicron", new Integer(i + 191));
        tblLookup.put("pi", new Integer(i + 192));
        tblLookup.put("rho", new Integer(i + 193));
        tblLookup.put("sigmaf", new Integer(i + 194));
        tblLookup.put("sigma", new Integer(i + 195));
        tblLookup.put("tau", new Integer(i + 196));
        tblLookup.put("upsilon", new Integer(i + 197));
        tblLookup.put("phi", new Integer(i + 198));
        tblLookup.put("chi", new Integer(i + 199));
        tblLookup.put("psi", new Integer(i + 200));
        tblLookup.put("omega", new Integer(i + 201));
        tblLookup.put("thetasym", new Integer(i + 209));
        tblLookup.put("upsih", new Integer(i + 210));
        tblLookup.put("piv", new Integer(i + 214));
        j = 8192;
        tblLookup.put("ensp", new Integer(j + 2));
        tblLookup.put("emsp", new Integer(j + 3));
        tblLookup.put("thinsp", new Integer(j + 9));
        tblLookup.put("zwnj", new Integer(j + 12));
        tblLookup.put("zwj", new Integer(j + 13));
        tblLookup.put("lrm", new Integer(j + 14));
        tblLookup.put("rlm", new Integer(j + 15));
        tblLookup.put("ndash", new Integer(j + 19));
        tblLookup.put("mdash", new Integer(j + 20));
        tblLookup.put("lsquo", new Integer(j + 24));
        tblLookup.put("rsquo", new Integer(j + 25));
        tblLookup.put("sbquo", new Integer(j + 26));
        tblLookup.put("ldquo", new Integer(j + 28));
        tblLookup.put("rdquo", new Integer(j + 29));
        tblLookup.put("bdquo", new Integer(j + 30));
        tblLookup.put("dagger", new Integer(j + 32));
        tblLookup.put("Dagger", new Integer(j + 33));
        tblLookup.put("bull", new Integer(j + 34));
        tblLookup.put("hellip", new Integer(j + 38));
        tblLookup.put("permil", new Integer(j + 48));
        tblLookup.put("prime", new Integer(j + 50));
        tblLookup.put("lsaquo", new Integer(j + 57));
        tblLookup.put("rsaquo", new Integer(j + 58));
        tblLookup.put("oline", new Integer(j + 62));
        tblLookup.put("frasl", new Integer(j + 68));
    }
}

