/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.DynShortArray;
import greekconverter.GreekConvCaps;
import greekconverter.GreekConverter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class GreekFileConverter {
    public static final int SUCCESS = 0;
    public static final int ERR_GENERAL = -1;
    private static final int ERR_FILE_PARAMS = -2;
    private static final int ERR_UNKNOWN_CONV = -3;
    private static final int ERR_NO_UTF = -4;
    private static final int ERR_FILE_OPEN = -5;
    private static final int ERR_IO = -6;
    private static final int ERR_PARAMS = -7;
    private int convFrom;
    private int convInto;
    private String errMsg;
    private GreekConverter gc = new GreekConverter();
    private String encString = null;
    private BufferedReader cIn = null;
    private BufferedWriter cOut = null;
    private BufferedInputStream bIn = null;
    private BufferedOutputStream bOut = null;
    private InputStreamReader isr;
    private OutputStreamWriter osw;

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "19-Aug-2006";
                break;
            }
            case 1: {
                info = "Converts whole files from one Greek encoding into another one using class GreekConverter";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Dimidium qui coepit habet.";
            }
        }
        return info;
    }

    public void setOption(int optType, int optVal) {
        switch (optType) {
            case 1: {
                this.gc.setHTMLMode(optVal);
            }
        }
    }

    public int openInput(String inputFile, String inputEncoding, int convFrom) {
        try {
            if (convFrom == 4) {
                this.bIn = new BufferedInputStream(new DataInputStream(new FileInputStream(inputFile)));
            } else {
                if (inputEncoding == null && convFrom == 1) {
                    inputEncoding = "UTF-8";
                }
                this.isr = inputEncoding == null ? new FileReader(inputFile) : new InputStreamReader((InputStream)new FileInputStream(inputFile), inputEncoding);
                this.cIn = new BufferedReader(this.isr);
            }
            return 0;
        }
        catch (IOException e) {
            this.handleException(e, "Error opening " + inputFile + " for input");
            return -5;
        }
    }

    public int openOutput(String outputFile, String outputEncoding, int convInto) {
        try {
            if (convInto == 4) {
                this.bOut = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(outputFile)));
                this.encString = this.isr.getEncoding();
            } else {
                if (outputEncoding == null && convInto == 1) {
                    outputEncoding = "UTF-8";
                }
                this.osw = outputEncoding == null ? new FileWriter(outputFile) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding);
                this.cOut = new BufferedWriter(this.osw);
                this.encString = this.osw.getEncoding();
            }
            return 0;
        }
        catch (IOException e) {
            this.handleException(e, "Error opening " + outputFile + " for output");
            return -5;
        }
    }

    public void closeInput() {
        try {
            if (this.bIn != null) {
                this.bIn.close();
            } else if (this.cIn != null) {
                this.cIn.close();
            }
        }
        catch (IOException e) {
            this.handleException(e, "Error closing input file");
        }
    }

    public void closeOutput() {
        try {
            if (this.bOut != null) {
                this.bOut.close();
            } else if (this.cOut != null) {
                this.cOut.close();
            }
        }
        catch (IOException e) {
            this.handleException(e, "Error closing output file");
        }
    }

    private void handleException(Exception e, String defMsg) {
        this.errMsg = e.getLocalizedMessage();
        if (this.errMsg == null) {
            this.errMsg = defMsg;
        }
        System.err.println(this.errMsg);
        e.printStackTrace();
    }

    int checkFileParams(String inputFile, String outputFile) {
        int retVal = 0;
        if (inputFile == null || inputFile.equals("")) {
            this.errMsg = "You have not provided the name of the source file.";
            retVal = -2;
        } else if (outputFile == null || outputFile.equals("")) {
            this.errMsg = "You have not provided the name for the destination file.";
            retVal = -2;
        } else {
            File ifile = new File(inputFile);
            File ofile = new File(outputFile);
            if (ifile.compareTo(ofile) == 0) {
                this.errMsg = "Source and destination cannot be the same.";
                retVal = -2;
            }
        }
        if (retVal != 0) {
            System.err.println("ERROR! " + this.errMsg);
        }
        return retVal;
    }

    private int checkEncParams(int convMode, String inputEncoding, String outputEncoding) {
        int retVal = 0;
        switch (convMode) {
            case 1002: 
            case 1003: 
            case 1004: 
            case 1006: 
            case 1007: 
            case 1011: 
            case 1021: 
            case 2001: 
            case 2008: 
            case 3001: 
            case 4001: 
            case 5001: 
            case 5002: 
            case 6002: {
                break;
            }
            default: {
                this.errMsg = "Not recognized or not supported conversion.";
                retVal = -3;
            }
        }
        if (retVal == 0) {
            this.convFrom = GreekConvCaps.getConvInput(convMode);
            this.convInto = GreekConvCaps.getConvOutput(convMode);
            if (!(this.convFrom != 1 || inputEncoding != null && inputEncoding.substring(0, 3).equals("UTF"))) {
                this.errMsg = "Conversion from Greek Unicode needs UTF input file encoding.";
                retVal = -4;
            }
        }
        if (!(retVal != 0 || this.convInto != 1 || outputEncoding != null && outputEncoding.substring(0, 3).equals("UTF"))) {
            this.errMsg = "Conversion into Unicode needs UTF output file encoding.";
            retVal = -4;
        }
        if (retVal != 0) {
            System.err.println("ERROR! " + this.errMsg);
        }
        return retVal;
    }

    public int convertFile(String inputFile, String outputFile, int convMode) {
        return this.convertFile(inputFile, outputFile, convMode, null, null);
    }

    public int convertFile(String inputFile, String outputFile, int convMode, String inputEncoding, String outputEncoding) {
        short[] s = null;
        int lineNum = 0;
        System.out.println("Invoking method convertFile of class " + this.getClass().getName());
        System.out.println("Version " + GreekFileConverter.getClassInfo(0));
        int retVal = this.openInput(inputFile, inputEncoding, this.convFrom);
        if (retVal != 0) {
            return retVal;
        }
        retVal = this.openOutput(outputFile, outputEncoding, this.convInto);
        if (retVal != 0) {
            return retVal;
        }
        try {
            if (this.convFrom == 4) {
                String outLine;
                int b;
                boolean newLineFlag = false;
                DynShortArray dynArr = new DynShortArray(512, 255);
                while ((b = this.bIn.read()) != -1) {
                    if (b == 10 || b == 13) {
                        if (!newLineFlag) {
                            if (lineNum++ % 20 == 0) {
                                System.out.print(".");
                            }
                            dynArr.pushElem((short)0);
                            outLine = this.gc.convertStringGreekKeysToUni(dynArr.getArray());
                            this.cOut.write(outLine, 0, outLine.length());
                            this.cOut.newLine();
                            dynArr.reset();
                            newLineFlag = true;
                            continue;
                        }
                        newLineFlag = false;
                        continue;
                    }
                    dynArr.pushElem((short)b);
                }
                if (dynArr.getPos() > -1) {
                    outLine = this.gc.convertStringGreekKeysToUni(dynArr.getArray());
                    this.cOut.write(outLine, 0, outLine.length());
                    this.cOut.newLine();
                }
            } else {
                String inLine;
                while ((inLine = this.cIn.readLine()) != null) {
                    String outLine;
                    if (lineNum++ % 20 == 0) {
                        System.out.print(".");
                    }
                    if (this.convInto == 4) {
                        s = this.gc.convertStringUniToGreekKeys(inLine);
                        this.gc.printMessageQueue("line " + String.valueOf(lineNum + 1), null);
                        int i = 0;
                        while (s[i] != 0) {
                            this.bOut.write((byte)s[i]);
                            ++i;
                        }
                        this.bOut.write(13);
                        this.bOut.write(10);
                        continue;
                    }
                    switch (convMode) {
                        case 1002: {
                            outLine = this.gc.convertStringUniToBeta(inLine);
                            break;
                        }
                        case 1006: {
                            outLine = this.gc.convertStringUniToAscii(inLine);
                            break;
                        }
                        case 1003: {
                            outLine = this.gc.convertStringUniToHtml(inLine);
                            break;
                        }
                        case 1007: {
                            outLine = this.gc.convertStringUniToName(inLine);
                            break;
                        }
                        case 2001: {
                            outLine = this.gc.convertStringBetaToUni(inLine);
                            break;
                        }
                        case 2008: {
                            outLine = this.gc.convertStringBetaToSp(inLine);
                            break;
                        }
                        case 3001: {
                            outLine = this.gc.convertStringHtmlToUni(inLine);
                            break;
                        }
                        case 6002: {
                            outLine = this.gc.convertStringAsciiToBeta(inLine);
                            break;
                        }
                        case 5002: {
                            outLine = this.gc.convertStringBwToBeta(inLine);
                            break;
                        }
                        case 5001: {
                            outLine = this.gc.convertStringBwToUni(inLine);
                            break;
                        }
                        case 1011: {
                            outLine = this.gc.decomposeUnicode(inLine);
                            break;
                        }
                        case 1021: {
                            outLine = this.gc.precomposeUnicode(inLine);
                            break;
                        }
                        default: {
                            outLine = "";
                        }
                    }
                    this.gc.printMessageQueue("line " + String.valueOf(lineNum + 1), null);
                    this.cOut.write(outLine, 0, outLine.length());
                    this.cOut.newLine();
                }
            }
            this.closeInput();
            this.closeOutput();
            return 0;
        }
        catch (IOException e) {
            this.errMsg = e.getLocalizedMessage();
            if (this.errMsg == null) {
                this.errMsg = "IOError - look at the console window.";
                if (this.convFrom == 1) {
                    this.errMsg = this.errMsg + " (Maybe invalid Unicode input.)";
                }
            }
            if (lineNum != 0) {
                this.errMsg = this.errMsg + " - line " + String.valueOf(lineNum);
            }
            e.printStackTrace();
            return -6;
        }
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public static void main(String[] args) {
        String usg = "GreekFileConverter srcfile destfile convmode [-inputenc value] [-outputenc value]";
        if (args.length == 1 && args[0].equals("-?")) {
            System.out.println(usg);
            System.out.println(" srcfile     file name (and path) of the source text file");
            System.out.println(" destfile    file name (and path) of the output destination file");
            System.out.println(" convmode    Greek conversion mode");
            System.out.println(" -inputenc   encoding of srcfile, e.g. US-ASCII, ISO-8859-1, UTF-8");
            System.out.println("             default is the local charset");
            System.out.println(" -outputenc  encoding of destfile, like -inputenc");
            System.out.println(" Valid conversion modes are:");
            System.out.println(GreekConvCaps.getConvModes());
            return;
        }
        String srcFile = null;
        String destFile = null;
        String convMode = null;
        String inputEnc = null;
        String outputEnc = null;
        String errMsg = null;
        String opt = null;
        if (args.length < 3) {
            System.err.println("ERROR! Wrong number of parameters. Usage:\n" + usg + "\nInvoke with \"-?\" to get help on parameters.");
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            block17: {
                if (args[i].charAt(0) == '-') {
                    try {
                        opt = args[i].substring(1);
                        ++i;
                        if (opt.equals("inputenc")) {
                            inputEnc = args[i];
                            break block17;
                        }
                        if (opt.equals("outputenc")) {
                            outputEnc = args[i];
                            break block17;
                        }
                        errMsg = "Unrecognized option -" + opt;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println("ERROR! Missing value for option -" + opt);
                        System.exit(-7);
                    }
                } else if (srcFile == null) {
                    srcFile = args[i];
                } else if (destFile == null) {
                    destFile = args[i];
                } else if (convMode == null) {
                    convMode = args[i];
                } else {
                    errMsg = "Extra parameter " + args[i];
                }
            }
            if (errMsg == null) continue;
            System.err.println("ERROR! " + errMsg);
            System.exit(-7);
        }
        GreekFileConverter gfc = new GreekFileConverter();
        int retVal = gfc.checkFileParams(srcFile, destFile);
        if (retVal == 0) {
            retVal = gfc.checkEncParams(Integer.valueOf(convMode), inputEnc, outputEnc);
        }
        if (retVal == 0) {
            retVal = gfc.convertFile(srcFile, destFile, Integer.valueOf(convMode), inputEnc, outputEnc);
        }
    }
}

