/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.AsciiToBetacode;
import greekconverter.BetacodeToSPIonic;
import greekconverter.BetacodeToUnicode;
import greekconverter.BibleWorksToBetacode;
import greekconverter.BibleWorksToUnicode;
import greekconverter.GreekKeysToUnicode;
import greekconverter.HtmlToUnicode;
import greekconverter.MessageHandler;
import greekconverter.UnicodeDecompose;
import greekconverter.UnicodePrecompose;
import greekconverter.UnicodeToAscii;
import greekconverter.UnicodeToBetacode;
import greekconverter.UnicodeToGreekKeys;
import greekconverter.UnicodeToHtml;
import greekconverter.UnicodeToName;

public class GreekConverter {
    private String lastErrMsg;
    private BetacodeToUnicode beta2Uni = new BetacodeToUnicode();
    private BibleWorksToBetacode bw2Beta = new BibleWorksToBetacode();
    private UnicodeToAscii uni2Ascii = new UnicodeToAscii();

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "20-Aug-2006";
                break;
            }
            case 1: {
                info = "Wrapper class for the conversion classes";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Ut desint vires, tamen est laudanda voluntas.";
            }
        }
        return info;
    }

    public void printMessageQueue(String infoHeader, String infoFooter) {
        MessageHandler.printMsgQueue(infoHeader, infoFooter);
    }

    public void setMessageLevel(int level) {
        MessageHandler.setMsgLevel(level);
        MessageHandler.enqueueMsg("MessageLevel set to " + level, 20);
    }

    public int getMessageLevel() {
        return MessageHandler.getMsgLevel();
    }

    public String decomposeUnicode(String uniString) {
        return UnicodeDecompose.normalizeString(uniString);
    }

    public String precomposeUnicode(String uniString) {
        return UnicodePrecompose.precomposeStringFirstPass(uniString);
    }

    public String convertStringUniToBeta(String uniString) {
        return UnicodeToBetacode.convertString(uniString);
    }

    public String convertStringUniToAscii(String uniString) {
        return this.uni2Ascii.convertString(uniString);
    }

    public String convertStringUniToHtml(String uniString) {
        return UnicodeToHtml.convertString(uniString);
    }

    public void setHTMLMode(int mode) {
        UnicodeToHtml.setMode(mode);
    }

    public short[] convertStringUniToGreekKeys(String uniString) {
        return UnicodeToGreekKeys.convertString(uniString);
    }

    public String convertStringGreekKeysToUni(short[] gkString) {
        return GreekKeysToUnicode.convertString(gkString);
    }

    public String convertStringBwToBeta(String bwString) {
        return this.bw2Beta.convertString(bwString);
    }

    public String convertStringBwToUni(String bwString) {
        return BibleWorksToUnicode.convertString(bwString);
    }

    public String convertStringBetaToUni(String betaString) {
        return this.beta2Uni.convertString(betaString);
    }

    public String convertStringBetaToSp(String betaString) {
        return BetacodeToSPIonic.convertString(betaString);
    }

    public String convertStringAsciiToBeta(String uniString) {
        return AsciiToBetacode.convertString(uniString);
    }

    public String convertStringUniToName(String uniString) {
        return UnicodeToName.convertString(uniString);
    }

    public String convertStringHtmlToUni(String htmlString) {
        return HtmlToUnicode.convertString(htmlString);
    }
}

