/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class BibleWorksToUnicode {
    private static final String NOT_SUPPORTED = "?";
    private static final String[] tblLookup = new String[256];

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "30-May-2002";
                break;
            }
            case 1: {
                info = "Converts text with BibleWorks' coding into decomposed Unicode.";
                break;
            }
            case 2: {
                info = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Principiis obsta, sero medicina paratur.";
            }
        }
        return info;
    }

    static final String convertString(String bwString) {
        int strLen = bwString.length();
        StringBuffer uniString = new StringBuffer(strLen * 2);
        char prevChar = ' ';
        MessageHandler.clearMsgQueue();
        for (int strPos = 0; strPos < strLen; ++strPos) {
            char currChar = bwString.charAt(strPos);
            uniString.append(BibleWorksToUnicode.convertChar(prevChar, currChar));
            prevChar = currChar;
            MessageHandler.enqueueMsg(" at pos. " + String.valueOf(strPos + 1) + "\n");
        }
        return uniString.toString();
    }

    private static final String convertChar(char prevBwChar, char bwChar) {
        String prevUniChar = tblLookup[prevBwChar];
        String uniChar = tblLookup[bwChar];
        String retChar = null;
        retChar = prevUniChar.charAt(0) == '\u00a7' ? uniChar + prevUniChar.substring(1) : (uniChar.charAt(0) == '\u00a7' ? (bwChar == 'V' ? (prevBwChar != ' ' ? "'" : "") : "") : uniChar);
        return retChar;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BibleWorksToUnicode.tblLookup[i] = NOT_SUPPORTED;
        }
        BibleWorksToUnicode.tblLookup[9] = "\t";
        BibleWorksToUnicode.tblLookup[10] = "\n";
        BibleWorksToUnicode.tblLookup[11] = "\u000b";
        BibleWorksToUnicode.tblLookup[12] = "\f";
        BibleWorksToUnicode.tblLookup[13] = "\r";
        BibleWorksToUnicode.tblLookup[32] = " ";
        BibleWorksToUnicode.tblLookup[33] = "+";
        BibleWorksToUnicode.tblLookup[34] = "\u00a7\u0313\u0300";
        BibleWorksToUnicode.tblLookup[35] = "]";
        BibleWorksToUnicode.tblLookup[36] = "(";
        BibleWorksToUnicode.tblLookup[37] = ")";
        BibleWorksToUnicode.tblLookup[38] = "-";
        BibleWorksToUnicode.tblLookup[39] = "\u0313\u0300";
        BibleWorksToUnicode.tblLookup[40] = ",";
        BibleWorksToUnicode.tblLookup[41] = ".";
        BibleWorksToUnicode.tblLookup[42] = "\u037e";
        BibleWorksToUnicode.tblLookup[43] = "\u00a7\u0313\u0342";
        BibleWorksToUnicode.tblLookup[44] = "\u0301";
        BibleWorksToUnicode.tblLookup[45] = "\u0314\u0342";
        BibleWorksToUnicode.tblLookup[46] = "\u0300";
        BibleWorksToUnicode.tblLookup[47] = "\u0342";
        BibleWorksToUnicode.tblLookup[48] = "0";
        BibleWorksToUnicode.tblLookup[49] = "1";
        BibleWorksToUnicode.tblLookup[50] = "2";
        BibleWorksToUnicode.tblLookup[51] = "3";
        BibleWorksToUnicode.tblLookup[52] = "4";
        BibleWorksToUnicode.tblLookup[53] = "5";
        BibleWorksToUnicode.tblLookup[54] = "6";
        BibleWorksToUnicode.tblLookup[55] = "7";
        BibleWorksToUnicode.tblLookup[56] = "8";
        BibleWorksToUnicode.tblLookup[57] = "9";
        BibleWorksToUnicode.tblLookup[58] = "\u00a7\u0313\u0301";
        BibleWorksToUnicode.tblLookup[59] = "\u0313\u0301";
        BibleWorksToUnicode.tblLookup[60] = "\u0308\u0301";
        BibleWorksToUnicode.tblLookup[61] = "\u0313\u0342";
        BibleWorksToUnicode.tblLookup[62] = "\u0308\u0300";
        BibleWorksToUnicode.tblLookup[63] = "\u0308";
        BibleWorksToUnicode.tblLookup[64] = "[";
        BibleWorksToUnicode.tblLookup[65] = "\u0391";
        BibleWorksToUnicode.tblLookup[66] = "\u0392";
        BibleWorksToUnicode.tblLookup[67] = "\u03a7";
        BibleWorksToUnicode.tblLookup[68] = "\u0394";
        BibleWorksToUnicode.tblLookup[69] = "\u0395";
        BibleWorksToUnicode.tblLookup[70] = "\u03a6";
        BibleWorksToUnicode.tblLookup[71] = "\u0393";
        BibleWorksToUnicode.tblLookup[72] = "\u0397";
        BibleWorksToUnicode.tblLookup[73] = "\u0399";
        BibleWorksToUnicode.tblLookup[75] = "\u039a";
        BibleWorksToUnicode.tblLookup[76] = "\u039b";
        BibleWorksToUnicode.tblLookup[77] = "\u039c";
        BibleWorksToUnicode.tblLookup[78] = "\u039d";
        BibleWorksToUnicode.tblLookup[79] = "\u039f";
        BibleWorksToUnicode.tblLookup[80] = "\u03a0";
        BibleWorksToUnicode.tblLookup[81] = "\u0398";
        BibleWorksToUnicode.tblLookup[82] = "\u03a1";
        BibleWorksToUnicode.tblLookup[83] = "\u03a3";
        BibleWorksToUnicode.tblLookup[84] = "\u03a4";
        BibleWorksToUnicode.tblLookup[85] = "\u03a5";
        BibleWorksToUnicode.tblLookup[86] = "\u00a7\u0313";
        BibleWorksToUnicode.tblLookup[87] = "\u03a9";
        BibleWorksToUnicode.tblLookup[88] = "\u039e";
        BibleWorksToUnicode.tblLookup[89] = "\u03a8";
        BibleWorksToUnicode.tblLookup[90] = "\u0396";
        BibleWorksToUnicode.tblLookup[91] = "\u0314\u0301";
        BibleWorksToUnicode.tblLookup[92] = "\u0387";
        BibleWorksToUnicode.tblLookup[93] = "\u0314\u0300";
        BibleWorksToUnicode.tblLookup[94] = "*";
        BibleWorksToUnicode.tblLookup[95] = "\u00a7\u0314\u0342";
        BibleWorksToUnicode.tblLookup[96] = "\u0314";
        BibleWorksToUnicode.tblLookup[97] = "\u03b1";
        BibleWorksToUnicode.tblLookup[98] = "\u03b2";
        BibleWorksToUnicode.tblLookup[99] = "\u03c7";
        BibleWorksToUnicode.tblLookup[100] = "\u03b4";
        BibleWorksToUnicode.tblLookup[101] = "\u03b5";
        BibleWorksToUnicode.tblLookup[102] = "\u03c6";
        BibleWorksToUnicode.tblLookup[103] = "\u03b3";
        BibleWorksToUnicode.tblLookup[104] = "\u03b7";
        BibleWorksToUnicode.tblLookup[105] = "\u03b9";
        BibleWorksToUnicode.tblLookup[106] = "\u03c2";
        BibleWorksToUnicode.tblLookup[107] = "\u03ba";
        BibleWorksToUnicode.tblLookup[108] = "\u03bb";
        BibleWorksToUnicode.tblLookup[109] = "\u03bc";
        BibleWorksToUnicode.tblLookup[110] = "\u03bd";
        BibleWorksToUnicode.tblLookup[111] = "\u03bf";
        BibleWorksToUnicode.tblLookup[112] = "\u03c0";
        BibleWorksToUnicode.tblLookup[113] = "\u03b8";
        BibleWorksToUnicode.tblLookup[114] = "\u03c1";
        BibleWorksToUnicode.tblLookup[115] = "\u03c3";
        BibleWorksToUnicode.tblLookup[116] = "\u03c4";
        BibleWorksToUnicode.tblLookup[117] = "\u03c5";
        BibleWorksToUnicode.tblLookup[118] = "\u0313";
        BibleWorksToUnicode.tblLookup[119] = "\u03c9";
        BibleWorksToUnicode.tblLookup[120] = "\u03be";
        BibleWorksToUnicode.tblLookup[121] = "\u03c8";
        BibleWorksToUnicode.tblLookup[122] = "\u03b6";
        BibleWorksToUnicode.tblLookup[123] = "\u00a7\u0314\u0301";
        BibleWorksToUnicode.tblLookup[124] = "\u0345";
        BibleWorksToUnicode.tblLookup[125] = "\u00a7\u0314\u0300";
        BibleWorksToUnicode.tblLookup[126] = "\u00a7\u0314";
        BibleWorksToUnicode.tblLookup[160] = "\u00a0";
        BibleWorksToUnicode.tblLookup[182] = "\u00b6";
        BibleWorksToUnicode.tblLookup[183] = "\u00b7";
        BibleWorksToUnicode.tblLookup[184] = "!";
        BibleWorksToUnicode.tblLookup[185] = "\"";
        BibleWorksToUnicode.tblLookup[186] = "#";
        BibleWorksToUnicode.tblLookup[187] = "$";
        BibleWorksToUnicode.tblLookup[188] = "%";
        BibleWorksToUnicode.tblLookup[189] = "&";
        BibleWorksToUnicode.tblLookup[190] = "'";
        BibleWorksToUnicode.tblLookup[191] = "(";
        BibleWorksToUnicode.tblLookup[192] = ")";
        BibleWorksToUnicode.tblLookup[193] = "*";
        BibleWorksToUnicode.tblLookup[194] = "+";
        BibleWorksToUnicode.tblLookup[195] = ",";
        BibleWorksToUnicode.tblLookup[196] = "-";
        BibleWorksToUnicode.tblLookup[197] = ".";
        BibleWorksToUnicode.tblLookup[198] = "/";
        BibleWorksToUnicode.tblLookup[199] = ":";
        BibleWorksToUnicode.tblLookup[200] = ";";
        BibleWorksToUnicode.tblLookup[201] = "<";
        BibleWorksToUnicode.tblLookup[202] = "=";
        BibleWorksToUnicode.tblLookup[203] = ">";
        BibleWorksToUnicode.tblLookup[204] = NOT_SUPPORTED;
        BibleWorksToUnicode.tblLookup[205] = "@";
        BibleWorksToUnicode.tblLookup[206] = "[";
        BibleWorksToUnicode.tblLookup[207] = "\\";
        BibleWorksToUnicode.tblLookup[208] = "]";
        BibleWorksToUnicode.tblLookup[209] = "^";
        BibleWorksToUnicode.tblLookup[210] = "_";
        BibleWorksToUnicode.tblLookup[211] = "`";
        BibleWorksToUnicode.tblLookup[212] = "{";
        BibleWorksToUnicode.tblLookup[213] = "|";
        BibleWorksToUnicode.tblLookup[214] = "}";
        BibleWorksToUnicode.tblLookup[215] = "~";
        BibleWorksToUnicode.tblLookup[218] = "\u0323";
    }
}

