/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class BetacodeToSPIonic {
    private static final char UNDEFINED_SYMBOL = '\u0000';
    private static final byte WORDEND_NO = 0;
    private static final byte WORDEND_YES = 1;
    private static final byte[] tblWordEnd = new byte[256];
    private static boolean UPPERCASE;

    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "20-Jun-2004";
                break;
            }
            case 1: {
                info = "Converts a Beta coded string into simplified (SPIonic/Sgreek) Beta code.";
                break;
            }
            case 2: {
                info = "Michael Neuhold <homepage.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Sic itur ad astra.";
            }
        }
        return info;
    }

    public static String convertString(String betaText) {
        betaText = betaText + ' ';
        int strLen = betaText.length();
        int strPos = 0;
        StringBuffer uniText = new StringBuffer(strLen);
        MessageHandler.clearMsgQueue();
        MessageHandler.enqueueMsg("Input >" + betaText + "< has " + strLen + " characters", 20);
        char prevChar = betaText.charAt(strPos++);
        while (strPos < strLen) {
            char currChar = betaText.charAt(strPos++);
            switch (currChar) {
                case '*': {
                    UPPERCASE = true;
                    break;
                }
                default: {
                    if (!(tblWordEnd[currChar] != 1 || prevChar != 'S' && prevChar != 's' || UPPERCASE)) {
                        uniText.append('j');
                        prevChar = currChar;
                        break;
                    }
                    if (UPPERCASE) {
                        if (prevChar > '@') {
                            uniText.append(Character.toUpperCase(prevChar));
                            UPPERCASE = false;
                        } else {
                            uniText.append(prevChar);
                        }
                    } else {
                        uniText.append(Character.toLowerCase(prevChar));
                    }
                    prevChar = currChar;
                }
            }
            MessageHandler.enqueueMsg(" at pos. " + strPos + "\n");
        }
        return uniText.toString();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BetacodeToSPIonic.tblWordEnd[i] = 0;
        }
        BetacodeToSPIonic.tblWordEnd[32] = 1;
        BetacodeToSPIonic.tblWordEnd[46] = 1;
        BetacodeToSPIonic.tblWordEnd[58] = 1;
        BetacodeToSPIonic.tblWordEnd[59] = 1;
        BetacodeToSPIonic.tblWordEnd[44] = 1;
        BetacodeToSPIonic.tblWordEnd[10] = 1;
        BetacodeToSPIonic.tblWordEnd[13] = 1;
        BetacodeToSPIonic.tblWordEnd[9] = 1;
        BetacodeToSPIonic.tblWordEnd[34] = 1;
        BetacodeToSPIonic.tblWordEnd[39] = 1;
        UPPERCASE = false;
    }
}

