/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class AsciiToBetacode {
    public static String getClassInfo(int infoType) {
        String info;
        switch (infoType) {
            case 0: {
                info = "26-Apr-2002";
                break;
            }
            case 1: {
                info = "Converts an ASCII string containing Greek text into Betacode";
                break;
            }
            case 2: {
                info = "Michael Neuhold <private.neuhold@aon.at>";
                break;
            }
            default: {
                info = "Omnes una manet nox.";
            }
        }
        return info;
    }

    public static String convertString(String uniString) {
        int strLen = uniString.length();
        char prevChar = '\n';
        boolean isEndOfWord = false;
        String betaString = new String();
        uniString = uniString + " ";
        MessageHandler.clearMsgQueue();
        for (int strPos = 0; strPos < strLen; ++strPos) {
            char currChar = uniString.charAt(strPos);
            betaString = betaString + AsciiToBetacode.convertChar(prevChar, currChar, uniString.charAt(strPos + 1));
            prevChar = currChar;
            MessageHandler.enqueueMsg(" at pos. " + String.valueOf(strPos + 1) + "\n");
        }
        return betaString;
    }

    private static String getAsciiConvChar(char origChar, char convChar) {
        String ret = new String();
        ret = Character.isUpperCase(origChar) ? "*" + convChar : "" + convChar;
        return ret;
    }

    private static String convertChar(char prevChar, char currChar, char nextChar) {
        char currCharUpper = Character.toUpperCase(currChar);
        char nextCharUpper = Character.toUpperCase(nextChar);
        String betaChar = new String();
        if (currChar > 'y') {
            switch (currChar) {
                case '\u00ca': {
                    betaChar = "*H";
                    break;
                }
                case '\u00ea': {
                    betaChar = "H";
                    break;
                }
                case '\u00d4': {
                    betaChar = "*W";
                    break;
                }
                case '\u00f4': {
                    betaChar = "W";
                    break;
                }
                case '\u00cf': {
                    betaChar = "*+I";
                    break;
                }
                case '\u00ef': {
                    betaChar = "I+";
                    break;
                }
                case '\u0178': {
                    betaChar = "*+U";
                    break;
                }
                case '\u00ff': {
                    betaChar = "U+";
                    break;
                }
                default: {
                    betaChar = "?";
                    break;
                }
            }
        } else {
            block10 : switch (currCharUpper) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case ':': 
                case ';': 
                case '?': 
                case 'A': 
                case 'B': 
                case 'D': 
                case 'E': 
                case 'G': 
                case 'I': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'R': 
                case 'U': 
                case 'Z': {
                    betaChar = AsciiToBetacode.getAsciiConvChar(currChar, currCharUpper);
                    break;
                }
                case 'C': 
                case 'K': 
                case 'T': {
                    if (nextCharUpper == 'H') break;
                    betaChar = AsciiToBetacode.getAsciiConvChar(currChar, currCharUpper);
                    break;
                }
                case 'P': {
                    if (nextCharUpper == 'H' || nextCharUpper == 'S') break;
                    betaChar = AsciiToBetacode.getAsciiConvChar(currChar, currCharUpper);
                    break;
                }
                case 'Y': {
                    betaChar = AsciiToBetacode.getAsciiConvChar(currChar, 'U');
                    break;
                }
                case 'X': {
                    betaChar = AsciiToBetacode.getAsciiConvChar(currChar, 'C');
                    break;
                }
                case 'S': {
                    if (prevChar == 'P') {
                        betaChar = "*Y";
                        break;
                    }
                    if (prevChar == 'p') {
                        betaChar = "Y";
                        break;
                    }
                    if (currChar == 's') {
                        switch (nextChar) {
                            case '\t': 
                            case '\n': 
                            case '\u000b': 
                            case '\f': 
                            case '\r': 
                            case ' ': 
                            case '(': 
                            case ')': 
                            case ',': 
                            case '-': 
                            case '.': 
                            case '/': 
                            case ':': 
                            case ';': 
                            case '?': 
                            case '[': 
                            case ']': 
                            case '{': 
                            case '}': {
                                betaChar = "J";
                                break block10;
                            }
                        }
                        betaChar = "S";
                        break;
                    }
                    betaChar = "*S";
                    break;
                }
                case 'H': {
                    switch (prevChar) {
                        case 'T': {
                            betaChar = "*Q";
                            break block10;
                        }
                        case 't': {
                            betaChar = "Q";
                            break block10;
                        }
                        case 'P': {
                            betaChar = "*F";
                            break block10;
                        }
                        case 'p': {
                            betaChar = "F";
                            break block10;
                        }
                        case 'C': 
                        case 'K': {
                            betaChar = "*X";
                            break block10;
                        }
                        case 'c': 
                        case 'k': {
                            betaChar = "X";
                        }
                    }
                }
            }
        }
        return betaChar;
    }
}

