/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder.xml.sax;

import edu.unc.epidoc.transcoder.TransCoder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscodingContentHandler
implements ContentHandler,
LexicalHandler {
    private static String DEFAULT_LANG = "eng";
    private String language = DEFAULT_LANG;
    private String[] langAttrs;
    private TransCoder tc;
    private Stack<String[]> elements;
    private Stack<String> languages;
    private Stack<String> parsers;
    private Stack<String> converters;
    private List<Object[]> eventBuffer = new ArrayList<Object[]>();
    private StringBuffer charBuffer = new StringBuffer();
    private boolean eventBufferOn = false;
    private boolean flushingBuffer = false;
    private String currentElt;
    public static String NAMESPACE = "http://stoa.org/2002/transcoder";
    private static String TC_NAME = "transcode";
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private List<String[]> flowTerminators;

    public void setup(ContentHandler ch, LexicalHandler lh, TransCoder tc, String useAttribute, String lang, List<String[]> flowTerminators) throws Exception {
        this.contentHandler = ch;
        this.lexicalHandler = lh;
        this.tc = tc;
        this.langAttrs = useAttribute != null ? new String[]{useAttribute} : new String[]{"lang", "xml:lang"};
        this.elements = new Stack();
        this.languages = new Stack();
        if (lang != null) {
            this.languages.push(lang);
        } else {
            this.languages.push(DEFAULT_LANG);
        }
        this.parsers = new Stack();
        this.parsers.push(tc.getParser().getClass().getName());
        this.converters = new Stack();
        this.converters.push(tc.getConverter().getClass().getName());
        this.flowTerminators = new ArrayList<String[]>();
        if (flowTerminators == null) {
            this.flowTerminators.add(new String[]{"", "div([0-7])?", "container"});
            this.flowTerminators.add(new String[]{"", "p", "container"});
            this.flowTerminators.add(new String[]{"", "lb", "milestone"});
            this.flowTerminators.add(new String[]{"", "l", "container"});
            this.flowTerminators.add(new String[]{"http://www.tei-c.org/ns/1.0", "div([0-7])?", "container"});
            this.flowTerminators.add(new String[]{"http://www.tei-c.org/ns/1.0", "p", "container"});
            this.flowTerminators.add(new String[]{"http://www.tei-c.org/ns/1.0", "lb", "milestone"});
            this.flowTerminators.add(new String[]{"http://www.tei-c.org/ns/1.0", "l", "container"});
        } else {
            for (String[] ft : flowTerminators) {
                if (ft.length != 3 || ft[1] == null || "".equals(ft[1])) continue;
                if (ft[0] == null) {
                    ft[0] = "";
                }
                this.flowTerminators.add(ft);
            }
        }
    }

    public void setup(ContentHandler ch, LexicalHandler lh, TransCoder tc) throws Exception {
        this.setup(ch, lh, tc, null, null, null);
    }

    @Override
    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        this.currentElt = name;
        for (String[] ft : this.flowTerminators) {
            if (!ft[0].equals(uri) || !ft[1].matches(name) || this.flushingBuffer) continue;
            if (this.eventBufferOn) {
                this.eventBufferOn = false;
                this.flushingBuffer = true;
                this.flushEventBuffer();
                this.flushingBuffer = false;
                this.eventBufferOn = true;
                continue;
            }
            this.eventBufferOn = true;
            this.charBuffer = new StringBuffer();
        }
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"startElement", uri, name, raw, new AttributesImpl(attributes)});
        } else if (NAMESPACE.equals(uri) && name.equals(TC_NAME)) {
            for (String lang : this.langAttrs) {
                if (attributes.getValue(lang) == null) continue;
                this.language = attributes.getValue(lang);
                break;
            }
            this.languages.push(new String(this.language));
            if (attributes.getValue("source") != null) {
                this.parsers.push(attributes.getValue("source"));
                try {
                    this.tc.setParser(this.parsers.peek());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if (attributes.getValue("result") != null) {
                this.converters.push(attributes.getValue("result"));
                try {
                    this.tc.setConverter(this.converters.peek());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
        } else {
            for (String lang : this.langAttrs) {
                if (attributes.getValue(lang) == null) continue;
                this.language = attributes.getValue(lang);
                break;
            }
            this.elements.push(new String[]{name, new String(this.language)});
            this.contentHandler.startElement(uri, name, raw, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String raw) throws SAXException {
        for (String[] ft : this.flowTerminators) {
            if (!ft[0].equals(uri) || !name.matches(ft[1]) || this.flushingBuffer || "milestone".equals(ft[2])) continue;
            this.eventBufferOn = false;
            this.flushingBuffer = true;
            this.flushEventBuffer();
            this.flushingBuffer = false;
            break;
        }
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"endElement", uri, name, raw});
        } else if (NAMESPACE.equals(uri) && name.equals(TC_NAME)) {
            this.languages.pop();
            this.language = this.languages.peek();
            if (this.parsers.size() > 1) {
                this.parsers.pop();
                try {
                    this.tc.setParser(this.parsers.peek());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if (this.converters.size() > 1) {
                this.converters.pop();
                try {
                    this.tc.setConverter(this.converters.peek());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
        } else {
            String[] elt;
            this.elements.pop();
            this.language = "eng";
            if (this.elements.size() > 0 && (elt = this.elements.peek())[1] != null) {
                this.language = elt[1];
            }
            this.contentHandler.endElement(uri, name, raw);
        }
    }

    @Override
    public void characters(char[] c, int start, int len) throws SAXException {
        block10: {
            try {
                if (this.eventBufferOn) {
                    int offset = this.charBuffer.length();
                    this.charBuffer.append(c, start, len);
                    char[] ctmp = new char[]{};
                    this.eventBuffer.add(new Object[]{"characters", ctmp, offset, len});
                    break block10;
                }
                if (this.charBuffer.length() > 0) {
                    if (this.tc.getParser().supportsLanguage(this.language)) {
                        String out = "";
                        try {
                            out = this.tc.getString(this.charBuffer, start, len);
                            this.contentHandler.characters(out.toCharArray(), 0, out.length());
                            break block10;
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    }
                    this.contentHandler.characters(this.charBuffer.substring(start, start + len).toCharArray(), 0, len);
                    break block10;
                }
                if (this.tc.getParser().supportsLanguage(this.language)) {
                    String out = "";
                    try {
                        out = this.tc.getString(new String(c, start, len));
                        this.contentHandler.characters(out.toCharArray(), 0, out.length());
                        break block10;
                    }
                    catch (Exception e) {
                        throw new SAXException(e);
                    }
                }
                this.contentHandler.characters(c, start, len);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException(e);
            }
        }
    }

    private synchronized void flushEventBuffer() throws SAXException {
        while (!this.eventBuffer.isEmpty()) {
            Object[] o = this.eventBuffer.remove(0);
            Method[] methods = this.getClass().getMethods();
            try {
                Method m = null;
                for (int j = 0; j < methods.length; ++j) {
                    if (!o[0].equals(methods[j].getName())) continue;
                    m = methods[j];
                }
                if (o.length > 1) {
                    Object[] params = new Object[o.length - 1];
                    System.arraycopy(o, 1, params, 0, params.length);
                    m.invoke((Object)this, params);
                    continue;
                }
                m.invoke((Object)this, (Object[])null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException(e);
            }
        }
        this.charBuffer = new StringBuffer();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"endPrefixMapping"});
        } else {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.eventBufferOn) {
            this.charBuffer.append(ch, start, length);
            char[] ctmp = new char[length];
            System.arraycopy(ch, start, ctmp, 0, length);
            this.eventBuffer.add(new Object[]{"ignorableWhitespace", ctmp, 0, length});
        } else {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"processingInstruction", target, data});
        } else {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"setDocumentLocator", locator});
        } else {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"skippedEntity", name});
        } else {
            this.contentHandler.skippedEntity(name);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"startPrefixMapping", prefix, uri});
        } else {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"comment", ch, start, length});
        } else {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"endCDATA"});
        } else {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void endDTD() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"endEntity", name});
        } else {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"startCDATA"});
        } else {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.eventBufferOn) {
            this.eventBuffer.add(new Object[]{"startEntity", name});
        } else {
            this.lexicalHandler.startEntity(name);
        }
    }
}

