/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder.xml.sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public class Serializer
extends DefaultHandler
implements LexicalHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected Locator fLocator;
    protected boolean fXML11;
    protected boolean fInCDATA;
    protected StringBuffer dtd = new StringBuffer();
    protected boolean milestone = false;

    public void setCanonical(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
        this.fOut = new PrintWriter(writer);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        this.fElementDepth = 0;
        this.fXML11 = false;
        this.fInCDATA = false;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.fElementDepth > 0) {
            this.fOut.print("<?");
            this.fOut.print(target);
            if (data != null && data.length() > 0) {
                this.fOut.print(' ');
                this.fOut.print(data);
            }
            this.fOut.print("?>");
            this.fOut.flush();
        }
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        if (this.milestone) {
            this.closeElement();
        }
        if (this.fElementDepth == 0) {
            String encoding = "UTF-8";
            if (this.fLocator != null) {
                if (this.fLocator instanceof Locator2) {
                    Locator2 locator2 = (Locator2)this.fLocator;
                    this.fXML11 = "1.1".equals(locator2.getXMLVersion());
                    encoding = locator2.getEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                }
                this.fLocator = null;
            }
            if (!this.fCanonical) {
                this.fOut.print("<?xml version=\"");
                this.fOut.print(this.fXML11 ? "1.1" : "1.0");
                this.fOut.print("\" encoding=\"");
                this.fOut.print(encoding);
                this.fOut.println("\"?>");
                this.fOut.print(this.dtd);
                this.fOut.flush();
            }
        }
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(raw);
        if (attrs != null) {
            attrs = this.sortAttributes(attrs);
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                this.fOut.print(' ');
                this.fOut.print(attrs.getQName(i));
                this.fOut.print("=\"");
                this.normalizeAndPrint(attrs.getValue(i), true);
                this.fOut.print('\"');
            }
        }
        if (!this.fCanonical) {
            this.milestone = true;
        } else {
            this.fOut.print(">");
        }
        this.fOut.flush();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.fCanonical) {
            this.closeElement();
        }
        if (!this.fInCDATA) {
            this.normalizeAndPrint(ch, start, length, false);
        } else {
            for (int i = 0; i < length; ++i) {
                this.fOut.print(ch[start + i]);
            }
        }
        this.fOut.flush();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
        this.fOut.flush();
    }

    public void endElement(String uri, String local, String raw) throws SAXException {
        --this.fElementDepth;
        if (this.milestone) {
            this.milestone = false;
            this.fOut.print("/>");
        } else {
            this.fOut.print("</");
            this.fOut.print(raw);
            this.fOut.print('>');
        }
        this.fOut.flush();
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
        throw ex;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dtd.append("<!DOCTYPE " + name);
        if (publicId != null && !"".equals(publicId)) {
            this.dtd.append(" PUBLIC \"" + publicId + "\"");
        }
        if (systemId != null && !"".equals(systemId)) {
            this.dtd.append(" SYSTEM \"" + systemId + "\"");
        }
    }

    public void endDTD() throws SAXException {
        this.dtd.append(">\n");
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.closeElement();
            this.fOut.print("<![CDATA[");
            this.fInCDATA = true;
        }
    }

    public void endCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fInCDATA = false;
            this.fOut.print("]]>");
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.fCanonical && this.fElementDepth > 0) {
            this.closeElement();
            this.fOut.print("<!--");
            for (int i = 0; i < length; ++i) {
                this.fOut.print(ch[start + i]);
            }
            this.fOut.print("-->");
            this.fOut.flush();
        }
    }

    protected Attributes sortAttributes(Attributes attrs) {
        AttributesImpl attributes = new AttributesImpl();
        int len = attrs != null ? attrs.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            int j;
            String name = attrs.getQName(i);
            int count = attributes.getLength();
            for (j = 0; j < count && name.compareTo(attributes.getQName(j)) >= 0; ++j) {
            }
            attributes.insertAttributeAt(j, name, attrs.getType(i), attrs.getValue(i));
        }
        return attributes;
    }

    protected void normalizeAndPrint(String s, boolean isAttValue) {
        int len = s != null ? s.length() : 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c, isAttValue);
        }
    }

    protected void normalizeAndPrint(char[] ch, int offset, int length, boolean isAttValue) {
        for (int i = 0; i < length; ++i) {
            this.normalizeAndPrint(ch[offset + i], isAttValue);
        }
    }

    protected void normalizeAndPrint(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String type, SAXParseException ex) {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void closeElement() {
        if (this.milestone) {
            this.milestone = false;
            this.fOut.print(">");
        }
    }

    static class ListNode {
        public String uri;
        public String local;
        public String raw;
        public String type;
        public String value;
        public ListNode next;

        public ListNode(String uri, String local, String raw, String type, String value) {
            this.uri = uri;
            this.local = local;
            this.raw = raw;
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return this.raw != null ? this.raw : this.local;
        }
    }

    private class AttributesImpl
    implements Attributes {
        private ListNode head;
        private ListNode tail;
        private int length;

        private AttributesImpl() {
        }

        public int getLength() {
            return this.length;
        }

        public int getIndex(String raw) {
            ListNode place = this.head;
            int index = 0;
            while (place != null) {
                if (place.raw.equals(raw)) {
                    return index;
                }
                ++index;
                place = place.next;
            }
            return -1;
        }

        public int getIndex(String uri, String local) {
            ListNode place = this.head;
            int index = 0;
            while (place != null) {
                if (place.uri.equals(uri) && place.local.equals(local)) {
                    return index;
                }
                ++index;
                place = place.next;
            }
            return -1;
        }

        public String getURI(int index) {
            ListNode node = this.getListNodeAt(index);
            return node != null ? node.uri : null;
        }

        public String getLocalName(int index) {
            ListNode node = this.getListNodeAt(index);
            return node != null ? node.local : null;
        }

        public String getQName(int index) {
            ListNode node = this.getListNodeAt(index);
            return node != null ? node.raw : null;
        }

        public String getType(int index) {
            ListNode node = this.getListNodeAt(index);
            return node != null ? node.type : null;
        }

        public String getType(String uri, String local) {
            ListNode node = this.getListNode(uri, local);
            return node != null ? node.type : null;
        }

        public String getType(String raw) {
            ListNode node = this.getListNode(raw);
            return node != null ? node.type : null;
        }

        public String getValue(int index) {
            ListNode node = this.getListNodeAt(index);
            return node != null ? node.value : null;
        }

        public String getValue(String uri, String local) {
            ListNode node = this.getListNode(uri, local);
            return node != null ? node.value : null;
        }

        public String getValue(String raw) {
            ListNode node = this.getListNode(raw);
            return node != null ? node.value : null;
        }

        public void addAttribute(String raw, String type, String value) {
            this.addAttribute(null, null, raw, type, value);
        }

        public void addAttribute(String uri, String local, String raw, String type, String value) {
            ListNode node = new ListNode(uri, local, raw, type, value);
            if (this.length == 0) {
                this.head = node;
            } else {
                this.tail.next = node;
            }
            this.tail = node;
            ++this.length;
        }

        public void insertAttributeAt(int index, String raw, String type, String value) {
            this.insertAttributeAt(index, null, null, raw, type, value);
        }

        public void insertAttributeAt(int index, String uri, String local, String raw, String type, String value) {
            if (this.length == 0 || index >= this.length) {
                this.addAttribute(uri, local, raw, type, value);
                return;
            }
            ListNode node = new ListNode(uri, local, raw, type, value);
            if (index < 1) {
                node.next = this.head;
                this.head = node;
            } else {
                ListNode prev = this.getListNodeAt(index - 1);
                node.next = prev.next;
                prev.next = node;
            }
            ++this.length;
        }

        public void removeAttributeAt(int index) {
            if (this.length == 0) {
                return;
            }
            if (index == 0) {
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                }
                --this.length;
            } else {
                ListNode prev = this.getListNodeAt(index - 1);
                ListNode node = this.getListNodeAt(index);
                if (node != null) {
                    prev.next = node.next;
                    if (node == this.tail) {
                        this.tail = prev;
                    }
                    --this.length;
                }
            }
        }

        public void removeAttribute(String raw) {
            this.removeAttributeAt(this.getIndex(raw));
        }

        public void removeAttribute(String uri, String local) {
            this.removeAttributeAt(this.getIndex(uri, local));
        }

        private ListNode getListNodeAt(int i) {
            ListNode place = this.head;
            while (place != null) {
                if (--i == -1) {
                    return place;
                }
                place = place.next;
            }
            return null;
        }

        public ListNode getListNode(String uri, String local) {
            if (uri != null && local != null) {
                ListNode place = this.head;
                while (place != null) {
                    if (place.uri != null && place.local != null && place.uri.equals(uri) && place.local.equals(local)) {
                        return place;
                    }
                    place = place.next;
                }
            }
            return null;
        }

        private ListNode getListNode(String raw) {
            if (raw != null) {
                ListNode place = this.head;
                while (place != null) {
                    if (place.raw != null && place.raw.equals(raw)) {
                        return place;
                    }
                    place = place.next;
                }
            }
            return null;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append('[');
            str.append("len=");
            str.append(this.length);
            str.append(", {");
            ListNode place = this.head;
            while (place != null) {
                str.append(place.toString());
                if (place.next != null) {
                    str.append(", ");
                }
                place = place.next;
            }
            str.append("}]");
            return str.toString();
        }
    }
}

