/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekParser;
import java.util.Properties;
import java.util.TreeMap;

public class UnicodeParser
extends AbstractGreekParser {
    private Properties up;
    private Properties ga;
    private StringBuffer strb = new StringBuffer();
    private TreeMap<String, String> map = new TreeMap();

    public UnicodeParser() {
        this.up = new Properties();
        this.ga = new Properties();
        try {
            Class<?> c = this.getClass();
            this.up.load(c.getResourceAsStream("UnicodeParser.properties"));
            this.ga.load(c.getResourceAsStream("GreekAccents.properties"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public String next() {
        this.strb.delete(0, this.strb.length());
        if (this.in != null && this.hasNext()) {
            this.strb.append(this.lookup(this.chArray[this.index]));
            ++this.index;
            if (this.chArray[this.index - 1] == '\u03c3' || this.chArray[this.index - 1] == '\u03c2') {
                switch (this.chArray[this.index - 1]) {
                    case '\u03c3': {
                        if (this.hasNext() && Character.isLetter(this.chArray[this.index])) break;
                        this.strb.append("Fixed");
                        break;
                    }
                    case '\u03c2': {
                        if (!this.hasNext() || !Character.isLetter(this.chArray[this.index])) break;
                        this.strb.append("Fixed");
                    }
                }
            } else if (this.chArray[this.index - 1] == '\u03f2') {
                if (!this.hasNext() || !Character.isLetter(this.chArray[this.index])) {
                    this.strb.append("Final");
                } else {
                    this.strb.append("Medial");
                }
            } else if (this.hasNext() && this.isCombiningDiacritical(this.chArray[this.index])) {
                this.map.clear();
                while (this.index < this.chArray.length && this.isCombiningDiacritical(this.chArray[this.index])) {
                    this.map.put(this.lookupAccent(this.chArray[this.index]), this.lookup(this.chArray[this.index]));
                    ++this.index;
                }
                while (!this.map.isEmpty()) {
                    this.strb.append("_" + this.map.remove(this.map.firstKey()));
                }
            }
        }
        return this.strb.toString();
    }

    private String lookup(char ch) {
        String key = String.valueOf(ch);
        return this.up.getProperty(key, key);
    }

    private String lookupAccent(char ch) {
        String key = String.valueOf(ch);
        char i = ch;
        String result = this.lookup(ch);
        return this.ga.getProperty(this.lookup(ch));
    }

    private boolean isCombiningDiacritical(char ch) {
        switch (ch) {
            case '\u0300': 
            case '\u0301': 
            case '\u0303': 
            case '\u0308': 
            case '\u0313': 
            case '\u0314': 
            case '\u0342': 
            case '\u0345': {
                return true;
            }
        }
        return false;
    }
}

