/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekConverter;
import edu.unc.epidoc.transcoder.Parser;
import java.util.Properties;

public class SPIonicConverter
extends AbstractGreekConverter {
    private Properties sgp;

    public SPIonicConverter() {
        this.encoding = "US-ASCII";
        this.sgp = new Properties();
        try {
            Class<?> c = this.getClass();
            this.sgp.load(c.getResourceAsStream("SPIonicConverter.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String convertToCharacterEntities(Parser in) {
        StringBuffer result = new StringBuffer();
        char[] chars = this.convertToString(in).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch > '\u007f') {
                result.append("&#x" + Integer.toHexString(ch) + ";");
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    public String convertToString(Parser in) {
        StringBuffer result = new StringBuffer();
        while (in.hasNext()) {
            String convert = in.next();
            if (convert.indexOf(95) > 0 && convert.length() > 1) {
                int i;
                String[] elements = this.split(convert);
                String narrowWide = this.isCharacterNarrow(elements[0]) ? "narrow" : "wide";
                String temp = elements[1];
                if (elements.length == 2) {
                    if (this.sgp.getProperty(temp = temp + "_" + narrowWide) != null) {
                        result.append(this.sgp.getProperty(elements[0], this.unrec) + this.sgp.getProperty(temp, this.unrec));
                        for (i = 2; i < elements.length; ++i) {
                            result.append(this.sgp.getProperty(elements[i], this.unrec));
                        }
                        continue;
                    }
                    for (i = 0; i < elements.length; ++i) {
                        result.append(this.sgp.getProperty(elements[i], this.unrec));
                    }
                    continue;
                }
                if (this.sgp.getProperty(temp = temp + "_" + elements[2] + "_" + narrowWide) != null) {
                    result.append(this.sgp.getProperty(elements[0], this.unrec) + this.sgp.getProperty(temp, this.unrec));
                    for (i = 3; i < elements.length; ++i) {
                        result.append(this.sgp.getProperty(elements[i], this.unrec));
                    }
                    continue;
                }
                for (i = 0; i < elements.length; ++i) {
                    result.append(this.sgp.getProperty(elements[i], this.unrec));
                }
                continue;
            }
            if (convert.length() > 1) {
                result.append(this.sgp.getProperty(convert, this.unrec));
                continue;
            }
            result.append(this.sgp.getProperty(convert, convert));
        }
        return result.toString();
    }

    private boolean isCharacterNarrow(String ch) {
        return ch.equals("iota") || ch.equals("epsilon");
    }
}

