/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekParser;
import java.util.Properties;
import java.util.TreeMap;

public class OOGreekKeysParser
extends AbstractGreekParser {
    private Properties gkp;
    private Properties ga;
    private StringBuffer strb = new StringBuffer();
    private TreeMap<String, String> map = new TreeMap();

    public OOGreekKeysParser() {
        this.encoding = "ISO8859_1";
        this.gkp = new Properties();
        this.ga = new Properties();
        try {
            Class<?> c = this.getClass();
            this.gkp.load(c.getResourceAsStream("OOGreekKeysParser.properties"));
            this.ga.load(c.getResourceAsStream("GreekAccents.properties"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public String next() {
        this.strb.delete(0, this.strb.length());
        if (this.in != null && this.hasNext()) {
            if (!this.isPrefixDiacritical(this.chArray[this.index])) {
                this.strb.append(this.lookup(this.chArray[this.index]));
            }
            ++this.index;
            if (this.chArray[this.index - 1] == 's' || this.chArray[this.index - 1] == 'w') {
                if (!this.hasNext() || !Character.isLetter(this.chArray[this.index])) {
                    this.strb.append("Fixed");
                }
            } else if (this.hasNext() && this.isPrefixDiacritical(this.chArray[this.index - 1])) {
                if (Character.isLetter(this.chArray[this.index])) {
                    this.strb.append(this.lookup(this.chArray[this.index]));
                    this.strb.append("_" + this.lookup(this.chArray[this.index - 1]));
                    ++this.index;
                } else {
                    this.strb.append(this.lookup(this.chArray[this.index - 1]));
                }
            } else if (this.hasNext() && this.isPostCombiningDiacritical(this.chArray[this.index])) {
                this.map.clear();
                while (this.isPostCombiningDiacritical(this.chArray[this.index])) {
                    this.map.put(this.lookupAccent(this.chArray[this.index]), this.lookup(this.chArray[this.index]));
                    ++this.index;
                }
                while (!this.map.isEmpty()) {
                    this.strb.append("_" + this.map.remove(this.map.firstKey()));
                }
            }
        }
        return this.strb.toString();
    }

    private String lookup(char ch) {
        String key = String.valueOf(ch);
        return this.gkp.getProperty(key, key);
    }

    private String lookupAccent(char ch) {
        String key = String.valueOf(ch);
        return this.ga.getProperty(this.lookup(ch));
    }

    private boolean isPostCombiningDiacritical(char ch) {
        switch (ch) {
            case '+': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    private boolean isPrefixDiacritical(char ch) {
        switch (ch) {
            case '\u0080': 
            case '\u0081': 
            case '\u0082': 
            case '\u0083': 
            case '\u0084': 
            case '\u0085': 
            case '\u0086': 
            case '\u0087': 
            case '\u0088': 
            case '\u0089': 
            case '\u008a': {
                return true;
            }
        }
        return false;
    }
}

