/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekConverter;
import edu.unc.epidoc.transcoder.MapReader;
import edu.unc.epidoc.transcoder.Parser;
import java.io.UnsupportedEncodingException;

public class GreekKeysConverter
extends AbstractGreekConverter {
    private MapReader reader;

    public GreekKeysConverter() {
        this.encoding = "Cp1252";
        this.reader = new MapReader();
        this.reader.load("GreekKeysConverter.properties", this.encoding);
    }

    public String convertToCharacterEntities(Parser in) {
        StringBuffer result = new StringBuffer();
        char[] chars = this.convertToString(in).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch > '\u007f') {
                result.append("&#x" + Integer.toHexString(ch) + ";");
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    private byte[] doConversion(String in) {
        String temp = this.reader.get(in);
        byte[] result = null;
        if (temp != null) {
            if (temp.length() > 1) {
                try {
                    int i = Integer.parseInt(temp, 16);
                    result = new byte[]{(byte)i};
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = this.unrec.getBytes();
                }
            } else {
                result = temp.getBytes();
            }
        } else {
            result = in.length() > 1 ? this.unrec.getBytes() : in.getBytes();
        }
        if ("elisionMark".equals(in)) {
            System.out.println("elision: " + result.length);
        }
        return result;
    }

    public String convertToString(Parser in) {
        byte[] b = null;
        StringBuffer result = new StringBuffer();
        while (in.hasNext()) {
            String convert = in.next();
            char[] chars = convert.toCharArray();
            if (Character.isUpperCase(chars[0]) && convert.indexOf(95) > 0) {
                String letter = convert.substring(0, convert.indexOf(95));
                String diacriticals = convert.substring(convert.indexOf(95) + 1);
                byte[] d = this.doConversion(diacriticals);
                byte[] l = this.doConversion(letter);
                b = new byte[d.length + l.length];
                System.arraycopy(d, 0, b, 0, d.length);
                System.arraycopy(l, 0, b, d.length, l.length);
            } else {
                b = this.doConversion(convert);
            }
            try {
                result.append(new String(b, "ISO8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return result.toString();
    }
}

