/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.epidoc.transcoder;

import edu.unc.epidoc.transcoder.AbstractGreekParser;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;

public class BetaCodeParser
extends AbstractGreekParser {
    private static final HashMap<String, Properties> properties = new HashMap();
    private Properties bcp;
    private Properties ga;
    private StringBuffer strb = new StringBuffer();
    private TreeMap<String, String> map = new TreeMap();
    private StringBuffer escape = new StringBuffer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BetaCodeParser() {
        this.encoding = "US-ASCII";
        if (properties.isEmpty()) {
            this.bcp = new Properties();
            this.ga = new Properties();
            HashMap<String, Properties> hashMap = properties;
            synchronized (hashMap) {
                try {
                    Class<?> c = this.getClass();
                    this.bcp.load(c.getResourceAsStream("BetaCodeParser.properties"));
                    this.ga.load(c.getResourceAsStream("GreekAccents.properties"));
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace(System.out);
                }
                properties.put("bcp", this.bcp);
                properties.put("ga", this.ga);
            }
        }
        this.bcp = properties.get("bcp");
        this.ga = properties.get("ga");
    }

    public String next() {
        block14: {
            char ch;
            block15: {
                block17: {
                    block16: {
                        String result;
                        this.strb.delete(0, this.strb.length());
                        if (this.in == null) break block14;
                        ch = this.chArray[this.index];
                        ++this.index;
                        this.map.clear();
                        this.escape.delete(0, this.escape.length());
                        if (!this.hasNext() || !BetaCodeParser.isBetaCodePrefix(ch)) break block15;
                        if (!Character.isDigit(this.chArray[this.index]) && !BetaCodeParser.isBetaCodePrefix(this.chArray[this.index])) break block16;
                        this.escape.append(ch);
                        if (BetaCodeParser.isBetaCodePrefix(this.chArray[this.index])) {
                            this.escape.append(this.chArray[this.index]);
                            ++this.index;
                        }
                        if (this.hasNext()) {
                            while (this.hasNext() && Character.isDigit(this.chArray[this.index])) {
                                this.escape.append(this.chArray[this.index]);
                                ++this.index;
                            }
                        }
                        if ((result = this.lookup(this.escape.toString())).equals(this.escape.toString())) {
                            this.index -= this.escape.length() - 1;
                            this.escape.delete(1, this.escape.length());
                        }
                        this.strb.append(this.lookup(this.escape.toString()));
                        break block14;
                    }
                    if (ch != '#' || !Character.isLetter(this.chArray[this.index])) break block17;
                    this.strb.append(this.lookup(ch));
                    break block14;
                }
                while (this.hasNext() && BetaCodeParser.isBetaCodeDiacritical(this.chArray[this.index])) {
                    this.map.put(this.lookupAccent(this.chArray[this.index]), this.lookup(this.chArray[this.index]));
                    ++this.index;
                }
                if (!this.hasNext()) break block14;
                this.strb.append(this.lookup(this.lookup(ch) + String.valueOf(this.chArray[this.index])));
                ++this.index;
                while (!this.map.isEmpty()) {
                    String str = this.map.remove(this.map.firstKey());
                    this.strb.append("_").append(str);
                }
                break block14;
            }
            if (ch == 'S' || ch == 's') {
                if (this.index < this.chArray.length && Character.isDigit(this.chArray[this.index])) {
                    this.escape.append(ch);
                    this.escape.append(this.chArray[this.index]);
                    ++this.index;
                    this.strb.append(this.lookup(this.escape.toString()));
                } else if (!this.isTerminalSigma(this.chArray, this.index)) {
                    this.strb.append(this.lookup(ch));
                } else {
                    this.strb.append(this.lookup(String.valueOf(ch) + "2"));
                }
            } else {
                this.strb.append(this.lookup(ch));
                while (this.hasNext() && BetaCodeParser.isBetaCodeDiacritical(this.chArray[this.index])) {
                    this.map.put(this.lookupAccent(this.chArray[this.index]), this.lookup(this.chArray[this.index]));
                    ++this.index;
                }
                while (this.map.size() > 0) {
                    String str = this.map.remove(this.map.firstKey());
                    this.strb.append("_").append(str);
                }
            }
        }
        return this.strb.toString();
    }

    protected boolean isTerminalSigma(char[] chArray, int index) {
        if (index >= chArray.length) {
            return true;
        }
        char ch = chArray[index];
        if (Character.isLetter(ch)) {
            return false;
        }
        int i = 0;
        while (i + index < chArray.length) {
            if (Character.isWhitespace(chArray[index + i])) {
                return true;
            }
            if (Character.isLetter(chArray[index + i])) {
                return false;
            }
            if (chArray[index + i] == '-') {
                return false;
            }
            if (BetaCodeParser.isPunctuation(chArray[index + i])) {
                return true;
            }
            if (chArray[index + i] == '\'') {
                return false;
            }
            if (i + index == chArray.length - 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String lookup(char ch) {
        char chr = ch;
        if (Character.isLowerCase(chr)) {
            chr = Character.toUpperCase(chr);
        }
        String key = String.valueOf(chr);
        return this.bcp.getProperty(key, String.valueOf(ch));
    }

    protected String lookup(String key) {
        return this.bcp.getProperty(key.toUpperCase(), key);
    }

    protected String lookupAccent(char ch) {
        String key = String.valueOf(ch);
        return this.ga.getProperty(this.lookup(key));
    }

    protected static boolean isBetaCodeDiacritical(char ch) {
        switch (ch) {
            case '(': 
            case ')': 
            case '+': 
            case '/': 
            case '=': 
            case '\\': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isBetaCodePrefix(char ch) {
        switch (ch) {
            case '#': 
            case '%': 
            case '*': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isPunctuation(char ch) {
        switch (ch) {
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

