/*
Copyright 2005-2013 Samuel Gesche

This file is part of ArcEnCiel.

ArcEnCiel is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ArcEnCiel is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ArcEnCiel.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.townto;

/**
 * This exception is thrown when adding a link in a graph failed.
 *
 * @author Samuel Gesche
 * @version 1.4
 * @since Towntology 1.0
 */
public class LinkFailureException
    extends Exception{

  /**
   * Creates an exception with no message an no cause.
   * @since Towntology 1.0
   */
  public LinkFailureException(){
  }

  /**
   * Creates an exception with a detailed message.
   * @param message the message of the exception.
   * @since Towntology 1.0
   */
  public LinkFailureException(String message){
    super(message);
  }

  /**
   * Creates an exception with a detailed message and a cause.
   * @param message the message of the exception.
   * @param cause the cause of the exception.
   * @since Towntology 1.0
   */
  public LinkFailureException(String message, Throwable cause){
    super(message, cause);
  }

  /**
   * Creates an exception with a cause.
   * @param cause the cause of the exception.
   * @since Towntology 1.0
   */
  public LinkFailureException(Throwable cause){
    super(cause);
  }

}
